package gov.va.med.pharmacy.peps.service.common.update.impl;

import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.BooleanUtils;

import gov.va.med.pharmacy.peps.common.vo.DispenseUnitPerDoseVo;
import gov.va.med.pharmacy.peps.common.vo.DosageFormUnitVo;
import gov.va.med.pharmacy.peps.common.vo.DosageFormVo;
import gov.va.med.pharmacy.peps.common.vo.FieldKey;
import gov.va.med.pharmacy.peps.common.vo.ManagedDataVo;
import gov.va.med.pharmacy.peps.common.vo.ManagedItemVo;
import gov.va.med.pharmacy.peps.common.vo.PossibleDosagesPackageVo;
import gov.va.med.pharmacy.peps.common.vo.RequestItemStatus;
import gov.va.med.pharmacy.peps.common.vo.UserVo;
import gov.va.med.pharmacy.peps.common.vo.diff.Difference;
import gov.va.med.pharmacy.peps.external.common.preencapsulation.utility.update.item.DosageFormConverter;
import gov.va.med.pharmacy.peps.external.common.utility.MumpsConverter;
import gov.va.med.pharmacy.peps.external.common.vo.outbound.common.ItemAction;
import gov.va.med.pharmacy.peps.service.common.update.NdfFileSyncProcessor;

public class DosageFormNdfFileSyncProcessor extends AbstractSimpleNdfFileSyncProcessor implements NdfFileSyncProcessor{
    
    /** FIELDS */
    private static final org.apache.logging.log4j.Logger LOG = org.apache.logging.log4j.LogManager
        .getLogger(DosageFormNdfFileSyncProcessor.class);
    
    private static final String NAME_FIELD = ".01";
    private static final String INACTIVATION_DATE_FIELD = "7";
    private static final String EXCLUDE_FROM_DOSE_CHECK_FIELD = "11";
    private static final String UNTIS_FIELD = "8,.01";
    private static final String UNITS_PACKAGE_FIELD = "8,1";
    private static final String DISPENSE_UNIT_PER_DOSE_FIELD = "9,.01";
    private static final String DISPENSE_UNIT_PACKAGE_FIELD = "9,1";
    private static final String I_INPATIENT = "I-Inpatient";
    
    private String user;
    private String ien;
    

    DosageFormConverter dosageFormConverter;
   
    public DosageFormNdfFileSyncProcessor(Set<FieldKey> fields, String fileNumber, String fieldAddNumber) {
        super(fields, fileNumber, fieldAddNumber);        
    }
    
    @Override
    public void processNew(ManagedDataVo managedData) {
        // TODO Auto-generated method stub
    }

    @Override
    public void processNew(ManagedItemVo managedItem, UserVo user) {
        
        DosageFormVo dosageFormVo = (DosageFormVo) managedItem;
        
        if (RequestItemStatus.APPROVED.equals(dosageFormVo.getRequestItemStatus()) && dosageFormVo.getValue() != null) {
            
            // IEN
            setIen(dosageFormVo.getDosageFormIen());
            
            //User
            setUser(user.getUsername());
            
            
            //NAME_FIELD
            insertNewElement(getIen(),dosageFormVo.getDosageFormName(), getUser() );
        
            insertNewChildElement(getIen(),
                dosageFormVo.getExcludeFromDosageChks() != null ? convertYesNo(dosageFormVo.getExcludeFromDosageChks().toString()) : " ",
                              getUser(),EXCLUDE_FROM_DOSE_CHECK_FIELD);
            
            //process Dispense Unit if present
            if (dosageFormVo.getDfDispenseUnitsPerDose().size() > 0){
                processInsertDispenseUnitFields(dosageFormVo);
            }
            
            //process Units if present
            if (dosageFormVo.getDfUnits().size() > 0){
                processInsertDfUnitFields(dosageFormVo);
            }
        }

    }
     
    @Override
    public void processModified(ManagedDataVo managedData) {
        // TODO Auto-generated method stub
        
    }

    @Override
    public void processModified(ManagedItemVo managedItem, UserVo user, Collection<Difference> differences) {
        
        Map<FieldKey, Difference> setDifference =  super.toSetDifference(differences);
        boolean hasDifference = DosageFormConverter.hasNewOrModifiedFields(super.getFields(), setDifference, ItemAction.MODIFY);

        DosageFormVo dosageFormVo = (DosageFormVo) managedItem;

        if (hasDifference) 
        {
            if (RequestItemStatus.APPROVED.equals(dosageFormVo.getRequestItemStatus()) && dosageFormVo.getValue() != null) 
            {
               
                setIen(dosageFormVo.getDosageFormIen());
                
                setUser(user.getUsername());
                
                //Exclude From Dosage Checks
                if(DosageFormConverter.fieldWasModified(FieldKey.EXCLUDE_FROM_DOSAGE_CHKS, differences)){
                            insertModifiedElement(getIen(),
                            dosageFormVo.getExcludeFromDosageChks() != null ? convertYesNo(dosageFormVo.getExcludeFromDosageChks().toString()) : " ", 
                            getUser(), EXCLUDE_FROM_DOSE_CHECK_FIELD, null);
                }
                // Inactivation date
                if (DosageFormConverter.fieldWasModified(FieldKey.ITEM_STATUS, differences)){
                        processActivationDate(dosageFormVo);
                 }
                //Dispense Units
                if(DosageFormConverter.fieldWasModified(FieldKey.DF_DISPENSE_UNITS_PER_DOSE, differences)) {
                    processModifyDispenseUnitFields(dosageFormVo, differences);
                }

                //Units
                if(DosageFormConverter.fieldWasModified(FieldKey.DF_UNITS, differences)){
                    processModifyDfUnitFields(dosageFormVo, differences);
                }
            }
       }
    }

    /**
     * @param dosageFormVo
     * @return
     */
    private void processActivationDate(DosageFormVo dosageFormVo) {
        if(dosageFormVo.getInactivationDate() != null){
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(dosageFormVo.getInactivationDate());
            insertModifiedElement(getIen(), MumpsConverter.convertDate(c.getTime()), getUser(),INACTIVATION_DATE_FIELD,null);
        }else
            processReactivated(dosageFormVo);
    }

    /**
     * process dispense unit children - vista file 50.6069 #9
     * @param dosageFormVo
     * @param diffObj
     */
    private void processInsertDispenseUnitFields(DosageFormVo dosageFormVo) {
        
        Iterator<DispenseUnitPerDoseVo> dfuIterator = dosageFormVo.getDfDispenseUnitsPerDose().iterator();
        while (dfuIterator.hasNext()){
            DispenseUnitPerDoseVo dupd = dfuIterator.next(); 
          
            insertNewChildElement(getIen() + ","+ dupd.getStrDispenseUnitPerDose(), dupd.getStrDispenseUnitPerDose(),
                getUser(), DISPENSE_UNIT_PER_DOSE_FIELD); 
             
            if(dupd.getPackages().size()>0){
                processInsertPackageFields(dupd.getPackages(), dupd.getStrDispenseUnitPerDose(), DISPENSE_UNIT_PACKAGE_FIELD);
            }
        }
    }
    
    /**
     * process units children - vista file 50.6068P #8
     * @param dosageFormVo
     * @param diffObj
     */
    private void processInsertDfUnitFields(DosageFormVo dosageFormVo) {
        
        Iterator<DosageFormUnitVo> dfUnitIterator = dosageFormVo.getDfUnits().iterator();
        while (dfUnitIterator.hasNext()) {
             DosageFormUnitVo dfUnit = dfUnitIterator.next();

             insertNewChildElement(getIen() + "," + dfUnit.getDrugUnit().getDrugUnitIen(), 
                 dfUnit.getDrugUnit().getDrugUnitIen(), getUser(),UNTIS_FIELD);

           if(dfUnit.getPackages().size()>0){
                processInsertPackageFields(dfUnit.getPackages(), dfUnit.getDrugUnit().getDrugUnitIen(), UNITS_PACKAGE_FIELD);
            }
          
        }
    }

    /**
     * process dispense unit children - vista file 50.6069 #9
     * @param dosageFormVo
     * @param diffObj
     */
    private void processModifyDispenseUnitFields(DosageFormVo dosageFormVo, Collection<Difference> differences) {
        checkForDeletedDispenseUnit(differences);
        for (DispenseUnitPerDoseVo dupd : dosageFormVo.getDfDispenseUnitsPerDose()) {
            insertModifiedElement(getIen() + ","+ dupd.getStrDispenseUnitPerDose(),dupd.getStrDispenseUnitPerDose(),getUser(),
                DISPENSE_UNIT_PER_DOSE_FIELD, null);
             
            if(dupd.getPackages().size()>0){
                processModifyPackageFields(dupd.getPackages(), dupd.getStrDispenseUnitPerDose(), DISPENSE_UNIT_PACKAGE_FIELD);
            }
        }
    }

    /**
     * Generate a blank record for any removed dispense units
     * 
     * @param differences
     * @param dupd
     */
    private void checkForDeletedDispenseUnit(Collection<Difference> differences) {

        boolean foundMatch = false;
       for (Difference difference : differences){
             if(difference.getFieldKey().equals(FieldKey.DF_DISPENSE_UNITS_PER_DOSE )){
                List<DispenseUnitPerDoseVo> oldList =  (List<DispenseUnitPerDoseVo>) difference.getOldValue();
                List<DispenseUnitPerDoseVo> newList = (List<DispenseUnitPerDoseVo>) difference.getNewValue();
                for (DispenseUnitPerDoseVo oldItem : oldList) {
                    foundMatch = false;
                    for (DispenseUnitPerDoseVo newItem : newList) {
                        if(oldItem.getStrDispenseUnitPerDose().equals(newItem.getStrDispenseUnitPerDose())){
                            foundMatch = true;
                            return;
                        }
                    }
                    if (!foundMatch){
                        insertModifiedElement(getIen() + ","+ oldItem.getStrDispenseUnitPerDose()," ",getUser(),
                            DISPENSE_UNIT_PER_DOSE_FIELD, null);  
                        
                        if(oldItem.getPackages().size()>0){
                            insertModifiedElement(getIen() + ","+oldItem.getStrDispenseUnitPerDose(), " ",getUser(),
                                DISPENSE_UNIT_PACKAGE_FIELD, null);
                        }
                    }
                }
            }
        }

    }
   
    /**
     * process units children - vista file 50.6068P #8
     * @param dosageFormVo
     * @param diffObj
     */
    private void processModifyDfUnitFields(DosageFormVo dosageFormVo, Collection<Difference> differences) {
        
        checkForDeletedUnit(differences);
        
        for (DosageFormUnitVo dfUnit : dosageFormVo.getDfUnits()) {          
            
             insertModifiedElement(getIen() + "," + dfUnit.getDrugUnit().getDrugUnitIen(), 
                                  dfUnit.getDrugUnit().getDrugUnitIen(),getUser(),UNTIS_FIELD, null);
            if(dfUnit.getPackages().size()>0){
                processModifyPackageFields(dfUnit.getPackages(), dfUnit.getDrugUnit().getDrugUnitIen(), UNITS_PACKAGE_FIELD);
            }
        }
    }

    /**
     * Generate a blank record for any removed units
     * 
     * @param differences
     * @param dfu
     */
    private void checkForDeletedUnit(Collection<Difference> differences) {
       boolean foundMatch = false;
        
        for (Difference difference : differences){
             if(difference.getFieldKey().equals(FieldKey.DF_UNITS )){
                List<DosageFormUnitVo> oldList =  (List<DosageFormUnitVo>) difference.getOldValue();
                List<DosageFormUnitVo> newList = (List<DosageFormUnitVo>) difference.getNewValue();
                for (DosageFormUnitVo oldItem : oldList) {
                    foundMatch = false;
                    String dfUnitIen = null;
                    for (DosageFormUnitVo newItem : newList) {
                        dfUnitIen = newItem.getDrugUnit().getDrugUnitIen();
                        if(oldItem.getDrugUnit().equals(newItem.getDrugUnit())){
                            foundMatch = true;
                            return;
                        }
                    }
                    if (!foundMatch){
                        insertModifiedElement(getIen() + "," + dfUnitIen, " ",getUser(), UNTIS_FIELD, null);  
                        
                        if(oldItem.getPackages().size()>0){
                            insertModifiedElement(getIen() + "," + dfUnitIen, " ",getUser(),UNITS_PACKAGE_FIELD, null);
                        }
                    }
                }
            }
        }
     }

    /**
     * process dispense unit children - vista file 50.6069 #9
     * @param dosageFormVo
     * @param diffObj
     */
    private void processInsertPackageFields(Collection<PossibleDosagesPackageVo> packages, String dfUnitIen, String fieldName) {
     
        String newPackageValue =" ";
        if (packages.size() == 2) {
            newPackageValue = "IO";
        } else if (packages.size() == 1 
                && packages.iterator().next().getValue().contains(I_INPATIENT)) {
            newPackageValue = "I";
        } else if (packages.size() == 1) {
            newPackageValue = "O";
        }
        
        insertNewChildElement(getIen() + "," + dfUnitIen, newPackageValue,getUser(),fieldName);
    }

    
    /**
     * process dispense unit children - vista file 50.6069 #9
     * @param dosageFormVo
     * @param diffObj
     */
    private void processModifyPackageFields(Collection<PossibleDosagesPackageVo> packages, String dfUnitIen, String fieldName) 
    {
        
       String newPackageValue =" ";
        if (packages.size() == 2) {
            newPackageValue = "IO";
        } else if (packages.size() == 1 
                && packages.iterator().next().getValue().contains(I_INPATIENT)) {
            newPackageValue = "I";
        } else if (packages.size() == 1) {
            newPackageValue = "O";
        }
        
        insertModifiedElement(getIen() + "," + dfUnitIen, newPackageValue,getUser(),fieldName, null);
    }
    
    public void processReactivated(DosageFormVo dosageFormVo) {
        
        insertModifiedElement(getIen(),dosageFormVo.getDosageFormName(), getUser(),NAME_FIELD,null );
            
        insertModifiedElement(getIen(),
                dosageFormVo.getExcludeFromDosageChks() != null ? convertYesNo(dosageFormVo.getExcludeFromDosageChks().toString()) : " ",
                getUser(),EXCLUDE_FROM_DOSE_CHECK_FIELD, null);
            
        insertModifiedElement(getIen(), " ", getUser(),INACTIVATION_DATE_FIELD, null);
            
        //process Dispense Unit if present
        if (dosageFormVo.getDfDispenseUnitsPerDose().size() > 0){
            processInsertDispenseUnitFields(dosageFormVo);
        }
            
        //process Units if present
        if (dosageFormVo.getDfUnits().size() > 0){
            processInsertDfUnitFields(dosageFormVo);
        }
    }
    
    /**
     * convert YES NO to 1 or 0
     * @return string converted value
     */
    public static String convertYesNo(String value){
        
        return value == "YES" ?"1" : "0";
    }
    
    /**
     * @return the user
     */
    public String getUser() {
        return user;
    }

    /**
     * @param user the user to set
     */
    public void setUser(String user) {
        this.user = user;
    }
    
    /**
     * @return the ien
     */
    public String getIen() {
        return ien;
    }
    
    /**
     * @param ien the ien to set
     */
    public void setIen(String ien) {
        this.ien = ien;
    }
}   
    
    
    
    
    
    
    