

package gov.va.med.pharmacy.peps.service.common.update.impl;


import gov.va.med.pharmacy.peps.common.exception.ValidationException;
import gov.va.med.pharmacy.peps.common.vo.FieldKey;
import gov.va.med.pharmacy.peps.common.vo.diff.Difference;
import gov.va.med.pharmacy.peps.domain.common.capability.DrugSeverityDomainCapability;
import gov.va.med.pharmacy.peps.domain.common.model.EplNdfOutgoingDifferences;
import gov.va.med.pharmacy.peps.service.common.capability.NdfFileSyncCapability;

import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

import javax.annotation.Resource;


public abstract class AbstractSimpleNdfFileSyncProcessor {

    /** FIELDS */
    private static final org.apache.logging.log4j.Logger LOG = org.apache.logging.log4j.LogManager
        .getLogger(AbstractSimpleNdfFileSyncProcessor.class);
    private static final String ADD_ACTION = "A";
    private static final String MODIFY_ACTION = "M";     

    @Resource
    private NdfFileSyncCapability ndfFileSyncCapability;
    @Resource
    private DrugSeverityDomainCapability drugSeverityDomainCapability;

    private Set<FieldKey> fields;
    private String fileNumber;
    private String fieldAddNumber;

    public AbstractSimpleNdfFileSyncProcessor(Set<FieldKey> fields, String fileNumber, String fieldAddNumber) {
        this.fields = fields;
        this.fileNumber = fileNumber;
        this.fieldAddNumber = fieldAddNumber;

    }
    
    protected void insertNewElement(String vistaIen, String newValue, String userName){
        EplNdfOutgoingDifferences diffObj = new EplNdfOutgoingDifferences();
        diffObj.setVistaIen(vistaIen);
        diffObj.setNewValue(newValue);
        diffObj.setCreatedBy(userName);
        processInsert(diffObj); 
    }
    
    protected void insertModifiedElement(String vistaIen, String newValue, String userName, String fieldId, String oldValue){
        EplNdfOutgoingDifferences diffObj = new EplNdfOutgoingDifferences();
        diffObj.setVistaIen(vistaIen);
        diffObj.setNewValue(newValue);
        diffObj.setOldValue(oldValue);
        diffObj.setCreatedBy(userName);
        diffObj.setVistaFieldNumber(fieldId);
        processUpdate(diffObj); 
    }  
    
    protected void insertNewChildElement(String vistaIen, String newValue, String userName, String fieldId){
        EplNdfOutgoingDifferences diffObj = new EplNdfOutgoingDifferences();
        diffObj.setVistaIen(vistaIen);
        diffObj.setNewValue(newValue);
        diffObj.setCreatedBy(userName);
        diffObj.setVistaFieldNumber(fieldId);        
        processInsertChild(diffObj); 
    }    
    

    public void processInsert(EplNdfOutgoingDifferences diffObj){
        try {            
            populateCommonFields(diffObj,ADD_ACTION); 
            diffObj.setVistaFieldNumber(fieldAddNumber);
            ndfFileSyncCapability.saveNewItem(diffObj);            
        } catch (ValidationException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        
    }
    
    public void processUpdate(EplNdfOutgoingDifferences diffObj){
        try {            
            populateCommonFields(diffObj, MODIFY_ACTION );
            ndfFileSyncCapability.saveModifiedItem(diffObj);            
        } catch (ValidationException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        
    }
    
    public void processInsertChild(EplNdfOutgoingDifferences diffObj){
        try {            
            populateCommonFields(diffObj,ADD_ACTION);
            ndfFileSyncCapability.saveNewItem(diffObj);            
        } catch (ValidationException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        
    }
    
    public void processInsertRecord(EplNdfOutgoingDifferences diffObj, String actionType){
        try {            
            populateCommonFields(diffObj,actionType);
            ndfFileSyncCapability.saveNewItem(diffObj);            
        } catch (ValidationException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        
    }
    
    private EplNdfOutgoingDifferences populateCommonFields(EplNdfOutgoingDifferences diffObj, String Action){        
        diffObj.setVistaFileNumber(fileNumber);
        diffObj.setActionType(Action); 
        diffObj.setCreatedDtm(Calendar.getInstance().getTime());   
        return diffObj;
    }
   

    /**
     * Convert to a hashed set of Differences.
     * 
     * @param differences
     *            old/new value differences
     * @return set difference
     */
    protected Map<FieldKey, Difference> toSetDifference(Collection<Difference> differences) {
        Map<FieldKey, Difference> setDifference = new HashMap<FieldKey, Difference>();

        if (differences != null) { // null for 'add' operations
            for (Difference diff : differences) {
                setDifference.put(diff.getFieldKey(), diff);
            }
        }

        return setDifference;
    }
    
    
    protected LinkedHashMap<String, String> getSeverityMap(){
        return getDrugSeverityDomainCapability().getSeverityMap();
    }
      
    public void setNdfFileSyncCapability(NdfFileSyncCapability ndfFileSyncCapability) {
        this.ndfFileSyncCapability = ndfFileSyncCapability;

    }

    public NdfFileSyncCapability getNdfFileSyncCapability() {
        return ndfFileSyncCapability;
    }
    
    protected Set<FieldKey> getFields() {
        return fields;
    }
    
    public DrugSeverityDomainCapability getDrugSeverityDomainCapability() {
        return drugSeverityDomainCapability;
    }

    
    public void setDrugSeverityDomainCapability(DrugSeverityDomainCapability drugSeverityDomainCapability) {
        this.drugSeverityDomainCapability = drugSeverityDomainCapability;
    }

}
