

package gov.va.med.pharmacy.peps.service.common.update;


import gov.va.med.pharmacy.peps.common.utility.VistaFileNumber;
import gov.va.med.pharmacy.peps.common.vo.DispenseUnitVo;
import gov.va.med.pharmacy.peps.common.vo.DosageFormVo;
import gov.va.med.pharmacy.peps.common.vo.DrugClassVo;
import gov.va.med.pharmacy.peps.common.vo.DrugDrugInteractionVo;
import gov.va.med.pharmacy.peps.common.vo.DrugUnitVo;
import gov.va.med.pharmacy.peps.common.vo.FieldKey;
import gov.va.med.pharmacy.peps.common.vo.GenericNameVo;
import gov.va.med.pharmacy.peps.common.vo.IngredientVo;
import gov.va.med.pharmacy.peps.common.vo.ManufacturerVo;
import gov.va.med.pharmacy.peps.common.vo.NdcVo;
import gov.va.med.pharmacy.peps.common.vo.PackageSizeVo;
import gov.va.med.pharmacy.peps.common.vo.PackageTypeVo;
import gov.va.med.pharmacy.peps.common.vo.ProductVo;
import gov.va.med.pharmacy.peps.service.common.update.impl.DosageFormNdfFileSyncProcessor;
import gov.va.med.pharmacy.peps.service.common.update.impl.DrugDrugInteractionNdfFileSyncProcessor;
import gov.va.med.pharmacy.peps.service.common.update.impl.DrugIngredientsNdfFileSyncProcessor;
import gov.va.med.pharmacy.peps.service.common.update.impl.DrugUnitNdfFileSyncProcessor;
import gov.va.med.pharmacy.peps.service.common.update.impl.GenericObjectProcessor;
import gov.va.med.pharmacy.peps.service.common.update.impl.ManufacturerNdfFileSyncProcessor;
import gov.va.med.pharmacy.peps.service.common.update.impl.NdcNdfFileSyncProcessor;
import gov.va.med.pharmacy.peps.service.common.update.impl.PackageSizeNdfFileSyncProcessor;
import gov.va.med.pharmacy.peps.service.common.update.impl.PackageTypeNdfFileSyncProcessor;
import gov.va.med.pharmacy.peps.service.common.update.impl.VADispenseUnitNdfFileSyncProcessor;
import gov.va.med.pharmacy.peps.service.common.update.impl.VADrugClassNdfFileSyncProcessor;
import gov.va.med.pharmacy.peps.service.common.update.impl.VaGenericNameNdfFileSyncProcessor;
import gov.va.med.pharmacy.peps.service.common.update.impl.VaProductNdfFileSyncProcessor;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

import javax.annotation.Resource;


public class NdfFileSyncProcessorFactory {

    /**
     * Given the incoming Object, the appropriate NdfFileSyncProcessor implementation is determined
     * and returned.
     * 
     * @param clazz
     * @return NdfFileSyncProcessor
     */
    public static NdfFileSyncProcessor getProcessor(Object clazz) {
        NdfFileSyncProcessor processor = null;

        if (clazz instanceof PackageTypeVo) {
            /** FIELDS */
            final Set<FieldKey> fields = Collections.unmodifiableSet(new LinkedHashSet<FieldKey>(Arrays
                .asList(new FieldKey[] { FieldKey.VALUE, FieldKey.INACTIVATION_DATE, FieldKey.ITEM_STATUS })));
            processor = new PackageTypeNdfFileSyncProcessor(fields, VistaFileNumber.FIFTY_608.getFileNumber(), ".01");
        } else if (clazz instanceof PackageSizeVo) {
            /** FIELDS */
            final Set<FieldKey> fields = Collections.unmodifiableSet(new LinkedHashSet<FieldKey>(Arrays
                .asList(new FieldKey[] { FieldKey.VALUE, FieldKey.INACTIVATION_DATE })));
            processor = new PackageSizeNdfFileSyncProcessor(fields, VistaFileNumber.FIFTY_609.getFileNumber(), ".01");
        }
        else if (clazz instanceof ManufacturerVo) {
            final Set<FieldKey> fields = Collections.unmodifiableSet(new LinkedHashSet<FieldKey>(Arrays
                .asList(new FieldKey[] { FieldKey.VALUE, FieldKey.INACTIVATION_DATE, FieldKey.ITEM_STATUS })));
            processor = new ManufacturerNdfFileSyncProcessor(fields, VistaFileNumber.FIFTY_FIVE_95.getFileNumber(), ".01");
        }
        else if (clazz instanceof DispenseUnitVo) {
            final Set<FieldKey> fields = Collections.unmodifiableSet(new LinkedHashSet<FieldKey>(Arrays
                .asList(new FieldKey[] { FieldKey.VALUE, FieldKey.INACTIVATION_DATE, FieldKey.ITEM_STATUS })));
            processor = new VADispenseUnitNdfFileSyncProcessor(fields, VistaFileNumber.FIFTY_64.getFileNumber(), ".01");
        }
        else if (clazz instanceof DosageFormVo) {
            final Set<FieldKey> fields = Collections.unmodifiableSet(new LinkedHashSet<FieldKey>(Arrays
                .asList(new FieldKey[] { FieldKey.DOSAGE_FORM_NAME, FieldKey.LOCAL_MED_ROUTES, FieldKey.LOCAL_MEDICATION_ROUTE,
                    FieldKey.VERB, FieldKey.OTHER_LANGUAGE_VERB, FieldKey.PREPOSITION,
                    FieldKey.OTHER_LANGUAGE_PREPOSITION, FieldKey.DF_NOUNS, FieldKey.INACTIVATION_DATE,
                    FieldKey.DF_UNITS, FieldKey.DF_DISPENSE_UNITS_PER_DOSE, FieldKey.EXCLUDE_FROM_DOSAGE_CHKS,
                    FieldKey.CONJUNCTION, FieldKey.ITEM_STATUS })));
            processor = new DosageFormNdfFileSyncProcessor(fields, VistaFileNumber.FIFTY_606.getFileNumber(), ".01");
        }
        else if (clazz instanceof GenericNameVo) {
            final Set<FieldKey> fields = Collections.unmodifiableSet(new LinkedHashSet<FieldKey>(Arrays
                .asList(new FieldKey[] { FieldKey.GENERIC_NAME, FieldKey.INACTIVATION_DATE, FieldKey.ITEM_STATUS })));
            processor = new VaGenericNameNdfFileSyncProcessor(fields, VistaFileNumber.FIFTY_6.getFileNumber(), ".01");
        }
        else if (clazz instanceof DrugUnitVo) {
            final Set<FieldKey> fields = Collections.unmodifiableSet(new LinkedHashSet<FieldKey>(Arrays
                .asList(new FieldKey[] { FieldKey.VALUE, FieldKey.INACTIVATION_DATE, FieldKey.ITEM_STATUS })));
            processor = new DrugUnitNdfFileSyncProcessor(fields, VistaFileNumber.FIFTY_607.getFileNumber(), ".01");
        }
        else if (clazz instanceof NdcVo){
              final Set<FieldKey> fields = Collections.unmodifiableSet(new LinkedHashSet<FieldKey>(Arrays
                .asList(new FieldKey[] {
                    FieldKey.NDC, FieldKey.UPC_UPN, FieldKey.MANUFACTURER, FieldKey.TRADE_NAME, FieldKey.PRODUCT,
                    FieldKey.INACTIVATION_DATE, FieldKey.PACKAGE_SIZE, FieldKey.PACKAGE_TYPE, FieldKey.OTC_RX_INDICATOR,
                    FieldKey.ITEM_STATUS })));
              processor = new NdcNdfFileSyncProcessor(fields, VistaFileNumber.FIFTY_67.getFileNumber(), ".01");
        }
        else if (clazz instanceof IngredientVo) {
            final Set<FieldKey> fields = Collections.unmodifiableSet(new LinkedHashSet<FieldKey>(Arrays
                .asList(new FieldKey[] { FieldKey.VALUE, FieldKey.INACTIVATION_DATE, FieldKey.PRIMARY_INGREDIENT,
                                         FieldKey.MASTER_ENTRY_FOR_VUID, FieldKey.ITEM_STATUS })));
             
            processor = new DrugIngredientsNdfFileSyncProcessor(fields, VistaFileNumber.FIFTY_416.getFileNumber(), ".01");
        }
        else if (clazz instanceof DrugClassVo) {
            final Set<FieldKey> fields = Collections.unmodifiableSet(new LinkedHashSet<FieldKey>(Arrays
                .asList(new FieldKey[] { FieldKey.CODE, FieldKey.CLASSIFICATION, FieldKey.PARENT_DRUG_CLASS, 
                                         FieldKey.CLASSIFICATION_TYPE,FieldKey.DESCRIPTION, FieldKey.ITEM_STATUS })));

            processor = new VADrugClassNdfFileSyncProcessor(fields, VistaFileNumber.FIFTY_605.getFileNumber(), ".01");
        }
        else if (clazz instanceof DrugDrugInteractionVo) {
            final Set<FieldKey> fields = Collections.unmodifiableSet(new LinkedHashSet<FieldKey>(Arrays
                .asList(new FieldKey[] { FieldKey.VALUE, FieldKey.INACTIVATION_DATE, FieldKey.ITEM_STATUS })));
             
            processor = new DrugDrugInteractionNdfFileSyncProcessor(fields, VistaFileNumber.FIFTY_SIX.getFileNumber(), ".01");
        }
        
        else if (clazz instanceof ProductVo) {
            final Set<FieldKey> fields = Collections.unmodifiableSet(new LinkedHashSet<FieldKey>(Arrays
                .asList(new FieldKey[] { FieldKey.VA_PRODUCT_NAME, FieldKey.GENERIC_NAME, FieldKey.DOSAGE_FORM, FieldKey.PRODUCT_STRENGTH,
                    FieldKey.PRODUCT_UNIT, FieldKey.TRANSMIT_TO_CMOP,
                    FieldKey.ACTIVE_INGREDIENT, FieldKey.NATIONAL_FORMULARY_NAME, FieldKey.VA_PRINT_NAME,
                    FieldKey.CMOP_ID, FieldKey.CMOP_DISPENSE, FieldKey.DISPENSE_UNIT,
                    FieldKey.GCN_SEQUENCE_NUMBER, FieldKey.DRUG_CLASSES,
                    FieldKey.NATIONAL_FORMULARY_INDICATOR, FieldKey.CS_FED_SCHEDULE,
                    FieldKey.SINGLE_MULTISOURCE_PRODUCT, FieldKey.INACTIVATION_DATE,
                    FieldKey.EXCLUDE_DRG_DRG_INTERACTION_CHECK,
                    FieldKey.OVERRIDE_DF_DOSE_CHK_EXCLUSN, FieldKey.CREATE_POSSIBLE_DOSAGE,
                    FieldKey.PRODUCT_PACKAGE, FieldKey.FDA_MED_GUIDE, FieldKey.POSSIBLE_DOSAGES_AUTO_CREATE,
                    FieldKey.ORDERABLE_ITEM,    //  In order to get modifications to Dosage Form caused by changing Orderable Item.
                    FieldKey.ITEM_STATUS,
                    FieldKey.HAZARDOUS_TO_HANDLE, // Hazardous waste fields.
                    FieldKey.HAZARDOUS_TO_DISPOSE,
                    FieldKey.PRIMARY_EPA,
                    FieldKey.WASTE_SORT_CODE,
                    FieldKey.DOT_SHIPPING_NAME})));
            processor = new VaProductNdfFileSyncProcessor(fields, VistaFileNumber.FIFTY_68.getFileNumber(), ".01");
        }
        
        else {
            processor = new GenericObjectProcessor();
        }

        return processor;
    }

}
