package gov.va.med.pharmacy.peps.service.common.update;

import gov.va.med.pharmacy.peps.common.vo.ManagedDataVo;
import gov.va.med.pharmacy.peps.common.vo.ManagedItemVo;
import gov.va.med.pharmacy.peps.common.vo.UserVo;
import gov.va.med.pharmacy.peps.common.vo.diff.Difference;
import gov.va.med.pharmacy.peps.domain.common.capability.DrugSeverityDomainCapability;
import gov.va.med.pharmacy.peps.service.common.capability.NdfFileSyncCapability;

import java.util.Collection;


public interface NdfFileSyncProcessor {
    void processNew(ManagedDataVo managedData);
    void processNew(ManagedItemVo managedItem,UserVo user);
    void processModified(ManagedDataVo managedData);
    void processModified(ManagedItemVo managedItem,UserVo user,Collection<Difference> differences );     
    void setNdfFileSyncCapability(NdfFileSyncCapability ndfFileSyncCapability);
    void setDrugSeverityDomainCapability(DrugSeverityDomainCapability drugSeverityDomainCapability);
}
