package gov.va.med.pharmacy.peps.service.common.capability.impl;

import org.apache.commons.lang3.StringUtils;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.pharmacy.peps.common.exception.ValidationException;
import gov.va.med.pharmacy.peps.domain.common.dao.EplNdfOutgoingDifferencesDao;
import gov.va.med.pharmacy.peps.domain.common.model.EplNdfOutgoingDifferences;
import gov.va.med.pharmacy.peps.service.common.capability.NdfFileSyncCapability;



public class NdfFileSyncCapabilityImpl implements NdfFileSyncCapability{
    
    private EplNdfOutgoingDifferencesDao eplNdfOutgoingDifferencesDao;
    
    @Override
    @Transactional
    public void saveNewItem(EplNdfOutgoingDifferences eplNdfOutgoingDifferences) throws ValidationException {
        eplNdfOutgoingDifferencesDao.save(eplNdfOutgoingDifferences);        

    }

    @Override
    @Transactional
    public void saveModifiedItem(EplNdfOutgoingDifferences eplNdfOutgoingDifferences)
        throws ValidationException {
        
        EplNdfOutgoingDifferences returnedValue = 
            eplNdfOutgoingDifferencesDao.findModifiedRecords(eplNdfOutgoingDifferences.getVistaFileNumber(), 
                eplNdfOutgoingDifferences.getVistaFieldNumber(), eplNdfOutgoingDifferences.getVistaIen(), eplNdfOutgoingDifferences.getActionType());
        if(returnedValue == null){
            eplNdfOutgoingDifferencesDao.save(eplNdfOutgoingDifferences);
        }else{   
            verifyCmopModification(eplNdfOutgoingDifferences, returnedValue);
            returnedValue.setNewValue(eplNdfOutgoingDifferences.getNewValue());
            returnedValue.setCreatedBy(eplNdfOutgoingDifferences.getCreatedBy());
            returnedValue.setCreatedDtm(eplNdfOutgoingDifferences.getCreatedDtm());            
            eplNdfOutgoingDifferencesDao.update(returnedValue);
        }
    }
    
    @Transactional
    private EplNdfOutgoingDifferences verifyCmopModification(EplNdfOutgoingDifferences eplNdfOutgoingDifferences, EplNdfOutgoingDifferences returnedValue)
        throws ValidationException {   
        
        if(eplNdfOutgoingDifferences.getVistaFileNumber().equals("50.68") && eplNdfOutgoingDifferences.getVistaFieldNumber().equals("6")){            
            if(StringUtils.isBlank((returnedValue.getOldValue()))){                
                EplNdfOutgoingDifferences addedRecord = 
                    eplNdfOutgoingDifferencesDao.findModifiedRecords(eplNdfOutgoingDifferences.getVistaFileNumber(), 
                        eplNdfOutgoingDifferences.getVistaFieldNumber(), eplNdfOutgoingDifferences.getVistaIen(), "A");
                if(addedRecord != null){                    
                    if(addedRecord.getNewValue().equals(eplNdfOutgoingDifferences.getOldValue())){                       
                        returnedValue.setOldValue(eplNdfOutgoingDifferences.getOldValue());                         
                    }                
                }                
            }  
        }
        
        return returnedValue;
    }

    public EplNdfOutgoingDifferencesDao getEplNdfOutgoingDifferencesDao() {
        return eplNdfOutgoingDifferencesDao;
    }

    
    public void setEplNdfOutgoingDifferencesDao(EplNdfOutgoingDifferencesDao eplNdfOutgoingDifferencesDao) {
        this.eplNdfOutgoingDifferencesDao = eplNdfOutgoingDifferencesDao;
    }

}
