package gov.va.med.pharmacy.peps.service.common.capability;

import gov.va.med.pharmacy.peps.common.exception.ValidationException;
import gov.va.med.pharmacy.peps.domain.common.model.EplNdfOutgoingDifferences;


public interface NdfFileSyncCapability {
    
    /**
     * Accepts a new ManagedItem and saves the information for sending to VistA later.
     * 
     * @param item ManagedItem to send to VistA
     * @param user current UserVo
     * @throws ValidationException 
     */
    void saveNewItem(EplNdfOutgoingDifferences eplNdfOutgoingDifferences) 
        throws ValidationException;

    /**
     * Accepts a modified ManagedItem and saves the information for sending to VistA later.
     * 
     * @param item ManagedItem to send to VistA
     * @param differences Differences between the old and new value object
     * @param user current UserVo
     * @throws ValidationException 
     */
    void saveModifiedItem(EplNdfOutgoingDifferences eplNdfOutgoingDifferences) 
        throws ValidationException;

}
