package gov.va.med.pharmacy.peps.domain.common.utility.converter;

import gov.va.med.pharmacy.peps.common.vo.ManagedItemVo;
import gov.va.med.pharmacy.peps.common.vo.StatusVo;
import gov.va.med.pharmacy.peps.domain.common.model.DataObject;
import gov.va.med.pharmacy.peps.domain.common.model.EplStatusDo;

/**
 * Convert to/from {@link StatusVo} and {@link EplStatusDo}.
 */
public class StatusConverter extends Converter<StatusVo, EplStatusDo>{
    
    /**
     * Fully copies data from the given PartialSaveVo into a {@link DataObject}.
     * 
     * @param data PartialSaveVo to convert
     * @return fully populated {@link DataObject}
     * 
     * @see gov.va.med.pharmacy.peps.domain.common.utility.converter.Converter#toDataObject(
     *      gov.va.med.pharmacy.peps.common.vo.ValueObject)
     */
    @Override
    protected EplStatusDo toDataObject(StatusVo data) {
        EplStatusDo save = new EplStatusDo();
        save.setStatusDesc(data.getStatusDesc());
        save.setStatusId(data.getStatusId());
        save.setStatusName(data.getStatusName());
        save.setLastModifiedBy(data.getModifiedBy());
        save.setLastModifiedDtm(data.getModifiedDate()); 
        
        return save;
    }

    /**
     * Fully copies data from the given {@link DataObject} into a PartialSaveVo.
     * <p>
     * Parent objects, if any, are minimally populated. Child objects, if any, are not populated at all. Any remaining
     * aggregated {@link ManagedItemVo} are minimally populated. If any of these item types are intended to be fully
     * populated, the appropriate {@link Converter#convert(DataObject)} should be called.
     * 
     * @param data {@link DataObject} to convert
     * @return fully populated PartialSaveVo
     * 
     * @see gov.va.med.pharmacy.peps.domain.common.utility.converter.Converter#toValueObject(
     *      gov.va.med.pharmacy.peps.domain.common.model.DataObject)
     */
    @Override
    protected StatusVo toValueObject(EplStatusDo data) {
        StatusVo vo = new StatusVo();
        vo.setStatusDesc(data.getStatusDesc());
        vo.setStatusId(data.getStatusId());
        vo.setStatusName(data.getStatusName());
        vo.setModifiedBy(data.getLastModifiedBy());
        vo.setModifiedDate(data.getLastModifiedDtm());

        return vo;
    }

}
