package gov.va.med.pharmacy.peps.domain.common.utility.converter;


import gov.va.med.pharmacy.peps.common.vo.PackageSizeVo;
import gov.va.med.pharmacy.peps.common.vo.PackageTypeVo;
import gov.va.med.pharmacy.peps.domain.common.model.EplPackageSizeDo;
import gov.va.med.pharmacy.peps.domain.common.model.EplPackageTypeDo;


/**
 * Convert to/from {@link PackageTypeVo} and {@link EplPackageTypeDo}.
 */
public class PackageSizeConverter extends Converter<PackageSizeVo, EplPackageSizeDo> {

    /**
     * Fully copies data from the given PackageSizeVo into a {@link DataObject}.
     * 
     * @param data {@link ValueObject} to convert
     * @return fully populated {@link DataObject}
     * 
     */
    @Override
    protected EplPackageSizeDo toDataObject(PackageSizeVo data) {
        EplPackageSizeDo packageSize = new EplPackageSizeDo();

        if(data.getEplId()!= null)
            packageSize.setEplId(Long.valueOf(data.getEplId()));
       
        if (data.getNdfPackageSizeIen() != null)
            packageSize.setNdfPackageSizeIen(Long.valueOf(data.getNdfPackageSizeIen()));

        packageSize.setPackageSize(data.getPackageSize());
        packageSize.setCreatedBy(data.getCreatedBy());
        packageSize.setCreatedDtm(data.getCreatedDate());
        packageSize.setLastModifiedBy(data.getModifiedBy());
        packageSize.setLastModifiedDtm(data.getModifiedDate());

        return packageSize;
    }

    /**
     * Fully copies data from the given {@link DataObject} into a PackageSizeVo.
     * <p>
     * Parent objects, if any, are minimally populated. Child objects, if any, are not populated at all. Any remaining
     * aggregated {@link ManagedItemVo} are minimally populated. If any of these item types are intended to be fully
     * populated, the appropriate {@link Converter#convert(DataObject)} should be called.
     * 
     * @param data {@link DataObject} to convert
     * @return fully populated PackageSizeVo
     * 
     */
    @Override
    protected PackageSizeVo toValueObject(EplPackageSizeDo data) {
        PackageSizeVo packageSize = new PackageSizeVo();

        packageSize.setEplId(data.getEplId().toString());

        if (data.getNdfPackageSizeIen() != null) {
            packageSize.setNdfPackageSizeIen(data.getNdfPackageSizeIen().toString());
        }

        packageSize.setPackageSize(data.getPackageSize());
        packageSize.setCreatedBy(data.getCreatedBy());
        packageSize.setCreatedDate(data.getCreatedDtm());
        packageSize.setModifiedBy(data.getLastModifiedBy());
        packageSize.setModifiedDate(data.getLastModifiedDtm());
 
        return packageSize;
    }
    
    /**
     * toMinimalValueObject
     * 
     * @param data EplPackageSizeDo
     * @return minimally populated {@link ValueObject}
     */
    @Override
    protected PackageSizeVo toMinimalValueObject(EplPackageSizeDo data) {
        PackageSizeVo packageSize = new PackageSizeVo();

        packageSize.setEplId(data.getEplId().toString());

        if (data.getNdfPackageSizeIen() != null) {
            packageSize.setNdfPackageSizeIen(data.getNdfPackageSizeIen().toString());
        }

        packageSize.setPackageSize(data.getPackageSize());
     
        return packageSize;
    }
    
}
