package gov.va.med.pharmacy.peps.domain.common.utility.converter;

import gov.va.med.pharmacy.peps.common.vo.NdfUpdateFileVo;
import gov.va.med.pharmacy.peps.domain.common.model.EplNdfUpdateFileDo;

/**
 * Convert to/from {@link NdfUpdateFileVo} and {@link EplNdfUpdateFileDo}.
 */
public class NdfUpdateFileConverter extends Converter<NdfUpdateFileVo, EplNdfUpdateFileDo>{
    
    private StatusConverter statusConverter;
    
    public StatusConverter getStatusConverter() {
        return statusConverter;
    }

    
    public void setStatusConverter(StatusConverter statusConverter) {
        this.statusConverter = statusConverter;
    }
    
    /**
     * Fully copies data from the given NdfUpdateFileVo into a {@link DataObject}.
     * 
     * @param data NdfUpdateFileVo to convert
     * @return fully populated {@link DataObject}
     * 
     * @see gov.va.med.pharmacy.peps.domain.common.utility.converter.Converter#toDataObject(
     *      gov.va.med.pharmacy.peps.common.vo.ValueObject)
     */
    @Override
    protected EplNdfUpdateFileDo toDataObject(NdfUpdateFileVo data) {
        EplNdfUpdateFileDo save = new EplNdfUpdateFileDo();
        
        if(data.getFileId() != null ){
            save.setFileId(Long.valueOf(data.getFileId()));            
        }        
        save.setComments(data.getComments());
        save.setStatusModifiedDtm(data.getStatusModifiedDtm());        
        save.setFileName(data.getFileName());
        save.setDirectoryPath(data.getDirectoryPath());
        save.setProdTransmissionDtm(data.getProdTransmissionDtm());
        save.setTestTransmissionDtm(data.getTestTransmissionDtm());
        save.setLastModifiedBy(data.getModifiedBy());
        save.setLastModifiedDtm(data.getModifiedDate());   
        
        
        
        if (data.getStatus() != null) {           
            save.setEplStatus(statusConverter.convert(data.getStatus()));
        }

        

        return save;
    }

    /**
     * Fully copies data from the given {@link DataObject} into a NdfUpdateFileVo.
     * <p>
     * Parent objects, if any, are minimally populated. Child objects, if any, are not populated at all. Any remaining
     * aggregated {@link ManagedItemVo} are minimally populated. If any of these item types are intended to be fully
     * populated, the appropriate {@link Converter#convert(DataObject)} should be called.
     * 
     * @param data {@link DataObject} to convert
     * @return fully populated NdfUpdateFileVo
     * 
     * @see gov.va.med.pharmacy.peps.domain.common.utility.converter.Converter#toValueObject(
     *      gov.va.med.pharmacy.peps.domain.common.model.DataObject)
     */
    @Override
    protected NdfUpdateFileVo toValueObject(EplNdfUpdateFileDo data) {
        NdfUpdateFileVo vo = new NdfUpdateFileVo();
        vo.setComments(data.getComments());
        vo.setStatusModifiedDtm(data.getStatusModifiedDtm());
        vo.setFileId(data.getFileId().toString());
        vo.setFileName(data.getFileName());
        vo.setDirectoryPath(data.getDirectoryPath());
        vo.setProdTransmissionDtm(data.getProdTransmissionDtm());
        vo.setTestTransmissionDtm(data.getTestTransmissionDtm());
        vo.setModifiedBy(data.getLastModifiedBy());
        vo.setModifiedDate(data.getLastModifiedDtm());

        if (data.getEplStatus() != null) {
            vo.setStatus(statusConverter.convert(data.getEplStatus()));            
        } 

        return vo;
    }

}
