package gov.va.med.pharmacy.peps.domain.common.utility.converter;

import gov.va.med.pharmacy.peps.common.vo.MatchTypeVo;
import gov.va.med.pharmacy.peps.domain.common.model.DataObject;
import gov.va.med.pharmacy.peps.domain.common.model.EplMatchTypeDo;
import gov.va.med.pharmacy.peps.domain.common.model.EplStatusDo;

/**
 * Convert to/from {@link StatusVo} and {@link EplStatusDo}.
 */
public class MatchTypeConverter extends Converter<MatchTypeVo, EplMatchTypeDo>{
    
    /**
     * Fully copies data from the given PartialSaveVo into a {@link DataObject}.
     * 
     * @param data PartialSaveVo to convert
     * @return fully populated {@link DataObject}
     * 
     * @see gov.va.med.pharmacy.peps.domain.common.utility.converter.Converter#toDataObject(
     *      gov.va.med.pharmacy.peps.common.vo.ValueObject)
     */
    @Override
    protected EplMatchTypeDo toDataObject(MatchTypeVo data) {
        EplMatchTypeDo save = new EplMatchTypeDo();
        save.setMatchTypeId(data.getMatchTypeId());
        save.setMatchName(data.getMatchName());
        save.setMatchDesc(data.getMatchDesc());
        
        return save;
    }

    /**
     * Fully copies data from the given {@link DataObject} into a PartialSaveVo.
     * <p>
     * Parent objects, if any, are minimally populated. Child objects, if any, are not populated at all. Any remaining
     * aggregated {@link ManagedItemVo} are minimally populated. If any of these item types are intended to be fully
     * populated, the appropriate {@link Converter#convert(DataObject)} should be called.
     * 
     * @param data {@link DataObject} to convert
     * @return fully populated PartialSaveVo
     * 
     * @see gov.va.med.pharmacy.peps.domain.common.utility.converter.Converter#toValueObject(
     *      gov.va.med.pharmacy.peps.domain.common.model.DataObject)
     */
    @Override
    protected MatchTypeVo toValueObject(EplMatchTypeDo data) {
        MatchTypeVo vo = new MatchTypeVo();
        vo.setMatchTypeId(data.getMatchTypeId());
        vo.setMatchName(data.getMatchName());
        vo.setMatchDesc(data.getMatchDesc());        

        return vo;
    }

}
