package gov.va.med.pharmacy.peps.domain.common.utility.converter;


import org.springframework.stereotype.Component;

import gov.va.med.pharmacy.peps.common.vo.FdbPlblwarningsVVo;
import gov.va.med.pharmacy.peps.domain.common.model.FdbPlblwarningsV;


/**
 * Convert to/from {@link FdbPlblwarningsVVo} and {@link FdbPlblwarningsV}.
 */
@Component
public class FdbPlblwarningsVConverter extends
    Converter<FdbPlblwarningsVVo, FdbPlblwarningsV> {
 

    /**
     * Standard constructor
     */
    public FdbPlblwarningsVConverter() {
    }
    
    private static final org.apache.logging.log4j.Logger LOG = org.apache.logging.log4j.LogManager
        .getLogger(FdbPlblwarningsVConverter.class);

    /**
     * Fully copies data from the given FdbPlblwarningsVVo into a
     * {@link DataObject}.
     * 
     * @param data
     *            FdbPlblwarningsVVo to convert
     * @return fully populated {@link DataObject}
     * 
     * @see gov.va.med.pharmacy.peps.domain.common.utility.converter.Converter#toDataObject(
     *      gov.va.med.pharmacy.peps.common.vo.ValueObject)
     */
    @Override
    protected FdbPlblwarningsV toDataObject(FdbPlblwarningsVVo data) {
        FdbPlblwarningsV warningLabelDo = new FdbPlblwarningsV();

        warningLabelDo.getId().setLanguageid(data.getLanguageId());
        warningLabelDo.getId().setLwid(data.getLwId());
        warningLabelDo.getId().setSequencenumber(data.getSequenceNumber());
        warningLabelDo.getId().setWarningtext(data.getWarningText());
        warningLabelDo.getId().setGendercode(data.getGenderCode());
        warningLabelDo.getId().setAgecode(data.getAgeCode());
        warningLabelDo.getId().setWarningtext(data.getWarningText());
        warningLabelDo.getId().setInformationalcode(data.getWarningText());
         
        return warningLabelDo;
    }

    /**
     * Fully copies data from the given {@link DataObject} into a
     * FdbPlblwarningsVVo.
     * <p>
     * Parent objects, if any, are minimally populated. Child objects, if any,
     * are not populated at all. Any remaining aggregated are minimally populated. 
     * If any of these item types are intended to be fully populated, 
     * the appropriate {@link Converter#convert(DataObject)} should be called.
     * 
     * @param data FdbPlblwarningsV to convert
     * @return fully populated FdbPlblwarningsV
     * 
     * @see gov.va.med.pharmacy.peps.domain.common.utility.converter.Converter#toValueObject(
     *      gov.va.med.pharmacy.peps.domain.common.model.DataObject)
     */
    @Override
    protected FdbPlblwarningsVVo toValueObject(FdbPlblwarningsV data) {
      FdbPlblwarningsVVo plblWarningsVo = new FdbPlblwarningsVVo();

      plblWarningsVo.setLanguageId(data.getId().getLanguageid());
      plblWarningsVo.setLwId(data.getId().getLwid());
      plblWarningsVo.setSequenceNumber(data.getId().getSequencenumber());
      plblWarningsVo.setWarningText(data.getId().getWarningtext());
      plblWarningsVo.setGenderCode(data.getId().getGendercode());
      plblWarningsVo.setAgeCode(data.getId().getAgecode());
      plblWarningsVo.setWarningText(data.getId().getWarningtext());
      plblWarningsVo.setInformationalCode(data.getId().getInformationalcode());
       
      LOG.info("---returning id = : " + plblWarningsVo.getLwId());
      return plblWarningsVo;
    }
}

