package gov.va.med.pharmacy.peps.domain.common.utility.converter;


import org.springframework.stereotype.Component;

import gov.va.med.pharmacy.peps.common.vo.FdbMonographPemVVo;
import gov.va.med.pharmacy.peps.domain.common.model.FdbMonographPemV;


/**
 * Convert to/from {@link FdbMonographPemVVo} and {@link FdbMonographPemV}.
 */
@Component
public class FdbMonographPemVConverter extends
        Converter<FdbMonographPemVVo, FdbMonographPemV> {

    /**
     * Standard constructor
     */
    public FdbMonographPemVConverter() {
    }

    /**
     * Fully copies data from the given DrugMonographVo into a
     * {@link DataObject}.
     * 
     * @param data
     *            DrugMonographVo to convert
     * @return fully populated {@link DataObject}
     * 
     * @see gov.va.med.pharmacy.peps.domain.common.utility.converter.Converter#toDataObject(
     *      gov.va.med.pharmacy.peps.common.vo.ValueObject)
     */
    @Override
    protected FdbMonographPemV toDataObject(FdbMonographPemVVo data) {
        FdbMonographPemV monographDo = new FdbMonographPemV();
        
        monographDo.getId().setLanguageid(data.getLanguageId());
        monographDo.getId().setMonographid(data.getMonographId());
        monographDo.getId().setSequencenumber(data.getSequenceNumber());
        monographDo.getId().setVersioncode(data.getVersionCode());
        monographDo.getId().setSectioncode(data.getSectionCode());
        monographDo.getId().setFormatcode(data.getFormatCode());
        monographDo.getId().setLinetext(data.getLineText());
        
         
        return monographDo;
    }

    /**
     * Fully copies data from the given {@link DataObject} into a
     * NdfUpdateMonographPemVo.
     * <p>
     * Parent objects, if any, are minimally populated. Child objects, if any,
     * are not populated at all. Any remaining aggregated are minimally populated. 
     * If any of these item types are intended to be fully populated, 
     * the appropriate {@link Converter#convert(DataObject)} should be called.
     * 
     * @param data EplNdfUpdateMonographPemDo to convert
     * @return fully populated NdfUpdateMonographPemVo
     * 
     * @see gov.va.med.pharmacy.peps.domain.common.utility.converter.Converter#toValueObject(
     *      gov.va.med.pharmacy.peps.domain.common.model.DataObject)
     */
    @Override
    protected FdbMonographPemVVo toValueObject(FdbMonographPemV data) {
      FdbMonographPemVVo monographVo = new FdbMonographPemVVo();
       
          monographVo.setLanguageId(data.getId().getLanguageid());
          monographVo.setVersionCode(data.getId().getVersioncode());
          monographVo.setMonographId(data.getId().getMonographid());
          monographVo.setSequenceNumber(data.getId().getSequencenumber());
          monographVo.setSectionCode(data.getId().getSectioncode());
          monographVo.setFormatCode(data.getId().getFormatcode());
          monographVo.setLineText(data.getId().getLinetext());
                 
          return monographVo;
    }
}
