package gov.va.med.pharmacy.peps.domain.common.utility.converter;


import org.springframework.stereotype.Component;

import gov.va.med.pharmacy.peps.common.vo.FdbGcnseqnoPlblwVVo;
import gov.va.med.pharmacy.peps.domain.common.model.FdbGcnseqnoPlblwV;


/**
 * Convert to/from {@link FdbGcnseqnoPlblwVVo} and {@link FdbGcnseqnoPlblwV}.
 */
@Component
public class FdbGcnseqnoPlblwVConverter extends
        Converter<FdbGcnseqnoPlblwVVo, FdbGcnseqnoPlblwV> {

    /**
     * Standard constructor
     */
    public FdbGcnseqnoPlblwVConverter() {
    }

    /**
     * Fully copies data from the given FdbGcnseqnoPlblwVVo into a
     * {@link DataObject}.
     * 
     * @param data
     *            FdbGcnseqnoPlblwVVo to convert
     * @return fully populated {@link DataObject}
     * 
     * @see gov.va.med.pharmacy.peps.domain.common.utility.converter.Converter#toDataObject(
     *      gov.va.med.pharmacy.peps.common.vo.ValueObject)
     */
    @Override
    protected FdbGcnseqnoPlblwV toDataObject(FdbGcnseqnoPlblwVVo data) {
        FdbGcnseqnoPlblwV gcnSeqNoPlblWDo = new FdbGcnseqnoPlblwV();

        gcnSeqNoPlblWDo.getId().setGcnseqno(data.getGcnSeqNo());
        gcnSeqNoPlblWDo.getId().setLwid(data.getLwId());
        gcnSeqNoPlblWDo.getId().setPriority(data.getPriority());
         
        return gcnSeqNoPlblWDo;
    }

    /**
     * Fully copies data from the given {@link DataObject} into a
     * FdbGcnseqnoPlblwVVo.
     * <p>
     * Parent objects, if any, are minimally populated. Child objects, if any,
     * are not populated at all. Any remaining aggregated are minimally populated. 
     * If any of these item types are intended to be fully populated, 
     * the appropriate {@link Converter#convert(DataObject)} should be called.
     * 
     * @param data FdbGcnseqnoPlblwV to convert
     * @return fully populated FdbGcnseqnoPlblwV
     * 
     * @see gov.va.med.pharmacy.peps.domain.common.utility.converter.Converter#toValueObject(
     *      gov.va.med.pharmacy.peps.domain.common.model.DataObject)
     */
    @Override
    protected FdbGcnseqnoPlblwVVo toValueObject(FdbGcnseqnoPlblwV data) {
        FdbGcnseqnoPlblwVVo plblWagcnSeqNoPlblWVo = new FdbGcnseqnoPlblwVVo();

      plblWagcnSeqNoPlblWVo.setGcnSeqNo(data.getId().getGcnseqno());
      plblWagcnSeqNoPlblWVo.setLwId(data.getId().getLwid());
      plblWagcnSeqNoPlblWVo.setPriority(data.getId().getPriority());
             
      return plblWagcnSeqNoPlblWVo;
    }
}
