package gov.va.med.pharmacy.peps.domain.common.utility.converter;


import org.springframework.stereotype.Component;

import gov.va.med.pharmacy.peps.common.vo.FdbGcnseqnoPemVVo;
import gov.va.med.pharmacy.peps.domain.common.model.FdbGcnseqnoPemV;


/**
 * Convert to/from {@link FdbGcnseqnoPemVVo} and {@link FdbGcnseqnoPemV}.
 */
@Component
public class FdbGcnseqnoPemVConverter extends
        Converter<FdbGcnseqnoPemVVo, FdbGcnseqnoPemV> {

    /**
     * Standard constructor
     */
    public FdbGcnseqnoPemVConverter() {
    }

    /**
     * Fully copies data from the given FdbGcnseqnoPemVVo into a
     * {@link DataObject}.
     * 
     * @param data
     *            FdbGcnseqnoPemVVo to convert
     * @return fully populated {@link DataObject}
     * 
     * @see gov.va.med.pharmacy.peps.domain.common.utility.converter.Converter#toDataObject(
     *      gov.va.med.pharmacy.peps.common.vo.ValueObject)
     */
    @Override
    protected FdbGcnseqnoPemV toDataObject(FdbGcnseqnoPemVVo data) {
        FdbGcnseqnoPemV gcnSeqNoPemDo = new FdbGcnseqnoPemV();

        gcnSeqNoPemDo.getId().setGcnseqno(data.getGcnSeqNo());
        gcnSeqNoPemDo.getId().setMonographid(data.getMonographId());

        return gcnSeqNoPemDo;
    }

    /**
     * Fully copies data from the given {@link DataObject} into a
     * FdbGcnseqnoPemVVo.
     * <p>
     * Parent objects, if any, are minimally populated. Child objects, if any,
     * are not populated at all. Any remaining aggregated are minimally populated. 
     * If any of these item types are intended to be fully populated, 
     * the appropriate {@link Converter#convert(DataObject)} should be called.
     * 
     * @param data FdbGcnseqnoPemVVo to convert
     * @return fully populated FdbGcnseqnoPemVVo
     * 
     * @see gov.va.med.pharmacy.peps.domain.common.utility.converter.Converter#toValueObject(
     *      gov.va.med.pharmacy.peps.domain.common.model.DataObject)
     */
    @Override
    protected FdbGcnseqnoPemVVo toValueObject(FdbGcnseqnoPemV data) {
        FdbGcnseqnoPemVVo gcnseqnoPemVo = new FdbGcnseqnoPemVVo();

      gcnseqnoPemVo.setGcnSeqNo(data.getId().getGcnseqno());
      gcnseqnoPemVo.setMonographId(data.getId().getMonographid());

      return gcnseqnoPemVo;
    }
}
