

package gov.va.med.pharmacy.peps.domain.common.utility.converter;


import org.springframework.stereotype.Component;

import gov.va.med.pharmacy.peps.common.vo.EplVistaUpdateVo;
import gov.va.med.pharmacy.peps.domain.common.model.EplNdfUpdateFileDo;
import gov.va.med.pharmacy.peps.domain.common.model.EplVistaStatusDo;
import gov.va.med.pharmacy.peps.domain.common.model.EplVistaUpdateDo;

@Component
public class EplVistaUpdateConverter extends Converter<EplVistaUpdateVo, EplVistaUpdateDo> {

    @Override
    protected EplVistaUpdateDo toDataObject(EplVistaUpdateVo data) {
        EplVistaUpdateDo updateDo = new EplVistaUpdateDo();

        EplVistaStatusDo status = new EplVistaStatusDo();
        status.setStatusName(data.getStatus());
        
        EplNdfUpdateFileDo ndfUpdateFileDo = new EplNdfUpdateFileDo();
        ndfUpdateFileDo.setFileName(data.getFileName());
        
        updateDo.setComments(data.getComments());
        updateDo.setEplVistaStatus(status);
        updateDo.setSite(data.getSite());
        updateDo.setEplNdfUpdateFileDo(ndfUpdateFileDo);
        updateDo.setTransmissionDate(data.getTransmissionDate());
        return updateDo;
    }

    @Override
    protected EplVistaUpdateVo toValueObject(EplVistaUpdateDo data) {
        EplVistaUpdateVo eplVistaUpdateVo = new EplVistaUpdateVo();
        eplVistaUpdateVo.setComments(data.getComments());
        eplVistaUpdateVo.setFileName(data.getEplNdfUpdateFileDo().getFileName());
        eplVistaUpdateVo.setSite(data.getSite());
        eplVistaUpdateVo.setStatus(data.getEplVistaStatus().getStatusName());
        eplVistaUpdateVo.setTransmissionDate(data.getTransmissionDate());
        
        return eplVistaUpdateVo;
    }

}
