package gov.va.med.pharmacy.peps.domain.common.utility.converter;


import gov.va.med.pharmacy.peps.common.vo.DrugSeverityVo;
import gov.va.med.pharmacy.peps.domain.common.model.DataObject;
import gov.va.med.pharmacy.peps.domain.common.model.EplDdiSeverityDo;


/**
 * @author serverbutts
 * Convert to/from {@link DrugSeverityVo} and {@link EplDdiSeverityDo}.
 */
public class DrugSeverityConverter extends  Converter<DrugSeverityVo, EplDdiSeverityDo> {


    /**
     * Partially copies data from the given DrugSeverityVo into a
     * {@link DataObject}.
     * 
     * @param data DrugSeverityVo to convert
     * @return fully populated {@link DataObject}
     * 
     * @see gov.va.med.pharmacy.peps.domain.common.utility.converter.Converter#toDataObject(
     *      gov.va.med.pharmacy.peps.common.vo.ValueObject)
     */

    @Override
    protected EplDdiSeverityDo toDataObject(DrugSeverityVo data) {

        EplDdiSeverityDo severity = new EplDdiSeverityDo();
        severity.setSeverityId((Integer.parseInt(data.getSeverityId())));
        severity.setName(data.getValue());

        return severity;
    }





    /**
     * Partially DrugSeverityVo toValueObject
     *      
     * @param data {@link DataObject} to convert
     * @return fully populated DrugSeverityVo
     * 
     * @see gov.va.med.pharmacy.peps.domain.common.utility.converter.Converter#toValueObject(
     *      gov.va.med.pharmacy.peps.domain.common.model.DataObject)
     */

    @Override
    protected DrugSeverityVo toValueObject(EplDdiSeverityDo data) {

        DrugSeverityVo severity = new DrugSeverityVo();
        severity.setSeverityId(String.valueOf(data.getSeverityId()));
        severity.setId(String.valueOf(data.getSeverityId()));
        severity.setValue(data.getName());
        severity.setSeverityName(data.getName());

        return severity;
    }


    /**
     * DrugSeverityVo toMinimalValueObject(EplDdiSeverityDo data
     * <p>
     * Default implementation calls {@link #toValueObject(DataObject)}.
     * 
     * @param data {@link DataObject} to convert
     * @return minimally populated IngredientVo
     */
    @Override
    protected DrugSeverityVo toMinimalValueObject(EplDdiSeverityDo data) {

        DrugSeverityVo severity = new DrugSeverityVo();
        severity.setId(String.valueOf(data.getSeverityId()));      
        severity.setValue(data.getName());
        return severity;
    }

}
