package gov.va.med.pharmacy.peps.domain.common.utility.client.rxnorm;


import java.util.HashMap;
import java.util.Map;

import org.springframework.web.client.RestTemplate;


/**
 * This class handles the process of keeping RxNorm data up to date on the EPL_PRODUCTS table.
 * It uses two web service calls to NLM and the product DAO to populate the data into the appropriate columns.
 * 
 * @author D. Caruso
 *
 */
public class RxNormClient {
	
	private String rxNormCuidURL;
	private String rxNormDataURL;

    
    /**
     * Calls the NLM web service passing a product VUID and returning the RxCUID if the web service passes a result
     * 
     * @param vuid
     * @return
     */
    public RxNormData getRxcuid(String vuid) {
        RestTemplate restTemplate = new RestTemplate();
        Map<String, String> params = new HashMap<String, String>();

        params.put("idtype", "VUID");
        params.put("id", vuid);

        RxNormData rxNormData =
            restTemplate.getForObject(rxNormCuidURL, RxNormData.class, params);
        return rxNormData;
    }

    
    /**
     * Calls the NLM web service passing a RxNorm CUID and returning the RxNorm properties if the web service passes a result
     * 
     * @param rxcuid
     * @return
     */
    public RxNormData getRxNorm(long rxcuid) {
        Map<String, String> params = new HashMap<String, String>();
        params.put("rxcuid", String.valueOf(rxcuid));
        RestTemplate restTemplate = new RestTemplate();
        RxNormData rxNormData =
            restTemplate.getForObject(rxNormDataURL, RxNormData.class, params);
        return rxNormData;
    }


	/**
	 * @return
	 */
	public String getRxNormCuidURL() {
		return rxNormCuidURL;
	}
	/**
	 * @param rxNormCuidURL
	 */
	public void setRxNormCuidURL(String rxNormCuidURL) {
		this.rxNormCuidURL = rxNormCuidURL;
	}


	/**
	 * @return
	 */
	public String getRxNormDataURL() {
		return rxNormDataURL;
	}
	/**
	 * @param rxNormDataURL
	 */
	public void setRxNormDataURL(String rxNormDataURL) {
		this.rxNormDataURL = rxNormDataURL;
	}


}
