package gov.va.med.pharmacy.peps.domain.common.utility;

import gov.va.med.pharmacy.peps.common.vo.UserVo;
import gov.va.med.pharmacy.peps.domain.common.dao.EplProductDao;
import gov.va.med.pharmacy.peps.domain.common.model.EplProductDo;
import gov.va.med.pharmacy.peps.domain.common.utility.client.rxnorm.RxNormClient;

import java.util.Date;
import java.util.List;

public interface RxNormCapability {


    /**
	 * This method uses the product DAO to fetch a list of Product objects that are enabled for RxNorm update.
     * 
     * @return
     */
    public abstract List<EplProductDo> fetchRxNormUpdateProducts();
	
    /**
     * This method attempts to retrieve RxNorm data for a product using calls to the NLM web service.  For products for 
     * which the web service return data, it populates the returned data into the product and uses the product DAO to 
     * persist the changes
     * 
     * @param user
     * @param product
     * @param runDate
     */
    public abstract void populateAndPersist(UserVo user, EplProductDo product, Date runDate);

	
	/**
	 * Method used for testing that populates a single product with rxnorm data
	 * 
	 * @param user
	 * @param productId
	 * @return
	 */
	public abstract long populateRxNormForProduct(UserVo user, Long productId);
	
    
	/**
	 * @return
	 */
	public RxNormClient getRxNormClient();
	/**
	 * @param rxNormClient
	 */
	public abstract void setRxNormClient(RxNormClient rxNormClient);
	
	
	/**
	 * @return
	 */
	public EplProductDao getEplProductDao();
	/**
	 * @param eplProductDao
	 */
	public abstract void setEplProductDao(EplProductDao eplProductDao);

}