package gov.va.med.pharmacy.peps.domain.common.utility;

import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;


import gov.va.med.pharmacy.peps.common.exception.DomainValidationException;
import gov.va.med.pharmacy.peps.common.vo.UserVo;
import gov.va.med.pharmacy.peps.domain.common.dao.EplPackageSizeDao;
import gov.va.med.pharmacy.peps.domain.common.model.EplPackageSizeDo;

@Component
public class PackageSizeFileReader extends NdfFileReader {
    private EplPackageSizeDao eplPackageSizeDao;
    
    
    public PackageSizeFileReader() {
    }
  

    @Override
    protected void processTokens(String[] tokens) throws Exception {
        EplPackageSizeDo packageSize = new EplPackageSizeDo();
        try {
        	Double ps = new Double(parseDecimal(tokens[2]));
        	packageSize.setPackageSize(ps);
        } catch (ParseException e) {
        	throw new DomainValidationException(e, DomainValidationException.NUMERIC_ERROR, "package size", tokens[2]);
        }
        packageSize.setNdfPackageSizeIen(Long.valueOf(tokens[0]));
        
        UserVo user = new UserVo();
        user.setUsername("MIGRATOR");
        getEplPackageSizeDao().insert(packageSize, user);

    }
    
    private double parseDecimal(String input) throws ParseException {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.getDefault());
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = numberFormat.parse(input, parsePosition);

        if(parsePosition.getIndex() != input.length()){
          throw new ParseException("Invalid number at", parsePosition.getIndex());
        }

        return number.doubleValue();
      }  

    /**
     * @return the eplPackageSizeDao
     */
    public EplPackageSizeDao getEplPackageSizeDao() {
        return eplPackageSizeDao;
    }

    /**
     * @param eplPackageSizeDao the eplPackageSizeDao to set
     */
    @Autowired
    public void setEplPackageSizeDao(EplPackageSizeDao eplPackageSizeDao) {
        this.eplPackageSizeDao = eplPackageSizeDao;
    }

}
