

package gov.va.med.pharmacy.peps.domain.common.utility;


import gov.va.med.pharmacy.peps.domain.common.capability.impl.DatabaseDomainCapabilityImpl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.transaction.annotation.Transactional;


public abstract class NdfFileReader {

    private static final Logger LOG = LogManager.getLogger(NdfFileReader.class);
    
    /** The file path. */
    private RandomAccessFile file;
    private String delimiter = "\\^";
    private final String spaces = "^ ^";
    private final String noSpaces = "^^";

    public NdfFileReader() {
    }

   

    /**
     * Process file.
     */
    @Transactional
    public void processFile() {
        if(file ==null){
           throw new IllegalStateException("no file");
        }
        String line = "";
        while (line != null) {
            try {
                line = file.readLine();

                processLine(line);

            } catch (Exception e) {
            	LOG.error("Error processing line: " + line, e);
            }
        }

    }

 

    /**
     * Process line.
     *
     * @param line the line
     */
    private void processLine(String line) throws Exception {

        if (line == null) {
            return;
        }
        
        if (LOG.isDebugEnabled()) {
        	LOG.debug(line);
        }
        
        while (line != line.replace(noSpaces, spaces)) {
            line = line.replace(noSpaces, spaces);
        }
        String[] tokens = line.split(getDelimiter());
        processTokens(tokens);

    }

    /**
     * Process tokens. The original line is blow
     * 
     * ABARELIX/AMIODARONE;AMIODARONE;ABARELIX;CRITICAL;YES;170674;;;
     * 
     * @param tokens the tokens
     */
    protected abstract void processTokens(String[] tokens) throws Exception;

    /**
     * @param tokens
     * @return
     * @throws ParseException
     */
    protected Date stringToDate(String token) {
        SimpleDateFormat format = new SimpleDateFormat("MMM dd,YYYY");
        Date date;
        try {
            date = format.parse(token);
        } catch (ParseException e) {
            date = new Date();
            e.printStackTrace();
        }
        return date;
    }

    /**
     * @param tokens
     * @return
     */
    protected boolean stringToBool(String string) {
        boolean bool = false;
        if ("Yes".equals(string)) {
            bool = true;
        }
        return bool;
    }

    /**
     * @return the delimiter
     */
    public String getDelimiter() {
        return delimiter;
    }

    /**
     * @param delimiter the delimiter to set
     */
    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    /**
     * @return the file
     */
    public RandomAccessFile getFile() {
        return file;
    }

    /**
     * @param file the file to set
     */
    public void setFile(RandomAccessFile file) {
        this.file = file;
    }

   
}
