package gov.va.med.pharmacy.peps.domain.common.utility;


import java.util.List;

import javax.annotation.Resource;

import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.stereotype.Component;

import gov.va.med.pharmacy.peps.domain.common.dao.FdbPlblwarningsVDao;
import gov.va.med.pharmacy.peps.domain.common.utility.converter.FdbPlblwarningsVConverter;


/**
 * Provide retrieval for warning label data
 */
@Component
public class FdbPlblwarningsVDomainCapability  {

    @Resource
    private FdbPlblwarningsVDao fdbPlblwarningsVDao;
    @Resource
    private FdbPlblwarningsVConverter fdbPlblwarningsVConverter;


    /**
     * Retrieves warning labels by language type --- 50.623 and 50.624
     * 
     * @param Long languageid
     * @return FdbPlblwarningsVVo collection
     */
    public List<Object[]> retreiveWarningLabelByLanguageId(Long languageid){

        String queryString = "Select item.lwid, item.warningtext, " +
        		"count(item.warningtext) OVER (partition by item.lwid) cnt " +
        		"FROM Fdb_Plblwarnings_V item WHERE item.languageid = " + languageid + " AND item.lwid <> '0000' " +
        		"ORDER BY item.lwid, item.sequencenumber";

        Session session = fdbPlblwarningsVDao.getCurrentSession();
        Query query = session.createSQLQuery(queryString);

        return query.list();
    }
    
    /**
     * Retrieves CGN count 
     * 
     * @return int count
     */
    public Long retrieveWarningLabelCount(Long languageid){
    
        Session session = fdbPlblwarningsVDao.getCurrentSession();
        Query query = session.getNamedQuery("retrieveWarningLabelCount")
            .setLong("languageid", languageid);
        Long returnedCount = (Long) query.uniqueResult();
        return returnedCount;
    }
    
    /**
     * Retrieves max lwid 
     * 
     * @return String id
     */
    public String retrieveMaxLwid(Long languageid){
    
        Session session = fdbPlblwarningsVDao.getCurrentSession();
        Query query = session.getNamedQuery("retrieveMaxLwid")
            .setLong("languageid", languageid);
        String returnedLwid = (String) query.uniqueResult();
        return returnedLwid;
    }
   
    /**
     * @param fdbPlblwarningsVConverter the fdbPlblwarningsVConverter to set
     */
    public void setFdbPlblwarningsVConverter(FdbPlblwarningsVConverter fdbPlblwarningsVConverter) {
        this.fdbPlblwarningsVConverter = fdbPlblwarningsVConverter;
    }
   
    /**
     * @param fdbPlblwarningsVDao the fdbPlblwarningsVDao to set
     * 
     */
    public void setFdbPlblwarningsVDao(FdbPlblwarningsVDao fdbPlblwarningsVDao) {
        this.fdbPlblwarningsVDao = fdbPlblwarningsVDao;
    }
}
