package gov.va.med.pharmacy.peps.domain.common.utility;


import java.util.List;

import javax.annotation.Resource;

import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.springframework.stereotype.Component;

import gov.va.med.pharmacy.peps.common.vo.FdbMonographPemVVo;
import gov.va.med.pharmacy.peps.domain.common.dao.FdbMonographPemVDao;
import gov.va.med.pharmacy.peps.domain.common.model.FdbMonographPemV;
import gov.va.med.pharmacy.peps.domain.common.utility.converter.FdbMonographPemVConverter;

/**
 * Perform CRUD operations on item audit history
 */
@Component
public class FdbMonographPemVDomainCapability  {


    @Resource
    private FdbMonographPemVDao fdbMongoraphPemVDao;
    @Resource
    private FdbMonographPemVConverter fdbMonnographPemVConverter;
         
    /**
     * Retrieves distinct monograph for a specific language type
     * 
     * @param long languageid
     * @return List<Long> collection of monograph ids
     */
    public ScrollableResults retreiveMonographidsBylanguageid(Long languageid) {
        
        String queryString = "SELECT item.monographid, item.sectioncode, item.linetext, " +
        		"count(sectioncode) over (partition by monographid, sectioncode) cnt FROM Fdb_Monograph_Pem_V item " +
                "WHERE item.monographid > 0 AND item.languageid =  " + languageid + 
                " ORDER BY item.monographid, item.sequencenumber";
        
        Session session = fdbMongoraphPemVDao.getCurrentSession();
        Query query = session.createSQLQuery(queryString);
        ScrollableResults returnedValues = query.scroll(ScrollMode.FORWARD_ONLY);   

        session.flush();
        session.clear();
        return returnedValues;
    }
    
    /**
     * Retrieves title, gcn map --- 50.621 and 50.622
     * 
     * @param long languageid
     * @return NdfUpdateMonographPemVo collection
     */
    public List<FdbMonographPemVVo> retreiveMonographTitlesBylanguageid(Long languageid){
       
        Session session = fdbMongoraphPemVDao.getCurrentSession();
        Query query = session.getNamedQuery("retreiveMonographTitlesBylanguageid")
            .setLong("languageid",languageid);
        List<FdbMonographPemV> values = query.list();
        List<FdbMonographPemVVo> returnedValues = fdbMonnographPemVConverter.convert(values);

        return returnedValues;
    }
    
    /**
     * Retrieves max monographid for a specific language type
     * 
     * @return Long count
     */
   public Long retrieveMaxMonographidByLanguageid(Long languageid){
       
       Session session = fdbMongoraphPemVDao.getCurrentSession();
       Query query = session.getNamedQuery("retrieveMaxMonographidByLanguageid")
           .setLong("languageid",languageid);
       Long returnedMonograph = (Long) query.uniqueResult();
        
       return returnedMonograph;
   }
     
   /**
    * Retrieves count of distinct monographs for a language type  
    * 
    * @return Long count
    */
  public Long retrieveMonographCountByLanguageid(Long languageid){
      
      Session session = fdbMongoraphPemVDao.getCurrentSession();
      Query query = session.getNamedQuery("retrieveMonographCountByLanguageid")
          .setLong("languageid",languageid);
      Long returnedCount = (Long) query.uniqueResult();

      return returnedCount;
  }
  
  /**
   * Retrieves CGN count 
   * 
   * @return int count
   */
  public int retrieveFullCountMonographIds(){
      
      Session session = fdbMongoraphPemVDao.getCurrentSession();
      Query query = session.getNamedQuery("retrieveAllMonographIdsCount");
      int returnedCount = (int) query.uniqueResult();
      return returnedCount;
  }

  /**
   * @param fdbMongoraphPemVDao the eplNdfUpdateMonographPemDao to set
   */
  public void setFdbMonographPemVDao(FdbMonographPemVDao fdbMongoraphPemVDao) {
      this.fdbMongoraphPemVDao = fdbMongoraphPemVDao;
  }
    
  /**
   * @param fdbMonnographPemVConverter the ndfUpdateMonographPemConverter to set
   */
  public void setFdbMonographPemVConverter(FdbMonographPemVConverter fdbMonnographPemVConverter) {
      this.fdbMonnographPemVConverter = fdbMonnographPemVConverter;
  }
}
