package gov.va.med.pharmacy.peps.domain.common.utility;


import java.util.List;

import javax.annotation.Resource;

import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Order;
import org.springframework.stereotype.Component;

import gov.va.med.pharmacy.peps.common.vo.FdbGcnseqnoPlblwVVo;
import gov.va.med.pharmacy.peps.domain.common.dao.FdbGcnseqnoPlblwVDao;
import gov.va.med.pharmacy.peps.domain.common.model.FdbGcnseqnoPlblwV;
import gov.va.med.pharmacy.peps.domain.common.utility.converter.FdbGcnseqnoPlblwVConverter;

/**
 * Provide retrieval for warning label data
 */
@Component
public class FdbGcnseqnoPlblwVDomainCapability  {

    @Resource
    private FdbGcnseqnoPlblwVConverter fdbGcnSeqNoPlblwVConverter;
    @Resource
    private FdbGcnseqnoPlblwVDao fdbGcnSeqNoPlblwVDao;
       
    
    /**
     * Retrieves warning label ids for specific language type
     * 
     * @return List<String> lwids
     */
    public List<String> retreiveLwIdMapByLanguageId(Long languageId){
        
        Session session = fdbGcnSeqNoPlblwVDao.getCurrentSession();
        Query query = session.getNamedQuery("retreiveLwIdMapByLanguageId")
            .setLong("languageid",languageId);
        List<String> values = query.list();

        return values;
    }

    /**
     * Retrieves all warning label ids
     * 
     * @return List<Long> gcn list
     */
    public List<Long> retreiveAllGcnsMap(){

        Session session = fdbGcnSeqNoPlblwVDao.getCurrentSession();
        Query query = session.getNamedQuery("retreiveAllGcnsMap");
        List<Long> values = query.list();

        return values;
    }
    
    /**
     * Retrieves gcn, warning label id, and priority for map 
     * 
     * @return FdbGcnseqnoPlblwVVo collection
     */
    public List<FdbGcnseqnoPlblwVVo> retreiveGcnLwIdAndPriorityMap(){
        
        Criteria criteria = fdbGcnSeqNoPlblwVDao.getCriteria();        
        criteria.addOrder(Order.asc("id.gcnseqno"));
        criteria.addOrder(Order.asc("id.lwid"));
        criteria.addOrder(Order.asc("id.priority")); 
        List<FdbGcnseqnoPlblwV> values = criteria.list();
        List<FdbGcnseqnoPlblwVVo> returnedValues = fdbGcnSeqNoPlblwVConverter.convert(values);

        return returnedValues;
    }

    /**
     * @param fdbGcnSeqNoPlblwVConverter the ndfUpdateGcnSeqNoPlblWConverter to set
     */
    public void setFdbGcnseqnoPlblwVConverter(FdbGcnseqnoPlblwVConverter fdbGcnSeqNoPlblwVConverter) {
        this.fdbGcnSeqNoPlblwVConverter = fdbGcnSeqNoPlblwVConverter;
    }


    /**
     * @param fdbGcnSeqNoPlblwVDao the eplNdfUpdateGcnSeqNoPlblWDao to set
     */
    public void setFdbGcnseqnoPlblwVDao(FdbGcnseqnoPlblwVDao fdbGcnSeqNoPlblwVDao) {
        this.fdbGcnSeqNoPlblwVDao = fdbGcnSeqNoPlblwVDao;
    }
}
