package gov.va.med.pharmacy.peps.domain.common.utility;


import java.util.List;

import javax.annotation.Resource;

import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.stereotype.Component;

import gov.va.med.pharmacy.peps.common.vo.FdbGcnseqnoPemVVo;
import gov.va.med.pharmacy.peps.domain.common.dao.FdbGcnseqnoPemVDao;
import gov.va.med.pharmacy.peps.domain.common.model.FdbGcnseqnoPemV;
import gov.va.med.pharmacy.peps.domain.common.utility.converter.FdbGcnseqnoPemVConverter;

/**
 * Provide retrieval for warning label data
 */
@Component
public class FdbGcnseqnoPemVDomainCapability  {

    @Resource
    private FdbGcnseqnoPemVConverter fdbGcnSeqNoPemVConverter;
    @Resource
    private FdbGcnseqnoPemVDao fdbGcnSeqNoPemVDao;
    
    /**
     * Retrieves GCN,MONOGRAPH by language id where gcn >0 
     * 
     * @param Long languageid
     * @return FdbGcnseqnoPemVVo collection
     */
    public List<FdbGcnseqnoPemVVo> retreiveGcnsMonographids(Long languageid){

        Session session = fdbGcnSeqNoPemVDao.getCurrentSession();
        Query query = session.getNamedQuery("retreiveGcnsMonographids")
            .setLong("languageid",languageid);
        List<FdbGcnseqnoPemV> values = query.list();
        List<FdbGcnseqnoPemVVo> returnedValues = fdbGcnSeqNoPemVConverter.convert(values);

        return returnedValues;
    }
    
    
  /**
   * Retrieves max GCN  
   * 
   * @return Long count
   */
 public Long retrieveMaxGcn(Long languageid){
     
     Session session = fdbGcnSeqNoPemVDao.getCurrentSession();
     Query query = session.getNamedQuery("retrieveMaxGcn")
         .setLong("languageid",languageid);
     Long returnedGcn = (Long) query.uniqueResult();

     return returnedGcn;
 }
 public Long retrieveGcnCount(Long languageid){
     
     Session session = fdbGcnSeqNoPemVDao.getCurrentSession();
     Query query = session.getNamedQuery("retrieveGcnCount")
         .setLong("languageid",languageid);
     Long returnedGcn = (Long) query.uniqueResult();
     return returnedGcn;
 }
 
    
    /**
     * @return the fdbGcnSeqNoPemVConverter
     */
    public FdbGcnseqnoPemVConverter getFdbGcnSeqNoPemVConverter() {
        return fdbGcnSeqNoPemVConverter;
    }
    
    /**
     * @param fdbGcnSeqNoPemVConverter the fdbGcnSeqNoPemVConverter to set
     */
    public void setFdbGcnSeqNoPemVConverter(FdbGcnseqnoPemVConverter fdbGcnSeqNoPemVConverter) {
        this.fdbGcnSeqNoPemVConverter = fdbGcnSeqNoPemVConverter;
    }
    
    /**
     * @return the fdbGcnSeqNoPemVDao
     */
    public FdbGcnseqnoPemVDao getFdbGcnSeqNoPemVDao() {
        return fdbGcnSeqNoPemVDao;
    }
    
    /**
     * @param fdbGcnSeqNoPemVDao the fdbGcnSeqNoPemVDao to set
     */
    public void setFdbGcnSeqNoPemVDao(FdbGcnseqnoPemVDao fdbGcnSeqNoPemVDao) {
        this.fdbGcnSeqNoPemVDao = fdbGcnSeqNoPemVDao;
    }
       

}
