

package gov.va.med.pharmacy.peps.domain.common.utility;


import gov.va.med.pharmacy.peps.common.exception.DomainException;
import gov.va.med.pharmacy.peps.common.vo.UserVo;
import gov.va.med.pharmacy.peps.domain.common.dao.EplDdiSeverityDao;
import gov.va.med.pharmacy.peps.domain.common.dao.EplDrugDrugInteractionDao;
import gov.va.med.pharmacy.peps.domain.common.dao.EplIngredientDao;
import gov.va.med.pharmacy.peps.domain.common.model.EplDdiSeverityDo;
import gov.va.med.pharmacy.peps.domain.common.model.EplDrugDrugInteractionDo;
import gov.va.med.pharmacy.peps.domain.common.model.EplIngredientDo;

import java.util.Calendar;
import java.util.Date;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;


/**
 * The Class DDIFileReader.
 */
@Component
public class DDIFileReader extends NdfFileReader {

    private static final int IEN = 0;

    private static final int INTERACTION_NAME = 1;

    private static final int INGREDIENT1 = 2;

    private static final int INGREDIENT2 = 3;

    private static final int SEVERITY = 4;

    private static final int NATIONALLY_ENTERED = 5;

    private static final int TOTAL_INDEXES = 6;

    private static final int LOCALLY_ENTERED = 7;

    private static final int INACTIVATION_DATE = 8;

    private EplIngredientDao eplIngredientDao;

    private EplDdiSeverityDao eplDdiSeverityDao;

    private EplDrugDrugInteractionDao drugDrugInteractionDao;


   

    /**
     * Process tokens. The original line is below
     * 
     * ABARELIX/AMIODARONE;AMIODARONE;ABARELIX;CRITICAL;YES;170674;;;
     * 6859^ABARELIX/AMIODARONE^AMIODARONE^ABARELIX^CRITICAL^YES^168896^^
     * 
     * @param tokens the tokens
     */

    protected void processTokens(String[] tokens) throws Exception{
        
        //ABARELIX/AMIODARONE;AMIODARONE;ABARELIX;CRITICAL;YES;170674;;;
        EplDrugDrugInteractionDo ddi = new EplDrugDrugInteractionDo();
        ddi.setCreatedBy("Rob");
        ddi.setCreatedDtm(Calendar.getInstance().getTime());
        ddi.setVistaIen(Long.valueOf(tokens[IEN]));
        ddi.setInteractionName(tokens[INTERACTION_NAME]);
        ddi.setDrugIngredient1(findIngredient(tokens[INGREDIENT1]));
        ddi.setDrugIngredient2(findIngredient(tokens[INGREDIENT2]));
        ddi.setSeverity(findSeverity(tokens[SEVERITY]));
        ddi.setNationallyEntered(stringToBool(tokens[NATIONALLY_ENTERED]));
        ddi.setTotalIndexes(Long.valueOf(tokens[TOTAL_INDEXES]));
        
        if (ddi.getDrugIngredient1() == null) {
            throw new DomainException(DomainException.DATA_NOT_FOUND, "DrugIngredient1 - " + tokens[INGREDIENT1]);
        }

        if (ddi.getDrugIngredient2() == null) {
            throw new DomainException(DomainException.DATA_NOT_FOUND, "DrugIngredient2 - " + tokens[INGREDIENT2]);
        }

        if (!StringUtils.isEmpty(tokens[LOCALLY_ENTERED].trim())) {
            ddi.setLocallyEdited(stringToBool(tokens[LOCALLY_ENTERED]));
        }
        
        if (tokens.length == 9 && !StringUtils.isEmpty(tokens[INACTIVATION_DATE].trim())) {
            Date date = stringToDate(tokens[INACTIVATION_DATE]);
            ddi.setInactivationDate(date);
        }
        UserVo user = new UserVo();
       

        user.setUsername("MIGRATOR");
        getDrugDrugInteractionDao().insert(ddi, user);

    }

    private EplIngredientDo findIngredient(String name) {
        return getEplIngredientDao().findIngredientByName(name);
    }

    private EplDdiSeverityDo findSeverity(String name) {
        return getEplDdiSeverityDao().findByName(name);

    }

    /**
     * @return the eplIngredientDao
     */
    public EplIngredientDao getEplIngredientDao() {
        return eplIngredientDao;
    }

    /**
     * @param eplIngredientDao the eplIngredientDao to set
     */
    @Autowired(required = true)
    public void setEplIngredientDao(EplIngredientDao eplIngredientDao) {
        this.eplIngredientDao = eplIngredientDao;
    }

    /**
     * @return the eplDdiSeverityDao
     */
    public EplDdiSeverityDao getEplDdiSeverityDao() {
        return eplDdiSeverityDao;
    }

    /**
     * @param eplDdiSeverityDao the eplDdiSeverityDao to set
     */
    @Autowired
    public void setEplDdiSeverityDao(EplDdiSeverityDao eplDdiSeverityDao) {
        this.eplDdiSeverityDao = eplDdiSeverityDao;
    }

    /**
     * @return the drugDrugInteractionDao
     */
    public EplDrugDrugInteractionDao getDrugDrugInteractionDao() {
        return drugDrugInteractionDao;
    }

    /**
     * @param drugDrugInteractionDao the drugDrugInteractionDao to set
     */
    @Autowired
    public void setDrugDrugInteractionDao(EplDrugDrugInteractionDao drugDrugInteractionDao) {
        this.drugDrugInteractionDao = drugDrugInteractionDao;
    }

   


}
