package gov.va.med.pharmacy.peps.domain.common.utility;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;

import javax.annotation.Resource;

import org.hibernate.Hibernate;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

/**
 * A class that can be used to create/retrieve Blob content. This class was created since the Hibernate methods now take a
 * Session in order to perform these operations.
 * 
 * @author vhaisaduffg
 * 
 * @deprecated 20150827 - Hibernate 4 now handles BLOBs as byte[].
 */
@Service
@Deprecated
public class BlobHandler implements InitializingBean {

    @Resource(name = "sessionFactory")
    private SessionFactory sessionFactory;

    /**
     * Creates a Blob from a byte array.
     * 
     * @param bytes
     *            byte array
     * @return Blob
     */
    public final Blob createBlob(byte[] bytes) {
        return Hibernate.getLobCreator(sessionFactory.getCurrentSession()).createBlob(bytes);
    }

    /**
     * Creates a Blob from an InputStream.
     * 
     * @param stream
     *            InputStream
     * @param length
     *            the length of the content
     * @return Blob
     */
    public final Blob createBlob(InputStream stream, Long length) {
        return Hibernate.getLobCreator(sessionFactory.getCurrentSession()).createBlob(stream, length);
    }

    /**
     * Returns a Blob as a byte array.
     * 
     * @param blob
     *            the Blob
     * @return byte[]
     * @throws SQLException
     *             if an error occurs during conversion
     */
    public final byte[] toByteArray(Blob blob) throws SQLException {
        Long length = blob.length();
        return blob.getBytes(1L, length.intValue());
    }

    /**
     * Returns a Blob as an InputStream.
     * 
     * @param blob
     *            the Blob
     * @return InputStream
     * @throws SQLException
     *             if an error occurs during conversion
     */
    public final InputStream getStream(Blob blob) throws SQLException {
        return blob.getBinaryStream();
    }

    /**
     * Sets the SessionFactory that should be used by this class.
     * 
     * @param sessionFactory
     *            the SessionFactory
     */
    public final void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    /**
     * Method to check to make sure the any needs beans have been injected.
     * 
     * @throws Exception
     *             if a property has not been injected
     */
    @Override
    public final void afterPropertiesSet() throws Exception {
        if (sessionFactory == null) {
            throw new Exception("SessionFactory has not been injected in to BlobHandler.");
        }
    }
}
