package gov.va.med.pharmacy.peps.domain.common.model;


// Generated Mar 21, 2014 11:07:37 AM by Hibernate Tools 3.4.0.CR1

import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;


/**
 * FdbMonographPemV generated by hbm2java
 */

@NamedQueries({      
  @NamedQuery(name= "retreiveMonographByMonographid",
       query="FROM FdbMonographPemV item WHERE item.id.monographid = :monographid " +
                  "AND item.id.languageid = :languageid " +
                  "ORDER BY item.id.monographid, item.id.sequencenumber"),

  @NamedQuery(name= "retreiveMonographTitlesBylanguageid",
      query="FROM FdbMonographPemV item WHERE item.id.languageid = :languageid AND item.id.monographid > 0 " +
          "AND item.id.sectioncode = 'T'  ORDER BY item.id.linetext" ),

  @NamedQuery(name= "retrieveMaxMonographid",
       query="SELECT MAX(item.id.monographid) FROM FdbMonographPemV item "),
  
  @NamedQuery(name= "retrieveMaxMonographidByLanguageid",
      query="SELECT MAX(item.id.monographid) FROM FdbMonographPemV item WHERE item.id.languageid = :languageid "),

  @NamedQuery(name = "retrieveMonographCountByLanguageid", 
      query ="SELECT COUNT(DISTINCT item.id.monographid) FROM FdbMonographPemV item WHERE item.id.languageid = :languageid ")
})
@Entity
@Table(name = "FDB_MONOGRAPH_PEM_V"
    , schema = "PPSNEPL")
public class FdbMonographPemV extends gov.va.med.pharmacy.peps.domain.common.model.DataObject implements java.io.Serializable {

    private static final long serialVersionUID = 1L;

    private FdbMonographPemVId id;

    public FdbMonographPemV() {
    }

    public FdbMonographPemV(FdbMonographPemVId id) {
        this.id = id;
    }

    @EmbeddedId
    @AttributeOverrides({
        @AttributeOverride(name = "languageid", column = @Column(name = "LANGUAGEID", nullable = false, precision = 22,
            scale = 0)),
        @AttributeOverride(name = "versioncode", column = @Column(name = "VERSIONCODE", nullable = false, length = 10)),
        @AttributeOverride(name = "monographid", column = @Column(name = "MONOGRAPHID", nullable = false, precision = 22,
            scale = 0)),
        @AttributeOverride(name = "sequencenumber", column = @Column(name = "SEQUENCENUMBER", nullable = false, precision = 22,
            scale = 0)),
        @AttributeOverride(name = "sectioncode", column = @Column(name = "SECTIONCODE", length = 1)),
        @AttributeOverride(name = "formatcode", column = @Column(name = "FORMATCODE", length = 1)),
        @AttributeOverride(name = "linetext", column = @Column(name = "LINETEXT")) })
    public FdbMonographPemVId getId() {
        return this.id;
    }

    public void setId(FdbMonographPemVId id) {
        this.id = id;
    }

}
