/**
 * Source file created in 2008 by Southwest Research Institute
 * 
 * @hibernate.class
 */


package gov.va.med.pharmacy.peps.domain.common.model;


import java.util.Date;
import java.util.HashSet;
import java.util.Set;


/**
 * EplVaDrugClassDo generated by hbm2java
 * 
 * @hibernate.class
 */
public class EplVaDrugClassDo extends gov.va.med.pharmacy.peps.domain.common.model.DataObject 
    implements java.io.Serializable {
    
    public static final String DESCRIPTION = "description";
    public static final String ITEM_STATUS = "itemStatus";
    public static final String REQUEST_STATUS = "requestStatus";
    public static final String CLASSIFICATION_NAME = "classificationName";
    public static final String CODE = "code";
    public static final String INACTIVATION_DATE = "inactivationDate";
    public static final String EPL_ID = "eplId";
    public static final String NDF_CLASS_IEN = "ndfClassIen";
    
    private static final long serialVersionUID = 1L;

    // Fields

    private Long eplId;
    private String description;
    private String vuid;
    private String masterEntryForVuid;
    private Date inactivationDate;
    private String requestStatus;
    private String itemStatus;
    private String rejectReasonText;
    private String requestRejectReason;
    private String classificationName;
    private String code;
    private Long ndfClassIen;
    private Long revisionNumber;
    private EplClassTypeDo eplClassType;
    private EplVaDrugClassDo eplVaDrugClass;
    private Set<EplVaDrugClassDo> eplVaDrugClasses = new HashSet<EplVaDrugClassDo>(0);
    private Set<EplProdDrugClassAssocDo> eplProdDrugClassAssocs = new HashSet<EplProdDrugClassAssocDo>(0);

    // Constructors

    /** 
     * default constructor 
     */    
    public EplVaDrugClassDo() {
    }

    /**
     *     
     * @param eplId eplId
     * @param description eplId
     * @param vuid vuid
     * @param masterEntryForVuid masterEntryForVuid
     * @param createdBy createdBy
     * @param createdDtm createdDtm
     */
    public EplVaDrugClassDo(Long eplId, String description, String vuid, String masterEntryForVuid, String createdBy, Date createdDtm) {
        this.eplId = eplId;
        this.description = description;
        this.vuid = vuid;
        this.masterEntryForVuid = masterEntryForVuid;
        this.setCreatedBy(createdBy);
        this.setCreatedDtm(createdDtm);
        
    }

    /**
     * EplVaDrugClassDo
     * @param eplId eplId
     * @param description description
     * @param vuid vuid
     * @param masterEntryForVuid masterEntryForVuid
     * @param createdBy createdBy
     * @param createdDtm createdDtm
     * @param ndfClassIen ndfClassIen
     * @param lastModifiedBy lastModifiedBy
     * @param lastModifiedDtm lastModifiedDtm
     * @param eplProdDrugClassAssocs eplProdDrugClassAssocs
     */
    public EplVaDrugClassDo(Long eplId, String description, String vuid, String masterEntryForVuid, String createdBy, Date createdDtm,
                            Long ndfClassIen, String lastModifiedBy, Date lastModifiedDtm,
                            Set<EplProdDrugClassAssocDo> eplProdDrugClassAssocs) {
        this.eplId = eplId;
        this.description = description;
        this.vuid = vuid;
        this.masterEntryForVuid = masterEntryForVuid;
        this.ndfClassIen = ndfClassIen;
        this.setCreatedBy(createdBy);
        this.setCreatedDtm(createdDtm);
        this.setLastModifiedBy(lastModifiedBy);
        this.setLastModifiedDtm(lastModifiedDtm);
        this.eplProdDrugClassAssocs = eplProdDrugClassAssocs;
    }

    /**
     * getEplId()
     * @return eplId
     */
    public Long getEplId() {
        return this.eplId;
    }

    /**
     * setEplId()
     * @param eplId eplId
     */
    public void setEplId(Long eplId) {
        this.eplId = eplId;
    }
    
    /**
     * getNdfClassIen
     * @return ndfClassIen
     */
    public Long getNdfClassIen() {
        return this.ndfClassIen;
    }

    /**
     * setNdfClassIen
     * @param ndfClassIen ndfClassIen
     */
    public void setNdfClassIen(Long ndfClassIen) {
        this.ndfClassIen = ndfClassIen;
    }

    /**
     * getDescription
     * @return description
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * setDescription
     * @param description description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * getVuid() 
     * @return vuid
     */
    public String getVuid() {
        return this.vuid;
    }

    /**
     * setVuid
     * @param vuid vuid
     */
    public void setVuid(String vuid) {
        this.vuid = vuid;
    }

    /**
     * getMasterEntryForVuid
     * @return masterEntryForVuid
     */
    public String getMasterEntryForVuid() {
        return this.masterEntryForVuid;
    }
    
    /**
     * setMasterEntryForVuid
     * @param masterEntryForVuid masterEntryForVuid
     */
    public void setMasterEntryForVuid(String masterEntryForVuid) {
        this.masterEntryForVuid = masterEntryForVuid;
    }
    
    /**
     * getEplProdDrugClassAssocs
     * @return eplProdDrugClassAssocs
     */
    public Set<EplProdDrugClassAssocDo> getEplProdDrugClassAssocs() {
        return this.eplProdDrugClassAssocs;
    }

    public void setEplProdDrugClassAssocs(Set<EplProdDrugClassAssocDo> eplProdDrugClassAssocs) {
        this.eplProdDrugClassAssocs = eplProdDrugClassAssocs;
    }

    /**
     * toString
     * 
     * @return String
     */
    public String toString() {
        StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");
        buffer.append("description").append("='").append(getDescription()).append("' ");
        buffer.append("vuid").append("='").append(getVuid()).append("' ");
        buffer.append("masterEntryForVuid").append("='").append(getMasterEntryForVuid()).append("' ");
        buffer.append("createdBy").append("='").append(getCreatedBy()).append("' ");
        buffer.append("createdDtm").append("='").append(getCreatedDtm()).append("' ");
        buffer.append("lastModifiedBy").append("='").append(getLastModifiedBy()).append("' ");
        buffer.append("lastModifiedDtm").append("='").append(getLastModifiedDtm()).append("' ");
        buffer.append("]");

        return buffer.toString();
    }

    public boolean equals(Object other) {
        if ((this == other)) {
            return true;
        }
        
        if ((other == null)) {
            return false;
        }
        
        if (!(other instanceof EplVaDrugClassDo)) {
            return false;
        }
        
        EplVaDrugClassDo castOther = (EplVaDrugClassDo) other;

        return ((this.getEplId() == castOther.getEplId()) || (this.getEplId() != null && castOther.getEplId() != null && this.getEplId()
            .equals(castOther.getEplId())))
            && ((this.getDescription() == castOther.getDescription()) || (this.getDescription() != null
                && castOther.getDescription() != null && this.getDescription().equals(castOther.getDescription())))
            && ((this.getVuid() == castOther.getVuid()) || (this.getVuid() != null && castOther.getVuid() != null && this
                .getVuid().equals(castOther.getVuid())))
            && ((this.getNdfClassIen() == castOther.getNdfClassIen()) || (this.getNdfClassIen() != null && castOther.getNdfClassIen() != null && this
                .getNdfClassIen().equals(castOther.getNdfClassIen())))
            && ((this.getMasterEntryForVuid() == castOther.getMasterEntryForVuid()) || (this.getMasterEntryForVuid() != null && castOther.getMasterEntryForVuid() != null && this
                .getMasterEntryForVuid().equals(castOther.getMasterEntryForVuid())))
            && ((this.getCreatedBy() == castOther.getCreatedBy()) || (this.getCreatedBy() != null
                && castOther.getCreatedBy() != null && this.getCreatedBy().equals(castOther.getCreatedBy())))
            && ((this.getCreatedDtm() == castOther.getCreatedDtm()) || (this.getCreatedDtm() != null
                && castOther.getCreatedDtm() != null && this.getCreatedDtm().equals(castOther.getCreatedDtm())))
            && ((this.getLastModifiedBy() == castOther.getLastModifiedBy()) || (this.getLastModifiedBy() != null
                && castOther.getLastModifiedBy() != null && this.getLastModifiedBy().equals(castOther.getLastModifiedBy())))
            && ((this.getLastModifiedDtm() == castOther.getLastModifiedDtm()) || (this.getLastModifiedDtm() != null
                && castOther.getLastModifiedDtm() != null && this.getLastModifiedDtm()
                .equals(castOther.getLastModifiedDtm())));
    }

    /**
     * hashCode()
     * @return hashCode
     */
    public int hashCode() {
        int result = 17;

        result = 37 * result + (getEplId() == null ? 0 : this.getEplId().hashCode());
        result = 37 * result + (getDescription() == null ? 0 : this.getDescription().hashCode());
        result = 37 * result + (getVuid() == null ? 0 : this.getVuid().hashCode());
        result = 37 * result + (getNdfClassIen() == null ? 0 : this.getNdfClassIen().hashCode());
        result = 37 * result + (getMasterEntryForVuid() == null ? 0 : this.getMasterEntryForVuid().hashCode());
        result = 37 * result + (getCreatedBy() == null ? 0 : this.getCreatedBy().hashCode());
        result = 37 * result + (getCreatedDtm() == null ? 0 : this.getCreatedDtm().hashCode());
        result = 37 * result + (getLastModifiedBy() == null ? 0 : this.getLastModifiedBy().hashCode());
        result = 37 * result + (getLastModifiedDtm() == null ? 0 : this.getLastModifiedDtm().hashCode());

        return result;
    }

    public Date getInactivationDate() {
        return inactivationDate;
    }

    public void setInactivationDate(Date inactivationDate) {
        this.inactivationDate = inactivationDate;
    }

    public String getRequestStatus() {
        return requestStatus;
    }

    public void setRequestStatus(String requestStatus) {
        this.requestStatus = requestStatus;
    }

    public String getItemStatus() {
        return itemStatus;
    }

    public void setItemStatus(String itemStatus) {
        this.itemStatus = itemStatus;
    }

    public String getRejectReasonText() {
        return rejectReasonText;
    }

    public void setRejectReasonText(String rejectReasonText) {
        this.rejectReasonText = rejectReasonText;
    }

    public String getRequestRejectReason() {
        return requestRejectReason;
    }

    public void setRequestRejectReason(String requestRejectReason) {
        this.requestRejectReason = requestRejectReason;
    }

    public String getClassificationName() {
        return classificationName;
    }

    public void setClassificationName(String classificationName) {
        this.classificationName = classificationName;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Long getRevisionNumber() {
        return revisionNumber;
    }

    public void setRevisionNumber(Long revisionNumber) {
        this.revisionNumber = revisionNumber;
    }

    public EplClassTypeDo getEplClassType() {
        return eplClassType;
    }

    public void setEplClassType(EplClassTypeDo eplClassType) {
        this.eplClassType = eplClassType;
    }

    public EplVaDrugClassDo getEplVaDrugClass() {
        return eplVaDrugClass;
    }

    public void setEplVaDrugClass(EplVaDrugClassDo eplVaDrugClass) {
        this.eplVaDrugClass = eplVaDrugClass;
    }

    public Set<EplVaDrugClassDo> getEplVaDrugClasses() {
        return eplVaDrugClasses;
    }

    public void setEplVaDrugClasses(Set<EplVaDrugClassDo> eplVaDrugClasses) {
        this.eplVaDrugClasses = eplVaDrugClasses;
    }

}
