/**
 * Source file created in 2008 by Southwest Research Institute
 */


package gov.va.med.pharmacy.peps.domain.common.model;


import java.util.Date;
import java.util.HashSet;
import java.util.Set;


/**
 * EplVaDispenseUnitDo generated by hbm2java
 * @hibernate.class
 */
public class EplVaDispenseUnitDo extends gov.va.med.pharmacy.peps.domain.common.model.DataObject 
    implements java.io.Serializable {
    
    public static final String NDF_DISPENSEUNIT_IEN = "ndfDispenseunitIen";
    public static final String ITEM_STATUS = "itemStatus";
    public static final String REQUEST_STATUS = "requestStatus";
    public static final String DISPENSE_UNIT_NAME = "dispenseUnitName";
    public static final String INACTIVATION_DATE = "inactivationDate";
    public static final String EPL_ID = "eplId";
    
    private static final long serialVersionUID = 1L;

    // Fields

    private Long eplId;
    private String dispenseUnitName;
    private Long ndfDispenseunitIen;
    private Long revisionNumber;
    private String itemStatus;
    private String requestStatus;
    private String rejectReasonText;
    private String requestRejectReason;
    private Date inactivationDate;
    private Set<EplProductDo> eplProducts = new HashSet<EplProductDo>(0);

    // Constructors

    /** default constructor */

    public EplVaDispenseUnitDo() {
    }

    /** minimal constructor */

    public EplVaDispenseUnitDo(Long eplId, String dispenseUnitName, String createdBy, Date createdDtm) {
        this.eplId = eplId;
        this.dispenseUnitName = dispenseUnitName;
        this.setCreatedBy(createdBy);
        this.setCreatedDtm(createdDtm);
    }

    /** full constructor */

    public EplVaDispenseUnitDo(Long eplId, String dispenseUnitName, Long ndfDispenseunitIen, Date inactivationDate, String createdBy,
                               Date createdDtm, String lastModifiedBy, Date lastModifiedDtm, Set<EplProductDo> eplProducts) {
        this.eplId = eplId;
        this.dispenseUnitName = dispenseUnitName;
        this.ndfDispenseunitIen = ndfDispenseunitIen;
        this.inactivationDate = inactivationDate;
        this.setCreatedBy(createdBy);
        this.setCreatedDtm(createdDtm);
        this.setLastModifiedBy(lastModifiedBy);
        this.setLastModifiedDtm(lastModifiedDtm);
        this.eplProducts = eplProducts;
    }

    // Property accessors
    public Long getEplId() {
        return this.eplId;
    }

    public void setNdfDispenseunitIen(Long ndfDispenseunitIen) {
        this.ndfDispenseunitIen = ndfDispenseunitIen;
    }
    
    public Long getNdfDispenseunitIen() {
        return this.ndfDispenseunitIen;
    }

    public void setEplId(Long eplId) {
        this.eplId = eplId;
    }

    public String getDispenseUnitName() {
        return this.dispenseUnitName;
    }

    public void setDispenseUnitName(String dispenseUnitName) {
        this.dispenseUnitName = dispenseUnitName;
    }

    public Date getInactivationDate() {
        return this.inactivationDate;
    }

    public void setInactivationDate(Date inactivationDate) {
        this.inactivationDate = inactivationDate;
    }

    public Set<EplProductDo> getEplProducts() {
        return this.eplProducts;
    }

    public void setEplProducts(Set<EplProductDo> eplProducts) {
        this.eplProducts = eplProducts;
    }

    /**
     * toString
     * 
     * @return String
     */
    public String toString() {
        StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");
        buffer.append("dispenseUnitName").append("='").append(getDispenseUnitName()).append("' ");
        buffer.append("ndfDispenseunitIen").append("='").append(getDispenseUnitName()).append("' ");
        buffer.append("inactivationDate").append("='").append(getInactivationDate()).append("' ");
        buffer.append("createdBy").append("='").append(getCreatedBy()).append("' ");
        buffer.append("createdDtm").append("='").append(getCreatedDtm()).append("' ");
        buffer.append("lastModifiedBy").append("='").append(getLastModifiedBy()).append("' ");
        buffer.append("lastModifiedDtm").append("='").append(getLastModifiedDtm()).append("' ");
        buffer.append("]");

        return buffer.toString();
    }

    public boolean equals(Object other) {
        if ((this == other)) {
            return true;
        }

        if ((other == null)) {
            return false;
        }

        if (!(other instanceof EplVaDispenseUnitDo)) {
            return false;
        }

        EplVaDispenseUnitDo castOther = (EplVaDispenseUnitDo) other;

        return ((this.getEplId() == castOther.getEplId()) || (this.getEplId() != null 
            && castOther.getEplId() != null && this.getEplId().equals(castOther.getEplId())))
            && ((this.getNdfDispenseunitIen() == castOther.getNdfDispenseunitIen()) || (this.getNdfDispenseunitIen() != null && castOther.getNdfDispenseunitIen() != null && this
                .getNdfDispenseunitIen().equals(castOther.getNdfDispenseunitIen())))
                            
            && ((this.getDispenseUnitName() == castOther.getDispenseUnitName()) || (this.getDispenseUnitName() != null
                && castOther.getDispenseUnitName() != null && this.getDispenseUnitName().equals(
                    castOther.getDispenseUnitName())))
            && ((this.getInactivationDate() == castOther.getInactivationDate()) || (this.getInactivationDate() != null
                && castOther.getInactivationDate() != null && this.getInactivationDate().equals(
                    castOther.getInactivationDate())))
            && ((this.getCreatedBy() == castOther.getCreatedBy()) || (this.getCreatedBy() != null
                && castOther.getCreatedBy() != null && this.getCreatedBy().equals(castOther.getCreatedBy())))
            && ((this.getCreatedDtm() == castOther.getCreatedDtm()) || (this.getCreatedDtm() != null
                && castOther.getCreatedDtm() != null && this.getCreatedDtm().equals(castOther.getCreatedDtm())))
            && ((this.getLastModifiedBy() == castOther.getLastModifiedBy()) || (this.getLastModifiedBy() != null
                && castOther.getLastModifiedBy() != null && this.getLastModifiedBy().equals(castOther.getLastModifiedBy())))
            && ((this.getLastModifiedDtm() == castOther.getLastModifiedDtm()) || (this.getLastModifiedDtm() != null
                && castOther.getLastModifiedDtm() != null && this.getLastModifiedDtm()
                .equals(castOther.getLastModifiedDtm())));
    }

    public int hashCode() {
        int result = 17;

        result = 37 * result + (getEplId() == null ? 0 : this.getEplId().hashCode());
        result = 37 * result + (this.getNdfDispenseunitIen() == null ? 0 : this.getNdfDispenseunitIen().hashCode());
        result = 37 * result + (getDispenseUnitName() == null ? 0 : this.getDispenseUnitName().hashCode());
        result = 37 * result + (getInactivationDate() == null ? 0 : this.getInactivationDate().hashCode());
        result = 37 * result + (getCreatedBy() == null ? 0 : this.getCreatedBy().hashCode());
        result = 37 * result + (getCreatedDtm() == null ? 0 : this.getCreatedDtm().hashCode());
        result = 37 * result + (getLastModifiedBy() == null ? 0 : this.getLastModifiedBy().hashCode());
        result = 37 * result + (getLastModifiedDtm() == null ? 0 : this.getLastModifiedDtm().hashCode());

        return result;
    }

    public Long getRevisionNumber() {
        return revisionNumber;
    }

    public void setRevisionNumber(Long revisionNumber) {
        this.revisionNumber = revisionNumber;
    }

    public String getItemStatus() {
        return itemStatus;
    }

    public void setItemStatus(String itemStatus) {
        this.itemStatus = itemStatus;
    }

    public String getRequestStatus() {
        return requestStatus;
    }

    public void setRequestStatus(String requestStatus) {
        this.requestStatus = requestStatus;
    }

    public String getRejectReasonText() {
        return rejectReasonText;
    }

    public void setRejectReasonText(String rejectReasonText) {
        this.rejectReasonText = rejectReasonText;
    }

    public String getRequestRejectReason() {
        return requestRejectReason;
    }

    public void setRequestRejectReason(String requestRejectReason) {
        this.requestRejectReason = requestRejectReason;
    }

}
