package gov.va.med.pharmacy.peps.domain.common.model;

import javax.persistence.Column;
import javax.persistence.ColumnResult;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import javax.persistence.Table;

import org.hibernate.annotations.NamedNativeQueries;
import org.hibernate.annotations.NamedNativeQuery;
import org.hibernate.annotations.NamedQueries;
import org.hibernate.annotations.NamedQuery;
import org.hibernate.annotations.Type;


@Entity

@NamedQueries({                
    @NamedQuery(
    name = "retrieveAll",
    query = "SELECT rematch FROM EplRematchSuggestionDo rematch WHERE rematch.ndcUpdateFile is NULL"
    ),
    
    @NamedQuery(
        name = "retrieveAllByDate",
        query = "SELECT rematch FROM EplRematchSuggestionDo rematch " +
        		"WHERE rematch.ndcUpdateFile is NULL " +
        		"AND rematch.createdDtm BETWEEN " +
                     "(SELECT MAX(updt.createdDtm) FROM EplNdfUpdateFileDo updt WHERE updt.eplStatus.statusId = 8)  " +
                              "AND :startDate "
        ),
    
    @NamedQuery(
        name = "retrieveByMatch",
        query = "SELECT rematch FROM EplRematchSuggestionDo rematch " +
        		"WHERE rematch.matchType.matchTypeId = :matchTypeId " +
        		    "AND rematch.ndcUpdateFile is NULL "
        ),
        
    @NamedQuery(
        name = "retrieveProductId",
        query = "SELECT p.eplId FROM EplProductDo p WHERE p.ndfProductIen = :productIen "
    )    
    
})

@SqlResultSetMappings({
    @SqlResultSetMapping(name = "obsoleteUnmatch",
        columns = { @ColumnResult(name = "rematchOldIen"),
                    @ColumnResult(name = "rematchSuggId")                    
        }),
    @SqlResultSetMapping(name = "loadUnmatch",
    columns = { @ColumnResult(name = "odiffVistaIen"),
                @ColumnResult(name = "matchType")                    
    }),
    
    @SqlResultSetMapping(name = "findRematch",
    columns = { @ColumnResult(name = "matchedProductId"),
                @ColumnResult(name = "matchedProductName"),
                @ColumnResult(name = "matchedCmop"),
                @ColumnResult(name = "matchedIen")
    }),
    
    @SqlResultSetMapping(name = "rematchSuggestion",
    columns = { @ColumnResult(name = "oldIen"),
                @ColumnResult(name = "rematchedIen"),
                @ColumnResult(name = "productName"),
                @ColumnResult(name = "cmopId"),
                @ColumnResult(name = "rematchedProductName"),
                @ColumnResult(name = "rematchedCmopId"),
    }),
    
    @SqlResultSetMapping(name = "rematchNoSuggestion",
    columns = { @ColumnResult(name = "oldIen"),
                @ColumnResult(name = "rematchedIen"),
                @ColumnResult(name = "productName"),
                @ColumnResult(name = "cmopId")
                
    })
})

@NamedNativeQueries({
    @NamedNativeQuery(name = "obsoleteUnmatch",
        query = "SELECT rematch.old_ien as rematchOldIen, rematch.epl_rematch_suggestion_id as rematchSuggId FROM epl_rematch_suggestion rematch " +
                "WHERE rematch.match_type_id_fk = :matchTypeId and rematch.old_ien NOT IN ( " +
                "SELECT odiff.vista_ien FROM Epl_Ndf_Outgoing_Differences odiff, Epl_Products p " +
                "WHERE odiff.ndc_Update_File_Fk IS NULL " +
                    "AND odiff.vista_File_Number = :vistaFileNumber " +
                    "AND odiff.vista_Field_Number in ('.05','1','2','3','5','6','8','19') " +
                    "AND odiff.old_Value <> odiff.new_Value  " +
                    "AND odiff.vista_Ien = p.ndf_Product_Ien " +
                    "AND odiff.action_Type = 'M')  ",                  
        resultSetMapping="obsoleteUnmatch"), 
    
    @NamedNativeQuery(name = "loadUnmatch",
    query = "SELECT odiff.vista_ien as odiffVistaIen, :matchTypeId as matchType FROM Epl_Ndf_Outgoing_Differences odiff, Epl_Products p " +
            "WHERE odiff.ndc_Update_File_Fk IS NULL " +            
                "AND odiff.vista_File_Number = :vistaFileNumber " +
                "AND odiff.vista_Field_Number = :vistaFieldNumber " +
                "AND odiff.old_Value <> odiff.new_Value  " +
                "AND odiff.vista_Ien = p.ndf_Product_Ien " +
                "AND odiff.action_Type = 'M' " +
                "AND (odiff.vista_Ien NOT IN (select old_ien from epl_rematch_suggestion rematch where rematch.match_type_id_fk = :matchTypeId)) ",
    resultSetMapping="loadUnmatch"),
    
    @NamedNativeQuery(name = "loadUnmatchCmop",
    query = "SELECT odiff.vista_ien as odiffVistaIen, :matchTypeId as matchType FROM Epl_Ndf_Outgoing_Differences odiff, Epl_Products p " +
            "WHERE odiff.ndc_Update_File_Fk IS NULL " +            
                "AND odiff.vista_File_Number = :vistaFileNumber " +
                "AND odiff.vista_Field_Number = :vistaFieldNumber " +
                "AND odiff.old_Value <> odiff.new_Value  " +
                "AND odiff.vista_Ien = p.ndf_Product_Ien " +
                "AND odiff.action_Type = 'M' " +
                "AND odiff.vista_Ien NOT IN ( SELECT Vista_Ien FROM Epl_Ndf_Outgoing_Differences odiff2 " +
                                              "WHERE odiff2.ndc_Update_File_Fk IS NULL " +
                                                  "AND odiff2.vista_File_Number = :vistaFileNumber " +
                                                  "AND odiff2.vista_Field_Number = :vistaFieldNumber " +
                                                  "AND odiff2.action_Type = 'A' " +
                                                  "AND odiff2.new_Value = odiff.new_Value ) " + 
                "AND (odiff.vista_Ien NOT IN (select old_ien from epl_rematch_suggestion rematch where rematch.match_type_id_fk = :matchTypeId)) ",
    resultSetMapping="loadUnmatch"),
    
    @NamedNativeQuery(name = "obsoleteInactiveUnmatch",
    query = "SELECT rematch.old_ien as rematchOldIen, rematch.epl_rematch_suggestion_id as rematchSuggId FROM epl_rematch_suggestion rematch " +
            "WHERE rematch.match_type_id_fk = 1 and rematch.old_ien NOT IN ( " +
            "SELECT odiff.vista_ien FROM Epl_Ndf_Outgoing_Differences odiff, Epl_Products p " +
            "WHERE odiff.ndc_Update_File_Fk IS NULL " +
                "AND odiff.vista_File_Number = :vistaFileNumber " +
                "AND odiff.vista_Field_Number = :vistaFieldNumber " +
                "AND odiff.new_Value <> ' ' " +
                "AND odiff.old_Value IS NULL  " +                
                "AND odiff.vista_Ien = p.ndf_Product_Ien " +
                "AND odiff.action_Type = 'M')  ",                  
    resultSetMapping="obsoleteUnmatch"),
    
    @NamedNativeQuery(name = "loadInactiveUnmatch",
    query = "SELECT odiff.vista_ien as odiffVistaIen, 1 as matchType FROM Epl_Ndf_Outgoing_Differences odiff, Epl_Products p " +
            "WHERE odiff.ndc_Update_File_Fk IS NULL " +            
                "AND odiff.vista_File_Number = :vistaFileNumber " +
                "AND odiff.vista_Field_Number = :vistaFieldNumber " +
                "AND odiff.new_Value <> ' ' " +
                "AND odiff.old_Value IS NULL " +
                "AND odiff.action_Type = 'M' " +
                "AND odiff.vista_Ien = p.ndf_Product_Ien " +                
                "AND (odiff.vista_Ien NOT IN (select old_ien from epl_rematch_suggestion rematch where rematch.match_type_id_fk = 1)) ",
    resultSetMapping="loadUnmatch"),
    
    @NamedNativeQuery(name = "obsoleteFutureInactiveUnmatch",
    query = "SELECT rematch.old_ien as rematchOldIen, rematch.epl_rematch_suggestion_id as rematchSuggId FROM epl_rematch_suggestion rematch " +
            "WHERE rematch.match_type_id_fk = 2 and rematch.old_ien NOT IN ( " +
                "SELECT p.ndf_Product_Ien FROM epl_products p, epl_vadf_owners owner, epl_vadf_nonlist_values non_list " +
                "WHERE owner.epl_id_product_fk = p.epl_id " +
                    "AND p.item_status = 'ACTIVE' " +
                    "AND owner.id = non_list.vadf_owner_id_fk " +
                    "AND vadf_id_fk = '60')  ",                                 
    resultSetMapping="obsoleteUnmatch"),
    
    @NamedNativeQuery(name = "loadFutureInactiveUnmatch",
    query = "SELECT p.ndf_Product_Ien as odiffVistaIen, 2 as matchType FROM epl_products p, epl_vadf_owners owner, epl_vadf_nonlist_values non_list " +
            "WHERE owner.epl_id_product_fk = p.epl_id " +            
                "AND p.item_status = 'ACTIVE' " +
                "AND owner.id = non_list.vadf_owner_id_fk " +
                "AND vadf_id_fk = '60' " +                              
                "AND (p.ndf_Product_Ien NOT IN (select old_ien from epl_rematch_suggestion rematch where rematch.match_type_id_fk = 2)) ",
    resultSetMapping="loadUnmatch"),
    
    @NamedNativeQuery(name = "findRematch",
    query = "select p2.epl_id as matchedProductId, p2.va_product_name as matchedProductName, p2.cmop_id as matchedCmop, p2.ndf_product_ien as matchedIen from ppsnepl.epl_products p1, ppsnepl.epl_products p2 " +
            "where p1.epl_id = :unmatchedProductId " +            
                "and p1.epl_id != p2.epl_id " +
                "and nvl(p1.strength,0) = nvl(p2.strength,0) " +
                "and nvl(p1.drug_unit_id_fk,0) = nvl(p2.drug_unit_id_fk,0)  " +
                "and p1.epl_id_oi_fk = p2.epl_id_oi_fk " +
                "and p2.inactivation_date is null " +
                "and p2.request_status = 'APPROVED' " +
                "and p2.item_status = 'ACTIVE' " +
                "union " +
                "select p1.epl_id as matchedProductId, p1.va_product_name as matchedProductName, p1.cmop_id as matchedCmop, p1.ndf_product_ien as matchedIen from ppsnepl.epl_products p1, ppsnepl.epl_ndcs ndc " +
                "where ndc.EPL_ID_PRODUCT_FK = :unmatchedProductId " +
                "and p1.epl_id != :unmatchedProductId " +
                "and p1.inactivation_date is null " +
                "and p1.request_status = 'APPROVED'  " +
                "and ndc.item_status = 'ACTIVE' " +
                "and ndc.EPL_ID_PRODUCT_FK = p1.epl_id ",
    resultSetMapping="findRematch"),
    
    @NamedNativeQuery(name = "rematchSuggestion",
    query = "SELECT OLD_IEN as oldIen, new_ien as rematchedIen, p.va_Product_Name as productName, p.cmop_Id as cmopId, " +
    		    "(SELECT p.va_product_name FROM epl_products p where p.ndf_Product_Ien = rematch.new_ien) as rematchedProductName," +
    		    "(SELECT p.cmop_id FROM epl_products p where p.ndf_Product_Ien = rematch.new_ien) as rematchedCmopId " +
    		"FROM epl_rematch_suggestion rematch, epl_products p " +
            "WHERE NDC_UPDATE_FILE_FK is NULL " +            
                "AND NEW_IEN IS NOT NULL " +
                "AND rematch.OLD_IEN = p.ndf_Product_Ien " +
                "AND rematch.created_Dtm BETWEEN  " +
                    "(SELECT MAX(updt.created_Dtm) FROM EPL_NDF_UPDATE_FILE updt WHERE updt.status_id_fk = 8) " +
                        "AND :startDate " +
                "AND MATCH_SCOPE = 'N' " +
                "AND MATCH_TYPE_ID_FK = 3 " ,
    resultSetMapping="rematchSuggestion"),
    
    @NamedNativeQuery(name = "rematchAuto",
    query = "SELECT OLD_IEN as oldIen, new_ien as rematchedIen, p.va_Product_Name as productName, p.cmop_Id as cmopId, " +
                "(SELECT p.va_product_name FROM epl_products p where p.ndf_Product_Ien = rematch.new_ien) as rematchedProductName, " +
                "(SELECT p.cmop_id FROM epl_products p where p.ndf_Product_Ien = rematch.new_ien) as rematchedCmopId " +
            "FROM epl_rematch_suggestion rematch, epl_products p " +
            "WHERE NDC_UPDATE_FILE_FK is NULL " +            
                "AND NEW_IEN IS NOT NULL " +
                "AND rematch.OLD_IEN = p.ndf_Product_Ien " +
                "AND rematch.created_Dtm BETWEEN  " +
                    "(SELECT MAX(updt.created_Dtm) FROM EPL_NDF_UPDATE_FILE updt WHERE updt.status_id_fk = 8) " +
                        "AND :startDate " +
                "AND MATCH_SCOPE = 'Y' " +
                "AND MATCH_TYPE_ID_FK = 3 " ,
    resultSetMapping="rematchSuggestion"),
    
    @NamedNativeQuery(name = "rematchNoSuggestion",
    query = "SELECT OLD_IEN as oldIen, new_ien as rematchedIen, p.va_Product_Name as productName, p.cmop_Id as cmopId " +               
            "FROM epl_rematch_suggestion rematch, epl_products p " +
            "WHERE NDC_UPDATE_FILE_FK is NULL " +            
                "AND NEW_IEN IS NULL " +
                "AND rematch.OLD_IEN = p.ndf_Product_Ien " +
                "AND rematch.created_Dtm BETWEEN  " +
                    "(SELECT MAX(updt.created_Dtm) FROM EPL_NDF_UPDATE_FILE updt WHERE updt.status_id_fk = 8) " +
                        "AND :startDate " +
                "AND MATCH_TYPE_ID_FK = 3 " ,
    resultSetMapping="rematchNoSuggestion")
   
} )

@Table(name = "EPL_REMATCH_SUGGESTION"
, schema = "PPSNEPL")
public class EplRematchSuggestionDo extends AnnotatedDataObject implements java.io.Serializable {
    
    private static final long serialVersionUID = -5304285167591771914L;
    
    private Long eplRematchSuggestionId;
    private String oldIen;    
    private String newIen;
    private EplMatchTypeDo matchType;
    private EplNdfUpdateFileDo ndcUpdateFile;
    private Boolean matchScope;
    
    /** default constructor */
    
    public EplRematchSuggestionDo() {
    }

    /** minimal constructor */
    
    public EplRematchSuggestionDo(Long eplRematchSuggestionId, String oldIen, String newIen, EplMatchTypeDo matchType) {
        this.eplRematchSuggestionId = eplRematchSuggestionId;
        this.setOldIen(oldIen);
        this.setNewIen(newIen);
        this.setMatchType(matchType);
    }

    /** full constructor */
    
    public EplRematchSuggestionDo(Long eplRematchSuggestionId, String oldIen, String newIen, EplMatchTypeDo matchType, EplNdfUpdateFileDo ndcUpdateFile) {
        this.eplRematchSuggestionId = eplRematchSuggestionId;
        this.setOldIen(oldIen);
        this.setNewIen(newIen);
        this.setMatchType(matchType);
        this.setNdcUpdateFile(ndcUpdateFile);
    }
    
    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "rematchSuggestionSeqGen")
    @SequenceGenerator(name = "rematchSuggestionSeqGen", sequenceName="EPL_REMATCH_SUGGESTION_SEQ")
    @Column(name = "EPL_REMATCH_SUGGESTION_ID", unique = true, nullable = false, precision = 38, scale = 0)
    public Long getEplRematchSuggestionId() {
        return eplRematchSuggestionId;
    }
    
    public void setEplRematchSuggestionId(Long eplRematchSuggestionId) {
        this.eplRematchSuggestionId = eplRematchSuggestionId;
    }
    
    @Column(name = "OLD_IEN", nullable = false, length = 50)
    public String getOldIen() {
        return oldIen;
    }
    
    public void setOldIen(String oldIen) {
        this.oldIen = oldIen;
    }
    
    @Column(name = "NEW_IEN", nullable = true, length = 50)
    public String getNewIen() {
        return newIen;
    }
    
    public void setNewIen(String newIen) {
        this.newIen = newIen;
    } 
    
    @ManyToOne(fetch = FetchType.LAZY)  
    @JoinColumn(name = "MATCH_TYPE_ID_FK")
    public EplMatchTypeDo getMatchType() {
        return matchType;
    }
    
    public void setMatchType(EplMatchTypeDo matchType) {
        this.matchType = matchType;
    }
    
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "NDC_UPDATE_FILE_FK")
    public EplNdfUpdateFileDo getNdcUpdateFile() {
        return ndcUpdateFile;
    }
    
    public void setNdcUpdateFile(EplNdfUpdateFileDo ndcUpdateFile) {
        this.ndcUpdateFile = ndcUpdateFile;
    }    

    @Column(name = "MATCH_SCOPE", nullable = true, length = 50)
    @Type(type="yes_no")
    public Boolean getMatchScope() {

        return matchScope;

    }

    public void setMatchScope(Boolean matchScope) {

        this.matchScope = matchScope;

    }

}
