

package gov.va.med.pharmacy.peps.domain.common.model;


import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;


/**
 * EplPackageSizeDo
 */
@NamedQueries({
    @NamedQuery(name="retrieveByPackageSize",
        query="select pkgsize from EplPackageSizeDo pkgsize where pkgsize.packageSize = :packageSize ")    
})

@Entity
@Table(name = "EPL_PACKAGE_SIZES"
    , schema = "PPSNEPL")
public class EplPackageSizeDo extends AnnotatedDataObject implements java.io.Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = -8735230445609556555L;
 
    public static final String EPL_ID = "eplId";
    public static final String PACKAGE_SIZE = "packageSize";
    public static final String NDF_PACKAGE_SIZE_IEN = "ndfPackageSizeIen";


    // Fields

    private Long eplId;
    private Double packageSize;
    private Long ndfPackageSizeIen;
//    private Set<EplNdcDo> eplNdcs = new HashSet<EplNdcDo>(0);

    /** default constructor */
    public EplPackageSizeDo() {
    }

    /** full constructor */
    public EplPackageSizeDo(Long eplId, Double packageSize, Long ndfPackageSizeIen ,String createdBy, Date createdDtm,        
        String lastModifiedBy, Date lastModifiedDtm) {
        this.eplId = eplId;
        this.packageSize = packageSize;
        this.ndfPackageSizeIen = ndfPackageSizeIen;
        this.setCreatedBy(createdBy);
        this.setCreatedDtm(createdDtm);
        this.setLastModifiedBy(lastModifiedBy);
        this.setLastModifiedDtm(lastModifiedDtm);
    }
    
    /** minimal constructor */
    public EplPackageSizeDo(Long eplId, Double packageSize, Long ndfPackageSizeIen,String createdBy, Date createdDtm) {
    
        this.eplId = eplId;
        this.packageSize = packageSize;
        this.ndfPackageSizeIen = ndfPackageSizeIen;
        this.setCreatedBy(createdBy);
        this.setCreatedDtm(createdDtm);
    }

    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "packageSizesSeqGen")
    @SequenceGenerator(name = "packageSizesSeqGen", sequenceName="EPL_PACKAGE_SIZES_SEQ")
    @Column(name = "EPL_ID", unique = true, nullable = false, precision = 30, scale = 0)
    public Long getEplId() {
        return this.eplId;
    }

    public void setEplId(Long eplId) {
        this.eplId = eplId;
    }

    @Column(name = "PACKAGE_SIZE", nullable = false, precision = 13, scale = 0)
    public Double getPackageSize() {
        return this.packageSize;
    }

    public void setPackageSize(Double packageSize) {
        this.packageSize = packageSize;
    }

    @Column(name = "NDF_PACKAGE_SIZE_IEN", nullable = false, precision = 30, scale = 0)
    public Long getNdfPackageSizeIen() {
        return this.ndfPackageSizeIen;
    }
    
    public void setNdfPackageSizeIen(Long ndfPackageSizeIen) {
        this.ndfPackageSizeIen = ndfPackageSizeIen;
    }
    


}
