package gov.va.med.pharmacy.peps.domain.common.model;


// Generated Mar 13, 2014 4:13:49 PM by Hibernate Tools 3.4.0.CR1
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.ColumnResult;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import javax.persistence.Table;

import org.hibernate.annotations.NamedNativeQueries;
import org.hibernate.annotations.NamedNativeQuery;

/**
 * EplNdfOutgoingDifferences generated by hbm2java
 */
@Entity
@NamedQueries({
    @NamedQuery(name= "retrieveDifferencesForOutputFile",
        query="SELECT odiff FROM EplNdfOutgoingDifferences odiff " +
                "WHERE odiff.createdDtm BETWEEN " +
                "(SELECT MAX(updt.createdDtm) FROM EplNdfUpdateFileDo updt WHERE updt.eplStatus.statusId = 8)  " +
                "AND :startDate AND odiff.ndcUpdateFileFk IS NULL " +
                "ORDER BY odiff.actionType, odiff.vistaFileNumber, odiff.vistaFieldNumber"),
                        
    @NamedQuery(name= "findByFileFieldIen",
        query="SELECT odiff FROM EplNdfOutgoingDifferences odiff " +
                "WHERE odiff.vistaFileNumber = :vistaFileNumber AND odiff.vistaFieldNumber = :vistaFieldNumber " +
                "AND odiff.vistaIen = :vistaIen AND odiff.ndcUpdateFileFk IS NULL  " +
                "ORDER BY odiff.vistaFileNumber, odiff.vistaFieldNumber, odiff.vistaIen"),
                
    @NamedQuery(name = "findModifiedRecords",
        query = "SELECT odiff FROM EplNdfOutgoingDifferences odiff " +
            "WHERE odiff.vistaFileNumber = :vistaFileNumber AND odiff.vistaFieldNumber = :vistaFieldNumber " +
            "AND odiff.vistaIen = :vistaIen AND odiff.actionType = :actionType AND odiff.ndcUpdateFileFk IS NULL  " +
            "ORDER BY odiff.vistaFileNumber, odiff.vistaFieldNumber, odiff.vistaIen"),
    
    @NamedQuery(name= "findByFileAndField",
        query="SELECT odiff.vistaIen, odiff.newValue FROM EplNdfOutgoingDifferences odiff " +
              "WHERE odiff.vistaFileNumber = :vistaFileNumber " +
                  "AND odiff.vistaFieldNumber = :vistaFieldNumber " +
                  "AND odiff.createdDtm BETWEEN " +
                      "(SELECT MAX(updt.createdDtm) FROM EplNdfUpdateFileDo updt WHERE updt.eplStatus.statusId = 8)  " +
                          "AND :startDate " +
                  "AND odiff.ndcUpdateFileFk IS NULL " +
                  "AND odiff.actionType = 'M' " +
              "ORDER BY odiff.vistaIen"),
            
    @NamedQuery(name="findDrugClassChanges",
       query="SELECT odiff.vistaIen, odiff.newValue, prod.eplVaGenName.ndfGenericIen FROM EplNdfOutgoingDifferences odiff, EplProductDo prod  " +
             "WHERE odiff.vistaIen = prod.ndfProductIen " +
                 "AND odiff.vistaFileNumber = :vistaFileNumber " +
                 "AND odiff.vistaFieldNumber = :vistaFieldNumber " +
                 "AND odiff.createdDtm BETWEEN " +
                 "(SELECT MAX(updt.createdDtm) FROM EplNdfUpdateFileDo updt WHERE updt.eplStatus.statusId = 8)  " +
                     "AND :startDate " +
                 "AND odiff.ndcUpdateFileFk IS NULL " +
                 "AND odiff.actionType = 'M' " +
             "ORDER BY odiff.vistaIen"),
    
    @NamedQuery(name= "genericNameInactivateReport",
        query="SELECT odiff.vistaIen " +
              "FROM EplNdfOutgoingDifferences odiff " +
              "WHERE odiff.vistaFileNumber = :vistaFileNumber " + 
                  "AND odiff.vistaFieldNumber = :vistaFieldNumber " +
                  "AND odiff.createdDtm BETWEEN " +
                      "(SELECT MAX(updt.createdDtm) FROM EplNdfUpdateFileDo updt WHERE updt.eplStatus.statusId = 8)  " +
                          "AND :startDate " +
                  "AND odiff.newValue <> ' ' " + 
                  "AND odiff.ndcUpdateFileFk IS NULL " +
              "ORDER BY odiff.vistaIen"),
    
    @NamedQuery(name= "overrideDFChkExclReport",
        query="SELECT odiff.newValue, p.vaProductName, p.cmopId " +
              "FROM EplNdfOutgoingDifferences odiff, EplProductDo p " +
              "WHERE odiff.ndcUpdateFileFk IS NULL " +
                  "AND odiff.vistaFileNumber = :vistaFileNumber " +
                  "AND odiff.vistaFieldNumber = :vistaFieldNumber " +
                  "AND odiff.createdDtm BETWEEN " +
                      "(SELECT MAX(updt.createdDtm) FROM EplNdfUpdateFileDo updt WHERE updt.eplStatus.statusId = 8)  " +
                          "AND :startDate " +
                  "AND odiff.vistaIen = p.ndfProductIen " +
                  "AND odiff.actionType = 'M' " +
               "ORDER BY odiff.vistaIen"),
              
    @NamedQuery(name = "activeNatFormularyChangeReport",
        query = "SELECT odiff.newValue, p.vaProductName, p.cmopId " +
                "FROM EplNdfOutgoingDifferences odiff, EplProductDo p " +
                "WHERE odiff.ndcUpdateFileFk IS NULL " +
                    "AND odiff.vistaFileNumber = :vistaFileNumber " +
                    "AND odiff.vistaFieldNumber = :vistaFieldNumber " +
                    "AND odiff.createdDtm BETWEEN " +
                        "(SELECT MAX(updt.createdDtm) FROM EplNdfUpdateFileDo updt WHERE updt.eplStatus.statusId = 8)  " +
                            "AND :startDate " +
                    "AND odiff.newValue = '1' " + 
                    "AND odiff.vistaIen = p.ndfProductIen " +
                    "AND odiff.actionType = 'M' " +
                "ORDER BY odiff.vistaIen"),
            
    @NamedQuery(name = "inactiveNatFormularyChangeReport",
        query = "SELECT odiff.newValue, p.vaProductName, p.cmopId " +
                "FROM EplNdfOutgoingDifferences odiff, EplProductDo p " +
                "WHERE odiff.ndcUpdateFileFk IS NULL " +
                    "AND odiff.vistaFileNumber = :vistaFileNumber " +
                    "AND odiff.vistaFieldNumber = :vistaFieldNumber " +
                    "AND odiff.createdDtm BETWEEN " +
                        "(SELECT MAX(updt.createdDtm) FROM EplNdfUpdateFileDo updt WHERE updt.eplStatus.statusId = 8)  " +
                            "AND :startDate " +
                    "AND odiff.newValue = '0' " +
                    "AND odiff.vistaIen = p.ndfProductIen " +
                    "AND odiff.actionType = 'M' " +
                "ORDER BY odiff.vistaIen"),
                
    @NamedQuery(name = "inactivatedCMOPReport",
        query = "SELECT odiff.newValue, p.vaProductName, p.cmopId " +
                "FROM EplNdfOutgoingDifferences odiff, EplProductDo p " +
                "WHERE odiff.ndcUpdateFileFk IS NULL " +
                    "AND odiff.vistaFileNumber = :vistaFileNumber " +
                    "AND odiff.vistaFieldNumber = :vistaFieldNumber " +
                    "AND odiff.createdDtm BETWEEN " +
                        "(SELECT MAX(updt.createdDtm) FROM EplNdfUpdateFileDo updt WHERE updt.eplStatus.statusId = 8)  " +
                        "AND :startDate " +
                    "AND odiff.newValue = '0' " +
                    "AND odiff.vistaIen = p.ndfProductIen " +
                    "AND odiff.actionType = 'M' " +
                "ORDER BY odiff.vistaIen"),
                
    @NamedQuery(name = "unmatchedProducts",
        query = "SELECT DISTINCT odiff.vistaIen, p.vaProductName, p.cmopId " +
                "FROM EplNdfOutgoingDifferences odiff, EplProductDo p " +
                "WHERE odiff.vistaFileNumber = :vistaFileNumber " +
                    "AND odiff.vistaFieldNumber in ('6','5','8','3','2','.05','1') " +
                    "AND odiff.oldValue <> odiff.newValue " +
                    "AND odiff.ndcUpdateFileFk IS NULL " +
                    "AND odiff.vistaIen = p.ndfProductIen " +
                    "AND odiff.actionType = 'M' " +
                "ORDER BY odiff.vistaIen"),
                
    @NamedQuery(name = "inactivatedProductsForLocal",
        query = "SELECT DISTINCT odiff.vistaIen, p.vaProductName, p.cmopId " +
                "FROM EplNdfOutgoingDifferences odiff, EplProductDo p " +
                "WHERE odiff.vistaFileNumber = :vistaFileNumber " +
                    "AND odiff.vistaFieldNumber in ('5','2','8','.05') " +
                    "AND odiff.createdDtm BETWEEN " +
                        "(SELECT MAX(updt.createdDtm) FROM EplNdfUpdateFileDo updt WHERE updt.eplStatus.statusId = 8)  " +
                            "AND :startDate " +
                    "AND odiff.oldValue <> odiff.newValue " +
                    "AND odiff.ndcUpdateFileFk IS NULL " +
                    "AND odiff.vistaIen = p.ndfProductIen " +
                    "AND odiff.actionType = 'M' " +
                "ORDER BY odiff.vistaIen"),
            
    @NamedQuery(name = "scheduleChangeReport",
        query = "SELECT odiff.vistaIen, p.vaProductName, odiff.newValue " +
                "FROM EplNdfOutgoingDifferences odiff, EplProductDo p " +
                "WHERE odiff.ndcUpdateFileFk IS NULL " +
                    "AND odiff.actionType = 'M' " +
                    "AND odiff.vistaFileNumber = :vistaFileNumber " +
                    "AND odiff.vistaFieldNumber = :vistaFieldNumber " +
                    "AND odiff.oldValue <> odiff.newValue " +
                    "AND odiff.vistaIen = p.ndfProductIen " +                    
                "ORDER BY odiff.vistaIen"),
                
    @NamedQuery(name = "noPossibleDosageReport",
        query = "SELECT odiff.vistaFieldNumber, odiff.newValue, odiff.vistaIen, p.vaProductName, p.cmopId " +
                "FROM EplNdfOutgoingDifferences odiff, EplProductDo p " +
                "WHERE odiff.ndcUpdateFileFk IS NULL " +                    
                    "AND odiff.vistaFileNumber = :vistaFileNumber " +
                    "AND odiff.vistaFieldNumber in ('41','42') " +
                    "AND odiff.createdDtm BETWEEN " +
                        "(SELECT MAX(updt.createdDtm) FROM EplNdfUpdateFileDo updt WHERE updt.eplStatus.statusId = 8)  " +
                            "AND :startDate " +
                    "AND odiff.oldValue <> odiff.newValue " +
                    "AND odiff.vistaIen = p.ndfProductIen " +                    
                    "AND p.ndfProductIen in (SELECT vistaIen FROM EplNdfOutgoingDifferences WHERE vistaFieldNumber = '40' and newValue = 'N') " +
                    "AND odiff.actionType = 'M' " +
                "ORDER BY odiff.vistaIen, p.cmopId, odiff.vistaFieldNumber"),
                
    @NamedQuery(name = "yesPossibleDosageReport",
        query = "SELECT odiff.newValue, p.vaProductName, p.cmopId " +
                "FROM EplNdfOutgoingDifferences odiff, EplProductDo p " +
                "WHERE odiff.ndcUpdateFileFk IS NULL " +                
                    "AND odiff.vistaFileNumber = :vistaFileNumber " +
                    "AND odiff.vistaFieldNumber = :vistaFieldNumber " +
                    "AND odiff.createdDtm BETWEEN " +
                        "(SELECT MAX(updt.createdDtm) FROM EplNdfUpdateFileDo updt WHERE updt.eplStatus.statusId = 8)  " +
                            "AND :startDate " +
                    "AND odiff.oldValue <> odiff.newValue " +
                    "AND odiff.newValue ='Y' " +
                    "AND odiff.vistaIen = p.ndfProductIen " +
                    "AND odiff.actionType = 'M' " +
                "ORDER BY p.vaProductName"),
                
    @NamedQuery(name = "printNameChangeReport",
        query = "SELECT odiff.newValue, odiff.oldValue, p.vaProductName " +
                "FROM EplNdfOutgoingDifferences odiff, EplProductDo p " +
                "WHERE odiff.ndcUpdateFileFk IS NULL " +
                    "AND odiff.vistaFileNumber = :vistaFileNumber " +
                    "AND odiff.vistaFieldNumber = :vistaFieldNumber " +
                    "AND odiff.oldValue <> odiff.newValue " +                    
                    "AND odiff.vistaIen = p.ndfProductIen " +
                    "AND odiff.actionType = 'M' " +
                "ORDER BY p.vaProductName"),
                
    @NamedQuery(name = "messageGenericChangeReport",
        query = "SELECT odiff.newValue, odiff.oldValue, p.vaProductName, p.cmopId " +
                "FROM EplNdfOutgoingDifferences odiff, EplProductDo p " +
                "WHERE odiff.ndcUpdateFileFk IS NULL " +
                    "AND odiff.vistaFileNumber = :vistaFileNumber " +
                    "AND odiff.vistaFieldNumber = :vistaFieldNumber " +
                    "AND odiff.createdDtm BETWEEN " +
                        "(SELECT MAX(updt.createdDtm) FROM EplNdfUpdateFileDo updt WHERE updt.eplStatus.statusId = 8)  " +
                            "AND :startDate " +
                    "AND odiff.oldValue <> odiff.newValue " +                    
                    "AND odiff.vistaIen = p.ndfProductIen " +
                    "AND odiff.actionType = 'M' " +
                "ORDER BY p.vaProductName"),
                
    @NamedQuery(name = "messageCMOPChangeReport",
        query = "SELECT odiff.newValue, odiff.oldValue, p.vaProductName, p.cmopId " +
                "FROM EplNdfOutgoingDifferences odiff, EplProductDo p " +
                "WHERE odiff.ndcUpdateFileFk IS NULL " +
                    "AND odiff.vistaFileNumber = :vistaFileNumber " +
                    "AND odiff.vistaFieldNumber = :vistaFieldNumber " +                    
                    "AND odiff.createdDtm BETWEEN " +
                        "(SELECT MAX(updt.createdDtm) FROM EplNdfUpdateFileDo updt WHERE updt.eplStatus.statusId = 8)  " +
                            "AND :startDate " +
                    "AND odiff.oldValue <> odiff.newValue " +
                    "AND odiff.vistaIen = p.ndfProductIen " +
                    "AND odiff.actionType = 'M' " +
                    "AND odiff.vistaIen NOT IN ( " +
                        "SELECT vistaIen FROM EplNdfOutgoingDifferences odiff2 " +
                        "WHERE odiff2.ndcUpdateFileFk IS NULL " +
                        "AND odiff2.vistaFileNumber = :vistaFileNumber " +
                        "AND odiff2.vistaFieldNumber = :vistaFieldNumber " +  
                        "AND odiff2.createdDtm BETWEEN " +
                            "(SELECT MAX(updt.createdDtm) FROM EplNdfUpdateFileDo updt WHERE updt.eplStatus.statusId = 8)  " +
                                "AND :startDate " +
                        "AND odiff2.actionType = 'A' " +
                        "AND odiff2.newValue = odiff.newValue ) " +                    
                "ORDER BY p.vaProductName"),
    
    @NamedQuery(name = "addedMedGuideReport",
    query = "SELECT odiff.newValue, p.vaProductName, p.cmopId " +
            "FROM EplNdfOutgoingDifferences odiff, EplProductDo p " +
            "WHERE odiff.ndcUpdateFileFk IS NULL " +                
                "AND odiff.vistaFileNumber = :vistaFileNumber " +
                "AND odiff.vistaFieldNumber = :vistaFieldNumber " +
                "AND odiff.createdDtm BETWEEN " +
                    "(SELECT MAX(updt.createdDtm) FROM EplNdfUpdateFileDo updt WHERE updt.eplStatus.statusId = 8)  " +
                        "AND :startDate " +
                "AND odiff.oldValue <> odiff.newValue " +
                "AND odiff.newValue <>' ' " +
                "AND odiff.oldValue =' ' " +
                "AND odiff.vistaIen = p.ndfProductIen " +
                "AND odiff.actionType = 'M' " +
            "ORDER BY p.vaProductName"),
    
    @NamedQuery(name = "editedMedGuideReport",
    query = "SELECT odiff.newValue, p.vaProductName, p.cmopId " +
            "FROM EplNdfOutgoingDifferences odiff, EplProductDo p " +
            "WHERE odiff.ndcUpdateFileFk IS NULL " +                
                "AND odiff.vistaFileNumber = :vistaFileNumber " +
                "AND odiff.vistaFieldNumber = :vistaFieldNumber " +
                "AND odiff.createdDtm BETWEEN " +
                    "(SELECT MAX(updt.createdDtm) FROM EplNdfUpdateFileDo updt WHERE updt.eplStatus.statusId = 8)  " +
                        "AND :startDate " +
                "AND odiff.oldValue <> odiff.newValue " +
                "AND odiff.oldValue <>' ' " +
                "AND odiff.newValue <>' ' " +
                "AND odiff.vistaIen = p.ndfProductIen " +
                "AND odiff.actionType = 'M' " +
            "ORDER BY p.vaProductName"),
        
    @NamedQuery(name = "deletedMedGuideReport",
        query = "SELECT odiff.newValue, p.vaProductName, p.cmopId " +
                "FROM EplNdfOutgoingDifferences odiff, EplProductDo p " +
                "WHERE odiff.ndcUpdateFileFk IS NULL " +
                    "AND odiff.vistaFileNumber = :vistaFileNumber " +
                    "AND odiff.vistaFieldNumber = :vistaFieldNumber " +
                    "AND odiff.createdDtm BETWEEN " +
                        "(SELECT MAX(updt.createdDtm) FROM EplNdfUpdateFileDo updt WHERE updt.eplStatus.statusId = 8)  " +
                            "AND :startDate " +
                    "AND odiff.oldValue <> odiff.newValue " +
                    "AND odiff.oldValue <>' ' " +
                    "AND odiff.newValue = ' ' " +
                    "AND odiff.vistaIen = p.ndfProductIen " +
                    "AND odiff.actionType = 'M' " +
                "ORDER BY p.vaProductName"),
    
    @NamedQuery(name = "excludedDDIReport",
    query = "SELECT odiff.newValue, p.vaProductName, p.cmopId " +
            "FROM EplNdfOutgoingDifferences odiff, EplProductDo p " +
            "WHERE odiff.ndcUpdateFileFk IS NULL " +                
                "AND odiff.vistaFileNumber = :vistaFileNumber " +
                "AND odiff.vistaFieldNumber = :vistaFieldNumber " +
                "AND odiff.createdDtm BETWEEN " +
                    "(SELECT MAX(updt.createdDtm) FROM EplNdfUpdateFileDo updt WHERE updt.eplStatus.statusId = 8)  " +
                        "AND :startDate " +
                "AND odiff.oldValue <> odiff.newValue " +
                "AND odiff.newValue = '1' " +
                "AND odiff.vistaIen = p.ndfProductIen " +
                "AND odiff.actionType = 'M' " +
            "ORDER BY p.vaProductName"),
            
    @NamedQuery(name = "prevExcludedDDIReport",
        query = "SELECT odiff.newValue, p.vaProductName, p.cmopId " +
                "FROM EplNdfOutgoingDifferences odiff, EplProductDo p " +
                "WHERE odiff.ndcUpdateFileFk IS NULL " +
                    "AND odiff.vistaFileNumber = :vistaFileNumber " +
                    "AND odiff.vistaFieldNumber = :vistaFieldNumber " +
                    "AND odiff.createdDtm BETWEEN " +
                        "(SELECT MAX(updt.createdDtm) FROM EplNdfUpdateFileDo updt WHERE updt.eplStatus.statusId = 8)  " +
                            "AND :startDate " +
                    "AND odiff.oldValue <> odiff.newValue " +
                    "AND odiff.newValue = ' ' " +
                    "AND odiff.oldValue = '1' " +
                    "AND odiff.vistaIen = p.ndfProductIen " +
                    "AND odiff.actionType = 'M' " +
                "ORDER BY p.vaProductName"),
    
    @NamedQuery(name = "reactivatedProductReport",
    query = "SELECT odiff.newValue, odiff.oldValue, p.vaProductName, p.cmopId " +
            "FROM EplNdfOutgoingDifferences odiff, EplProductDo p " +
            "WHERE odiff.ndcUpdateFileFk IS NULL " +
                "AND odiff.vistaFileNumber = :vistaFileNumber " +
                "AND odiff.vistaFieldNumber = :vistaFieldNumber " +
                "AND odiff.oldValue <> odiff.newValue " + 
                "AND odiff.createdDtm BETWEEN " +
                    "(SELECT MAX(updt.createdDtm) FROM EplNdfUpdateFileDo updt WHERE updt.eplStatus.statusId = 8)  " +
                        "AND :startDate " +
                "AND odiff.oldValue <> ' ' " + 
                "AND odiff.oldValue IS NOT NULL " + 
                "AND odiff.newValue = ' ' " +
                "AND odiff.vistaIen = p.ndfProductIen " +
                "AND odiff.actionType = 'M' " +
            "ORDER BY p.vaProductName"),
            
    @NamedQuery(name = "inactivatedProductReport",
        query = "SELECT odiff.newValue, odiff.oldValue, odiff.vistaIen, p.vaProductName, p.cmopId " +
                "FROM EplNdfOutgoingDifferences odiff, EplProductDo p " +
                "WHERE odiff.ndcUpdateFileFk IS NULL " +
                    "AND odiff.vistaFileNumber = :vistaFileNumber " +
                    "AND odiff.vistaFieldNumber = :vistaFieldNumber " +
                    "AND odiff.createdDtm BETWEEN " +
                        "(SELECT MAX(updt.createdDtm) FROM EplNdfUpdateFileDo updt WHERE updt.eplStatus.statusId = 8)  " +
                            "AND :startDate " +
                    "AND odiff.newValue <> ' ' " +
                    "AND odiff.oldValue IS NULL " +                    
                    "AND odiff.vistaIen = p.ndfProductIen " +
                    "AND odiff.actionType = 'M' " +
                    "AND odiff.vistaIen NOT IN (SELECT oldIen FROM EplRematchSuggestionDo rematch " +
                                               "WHERE rematch.ndcUpdateFile is NULL  " +
                                               "AND rematch.createdDtm BETWEEN " +
                                                   "(SELECT MAX(updt.statusModifiedDtm) FROM EplNdfUpdateFileDo updt WHERE updt.eplStatus.statusId = 8)  " +
                                                       "AND :startDate " +
                                               "AND newIen IS NOT NULL " +
                                               "AND rematch.matchType.matchTypeId = 1) " +
                "ORDER BY p.vaProductName"),
            
    @NamedQuery(name = "editedDDIReport",
        query = "SELECT odiff.newValue, ddi.interactionName, s.name " +
                "FROM EplNdfOutgoingDifferences odiff, EplDrugDrugInteractionDo ddi, EplDdiSeverityDo s " +
                "WHERE odiff.ndcUpdateFileFk IS NULL " +
                    "AND odiff.vistaFileNumber = :vistaFileNumber " +
                    "AND odiff.vistaFieldNumber = :vistaFieldNumber " +
                    "AND odiff.createdDtm BETWEEN " +
                        "(SELECT MAX(updt.createdDtm) FROM EplNdfUpdateFileDo updt WHERE updt.eplStatus.statusId = 8)  " +
                            "AND :startDate " +
                    "AND odiff.actionType = 'M' " +
                    "AND odiff.oldValue <> odiff.newValue " +
                    "AND odiff.vistaIen = ddi.vistaIen " +
                    "AND ddi.severity.severityId = s.severityId " +
                "ORDER BY ddi.interactionName"),
            
    @NamedQuery(name = "inactivatedDDIReport",
        query = "SELECT odiff.vistaIen, odiff.newValue, odiff.oldValue, ddi.interactionName, s.name " +
                "FROM EplNdfOutgoingDifferences odiff, EplDrugDrugInteractionDo ddi, EplDdiSeverityDo s " +
                "WHERE odiff.ndcUpdateFileFk IS NULL " +
                    "AND odiff.vistaFileNumber = :vistaFileNumber " +
                    "AND odiff.vistaFieldNumber = :vistaFieldNumber " +
                    "AND odiff.createdDtm BETWEEN " +
                        "(SELECT MAX(updt.createdDtm) FROM EplNdfUpdateFileDo updt WHERE updt.eplStatus.statusId = 8)  " +
                            "AND :startDate " +
                    "AND odiff.actionType = 'M' " +
                    "AND odiff.newValue <> ' ' " +
                    "AND odiff.oldValue IS NULL " +
                    "AND odiff.vistaIen = ddi.vistaIen " +
                    "AND ddi.severity.severityId = s.severityId " +            
                "ORDER BY ddi.interactionName"),
            
    @NamedQuery(name = "reactivatedDDIReport",
        query = "SELECT odiff.vistaIen, odiff.newValue, odiff.oldValue, ddi.interactionName, s.name " +
                "FROM EplNdfOutgoingDifferences odiff, EplDrugDrugInteractionDo ddi, EplDdiSeverityDo s " +
                "WHERE odiff.ndcUpdateFileFk IS NULL " +
                    "AND odiff.vistaFileNumber = :vistaFileNumber " +
                    "AND odiff.vistaFieldNumber = :vistaFieldNumber " +
                    "AND odiff.createdDtm BETWEEN " +
                    "(SELECT MAX(updt.createdDtm) FROM EplNdfUpdateFileDo updt WHERE updt.eplStatus.statusId = 8)  " +
                        "AND :startDate " +
                    "AND odiff.actionType = 'M' " +
                    "AND odiff.oldValue <> odiff.newValue " +
                    "AND odiff.oldValue <> ' ' " +
                    "AND odiff.oldValue IS NOT NULL " +
                    "AND odiff.newValue = ' ' " +
                    "AND odiff.vistaIen = ddi.vistaIen " +
                    "AND ddi.severity.severityId = s.severityId " +           
                "ORDER BY ddi.interactionName")
    })

    
    @SqlResultSetMappings({
        @SqlResultSetMapping(name = "addedProductsReport",
            columns = { @ColumnResult(name = "newValue"),
                        @ColumnResult(name = "productName"),
                        @ColumnResult(name = "cmopId"),
                        @ColumnResult(name = "dispenseUnitName"),
                        @ColumnResult(name = "ndcNumber")
            }),
            
        @SqlResultSetMapping(name = "UnitsChangeReport",
        columns = { @ColumnResult(name = "newValue"),
                    @ColumnResult(name = "oldValue"),
                    @ColumnResult(name = "productName"),
                    @ColumnResult(name = "cmopId"),
                    @ColumnResult(name = "newName"),
                    @ColumnResult(name = "oldName")
        }),
        
        @SqlResultSetMapping(name = "ClassChangeReport",
        columns = { @ColumnResult(name = "newValue"),
                    @ColumnResult(name = "oldValue"),
                    @ColumnResult(name = "productName"),
                    @ColumnResult(name = "cmopId"),
                    @ColumnResult(name = "newClass"),
                    @ColumnResult(name = "oldClass")
        }),
        
        @SqlResultSetMapping(name = "newClassReport",
        columns = { @ColumnResult(name = "newValue"),
                    @ColumnResult(name = "productName"),
                    @ColumnResult(name = "cmopId"),
                    @ColumnResult(name = "classification"),
        }),
        
        @SqlResultSetMapping(name = "FutureInactivationReport",
        columns = { @ColumnResult(name = "eplId"),
                    @ColumnResult(name = "productName"),
                    @ColumnResult(name = "cmopId"),
                    @ColumnResult(name = "futureDate")
        }),
        
        @SqlResultSetMapping(name = "AddedDDIReport",
        columns = { @ColumnResult(name = "ddiName"),
                    @ColumnResult(name = "severityName"),
                    @ColumnResult(name = "vistaIen")                    
        }),
        
        @SqlResultSetMapping(name = "FutureInactiveRematchReport",
        columns = { @ColumnResult(name = "eplId"),
                    @ColumnResult(name = "vistaIen"),
                    @ColumnResult(name = "productName"),
                    @ColumnResult(name = "cmopId"),
                    @ColumnResult(name = "futureDate"),
                    @ColumnResult(name = "newIen"),
                    @ColumnResult(name = "newProductName"),
                    @ColumnResult(name = "newCmopId")
        }),
        
        @SqlResultSetMapping(name = "inactiveRematchReport",
        columns = { @ColumnResult(name = "vistaIen"),
                    @ColumnResult(name = "inactiveDate"),
                    @ColumnResult(name = "oldValue"),
                    @ColumnResult(name = "productName"),
                    @ColumnResult(name = "cmopId"),
                    @ColumnResult(name = "newIen"),                    
                    @ColumnResult(name = "newProductName"),
                    @ColumnResult(name = "newCmopId")
        }),
        
        @SqlResultSetMapping(name = "ScheduleAllChangeReport",
        columns = { @ColumnResult(name = "newValue"),
                    @ColumnResult(name = "oldValue"),
                    @ColumnResult(name = "productName"),
                    @ColumnResult(name = "cmopId"),
                    @ColumnResult(name = "newSchedule"),
                    @ColumnResult(name = "oldSchedule")
        })

    })

    @NamedNativeQueries({
        @NamedNativeQuery(name = "addedProductsReport",
            query = "SELECT odiff.new_value as newValue, p.va_product_name as productName, p.cmop_id as cmopId, du.dispense_unit_name as dispenseUnitName, ndc.ndc_number as ndcNumber " +
                    "FROM Epl_Ndf_Outgoing_Differences odiff, Epl_Products p, Epl_Va_Dispense_Units du, Epl_Ndcs ndc " +
                    "WHERE odiff.ndc_Update_File_Fk IS NULL " +
                        "AND odiff.vista_File_Number = :vistaFileNumber " +
                        "AND odiff.vista_Field_Number = :vistaFieldNumber " +
                        "AND odiff.action_Type = 'A'  " +
                        "AND odiff.created_Dtm BETWEEN " + 
                            "(SELECT MAX(updt.created_Dtm) FROM EPL_NDF_UPDATE_FILE updt WHERE updt.status_id_fk = 8) " +
                                "AND :startDate " +
                        "AND odiff.vista_Ien = p.ndf_Product_Ien " +
                        "AND p.Dispense_Unit_Id_fk = du.epl_Id(+)  " +
                        "AND ndc.epl_Id_Product_fk(+) = p.epl_Id " +
                    "ORDER BY productName, cmopId, dispenseUnitName ",
            resultSetMapping="addedProductsReport"),

    @NamedNativeQuery(
            name = "newClassReport",
            query = "SELECT odiff.new_value as newValue, p.va_product_name as productName, p.cmop_id as cmopId, " +
                        "(SELECT classification_name from epl_va_drug_classes where ndf_class_ien = odiff.vista_ien) AS classification " +
                    "FROM Epl_Ndf_Outgoing_Differences odiff, Epl_Products p " +
                    "WHERE odiff.ndc_Update_File_Fk IS NULL " +
                        "AND odiff.vista_File_Number = :vistaFileNumber " +
                        "AND odiff.vista_Field_Number = :vistaFieldNumber " +
                        "AND odiff.action_Type = 'A'  " +
                        "AND odiff.created_Dtm BETWEEN " + 
                            "(SELECT MAX(updt.created_Dtm) FROM EPL_NDF_UPDATE_FILE updt WHERE updt.status_id_fk = 8) " +
                                "AND :startDate " +
                        "AND odiff.vista_Ien = p.ndf_Product_Ien " +
                    "ORDER BY productName, cmopId ",
            resultSetMapping = "newClassReport"),

    @NamedNativeQuery(
        name = "drugUnitsChangeReport",
        query = "SELECT odiff.new_Value as newValue, odiff.old_Value as oldValue, p.va_product_name as productName, p.cmop_id as cmopId, " +            
                    "(SELECT name from Epl_Drug_Units where ndf_drugunit_ien = to_number(trim(odiff.new_Value))) as newName, " +
                    "(SELECT name from Epl_Drug_Units where ndf_drugunit_ien = to_number(trim(odiff.old_Value))) as oldName " +
                "FROM Epl_Ndf_Outgoing_Differences odiff, Epl_Products p, Epl_Drug_Units du " +
                "WHERE odiff.ndc_Update_File_Fk IS NULL " +
                    "AND odiff.vista_File_Number = :vistaFileNumber " +
                    "AND odiff.vista_Field_Number = :vistaFieldNumber " +
                    "AND odiff.action_Type = 'M'  " +
                    "AND odiff.created_Dtm BETWEEN " + 
                        "(SELECT MAX(updt.created_Dtm) FROM EPL_NDF_UPDATE_FILE updt WHERE updt.status_id_fk = 8) " +
                            "AND :startDate " +
                    "AND odiff.old_Value <> odiff.new_Value " +
                    "AND odiff.vista_Ien = p.ndf_Product_Ien " +
                    "AND p.drug_unit_id_fk = du.epl_id(+)  " +
               "ORDER BY productName, cmopId ",
               resultSetMapping = "UnitsChangeReport"),
           
    @NamedNativeQuery(
        name = "dispenseUnitsChangeReport",
        query = "SELECT odiff.new_Value as newValue, odiff.old_Value as oldValue, p.va_product_name as productName, p.cmop_id as cmopId, " +            
                    "(SELECT dispense_unit_name from Epl_Va_Dispense_Units where ndf_dispenseunit_ien = to_number(trim(odiff.new_Value))) as newName, " +
                    "(SELECT dispense_unit_name from Epl_Va_Dispense_Units where ndf_dispenseunit_ien = to_number(trim(odiff.old_Value))) as oldName " +
                "FROM Epl_Ndf_Outgoing_Differences odiff, Epl_Products p, Epl_Va_Dispense_Units du " +
                "WHERE odiff.ndc_Update_File_Fk IS NULL " +
                    "AND odiff.vista_File_Number = :vistaFileNumber " +
                    "AND odiff.vista_Field_Number = :vistaFieldNumber " +
                    "AND odiff.action_Type = 'M'  " +
                    "AND odiff.created_Dtm BETWEEN " + 
                        "(SELECT MAX(updt.created_Dtm) FROM EPL_NDF_UPDATE_FILE updt WHERE updt.status_id_fk = 8) " +
                            "AND :startDate " +
                    "AND odiff.old_Value <> odiff.new_Value " +
                    "AND odiff.vista_Ien = p.ndf_Product_Ien " +
                    "AND p.dispense_unit_id_fk = du.epl_id(+)  " +
                "ORDER BY productName, cmopId ",
        resultSetMapping = "UnitsChangeReport"),
        
    @NamedNativeQuery(
        name = "classChangeReport",
        query = "SELECT odiff.new_Value as newValue, odiff.old_Value as oldValue, p.va_product_name as productName, p.cmop_id as cmopId, " +            
                    "(SELECT code from epl_va_drug_classes where ndf_class_ien = to_number(trim(odiff.new_Value))) as newClass, " +            
                    "(SELECT code from epl_va_drug_classes where ndf_class_ien = to_number(trim(odiff.old_Value))) as oldClass " +            
                "FROM Epl_Ndf_Outgoing_Differences odiff, Epl_Products p " +
                "WHERE odiff.ndc_Update_File_Fk IS NULL " +
                    "AND odiff.vista_File_Number = :vistaFileNumber " +
                    "AND odiff.vista_Field_Number = :vistaFieldNumber " +
                    "AND odiff.action_Type = 'M'  " +
                    "AND odiff.created_Dtm BETWEEN " + 
                        "(SELECT MAX(updt.created_Dtm) FROM EPL_NDF_UPDATE_FILE updt WHERE updt.status_id_fk = 8) " +
                            "AND :startDate " +
                    "AND odiff.old_Value <> odiff.new_Value " +
                    "AND odiff.vista_Ien = p.ndf_Product_Ien " +                    
               "ORDER BY productName, cmopId ",
        resultSetMapping = "ClassChangeReport"),        
       
    @NamedNativeQuery(
        name = "futureInactivationReport",
        query = "SELECT p.epl_id as eplId, p.va_product_name as productName, p.cmop_id as cmopId, non_list.va_df_value as futureDate " +                    
                "FROM epl_products p, epl_vadf_owners owner, epl_vadf_nonlist_values non_list " +
                "WHERE owner.epl_id_product_fk = p.epl_id  " +
                    "AND p.item_status = 'ACTIVE' " +
                    "AND owner.id = non_list.vadf_owner_id_fk " +
                    "AND vadf_id_fk = '60'  " +
                    "AND p.ndf_Product_Ien NOT IN (SELECT OLD_IEN FROM epl_rematch_suggestion rematch " +
                                                  "WHERE NDC_UPDATE_FILE_FK is NULL " +
                                                      "AND NEW_IEN IS NOT NULL " +
                                                      "AND MATCH_TYPE_ID_FK = 2 ) ",                    
        resultSetMapping = "FutureInactivationReport"),
        
    @NamedNativeQuery(
        name = "addedDDIReport",
        query = "SELECT odiff.new_Value as ddiName, s.name as severityName, odiff.vista_ien as vistaIen FROM epl_ndf_outgoing_differences odiff, epl_ddi_severity s " +
                "WHERE odiff.ndc_Update_File_Fk IS NULL " +                
                "AND odiff.vista_File_Number = :vistaFileNumber " +
                "AND odiff.vista_Field_Number = :vistaFieldNumber " +
                "AND odiff.action_Type = 'A'  " +
                "AND odiff.created_Dtm BETWEEN " + 
                    "(SELECT MAX(updt.created_Dtm) FROM EPL_NDF_UPDATE_FILE updt WHERE updt.status_id_fk = 8) " +
                        "AND :startDate " +
                "AND s.epl_id = to_number((SELECT odiff2.new_Value FROM Epl_Ndf_Outgoing_Differences odiff2 " + 
                                            "WHERE odiff2.vista_Field_Number = '3' " + 
                                            "AND odiff2.vista_Ien = odiff.vista_Ien " +
                                            "AND odiff2.action_Type = 'A')) ",
        resultSetMapping = "AddedDDIReport"),
        
    @NamedNativeQuery(
        name = "futureInactiveRematchReport",
        query = "SELECT p.epl_id as eplId, p.ndf_Product_Ien as vistaIen, p.va_product_name as productName, p.cmop_id as cmopId, non_list.va_df_value as futureDate, rematch.new_ien as newIen, " +
        		"(SELECT p.va_product_name FROM epl_products p where p.ndf_Product_Ien = rematch.new_ien) as newProductName, " +
        		"(SELECT p.cmop_id FROM epl_products p where p.ndf_Product_Ien = rematch.new_ien) as newCmopId " +
                "FROM epl_products p, epl_vadf_owners owner, epl_vadf_nonlist_values non_list, epl_rematch_suggestion rematch " +
                "WHERE owner.epl_id_product_fk = p.epl_id  " +
                    "AND p.item_status = 'ACTIVE' " +
                    "AND owner.id = non_list.vadf_owner_id_fk " +
                    "AND vadf_id_fk = '60'  " +
                    "AND p.ndf_Product_Ien = rematch.old_ien " +
                    "AND rematch.ndc_update_file_fk is NULL " +
                    "AND rematch.new_ien IS NOT NULL " +
                    "AND rematch.match_type_id_fk = 2 " ,
        resultSetMapping = "FutureInactiveRematchReport"),
             
    @NamedNativeQuery(
        name = "scheduleAllChangeReport",
        query = "SELECT odiff.new_Value as newValue, odiff.old_Value as oldValue, p.va_product_name as productName, p.cmop_id as cmopId,  " +  
                    "(SELECT schedule_name from epl_cs_fed_schedules where epl_id = (select epl_id from epl_cs_fed_schedules where schedule_name like odiff.new_Value||' -%' )) as newSchedule, " +
                    "(SELECT schedule_name from epl_cs_fed_schedules where epl_id = (select epl_id from epl_cs_fed_schedules where schedule_name like odiff.old_Value||' -%' )) as oldSchedule " +
                "FROM Epl_Ndf_Outgoing_Differences odiff, Epl_Products p " +
                "WHERE odiff.ndc_Update_File_Fk IS NULL  " +
                    "AND odiff.vista_File_Number = :vistaFileNumber " +
                    "AND odiff.vista_Field_Number = :vistaFieldNumber " +
                    "AND odiff.action_Type = 'M'  " +
                    "AND odiff.created_Dtm BETWEEN " + 
                        "(SELECT MAX(updt.created_Dtm) FROM EPL_NDF_UPDATE_FILE updt WHERE updt.status_id_fk = 8) " +
                            "AND :startDate " +
                    "AND odiff.old_Value <> odiff.new_Value " +
                    "AND odiff.vista_Ien = p.ndf_Product_Ien  " +
               "ORDER BY productName, cmopId ",
        resultSetMapping = "ScheduleAllChangeReport"),
        
    @NamedNativeQuery(
        name = "genericNameAllChangeReport",
        query = "SELECT odiff.new_Value as newValue, odiff.old_Value as oldValue, p.va_product_name as productName, p.cmop_id as cmopId, " +            
                    "(SELECT generic_name from epl_va_gen_names where ndf_generic_ien = to_number(trim(odiff.new_Value))) as newName, " +
                    "(SELECT generic_name from epl_va_gen_names where ndf_generic_ien = to_number(trim(odiff.old_Value))) as oldName " +
                "FROM Epl_Ndf_Outgoing_Differences odiff, Epl_Products p " +
                "WHERE odiff.ndc_Update_File_Fk IS NULL " +
                    "AND odiff.vista_File_Number = :vistaFileNumber " +
                    "AND odiff.vista_Field_Number = :vistaFieldNumber " +
                    "AND odiff.action_Type = 'M'  " +
                    "AND odiff.created_Dtm BETWEEN " + 
                        "(SELECT MAX(updt.created_Dtm) FROM EPL_NDF_UPDATE_FILE updt WHERE updt.status_id_fk = 8) " +
                            "AND :startDate " +
                    "AND odiff.old_Value <> odiff.new_Value " +
                    "AND odiff.vista_Ien = p.ndf_Product_Ien " +
               "ORDER BY productName, cmopId ",
        resultSetMapping = "UnitsChangeReport"),
    
    @NamedNativeQuery(
        name = "dosageFormChangeReport",
        query = "SELECT odiff.new_Value as newValue, odiff.old_Value as oldValue, p.va_product_name as productName, p.cmop_id as cmopId, " +           
                    "(SELECT df_name from epl_dosage_forms where dosageform_ien = to_number(trim(odiff.new_Value))) as newName, " +            
                    "(SELECT df_name from epl_dosage_forms where dosageform_ien = to_number(trim(odiff.old_Value))) as oldName " +
                "FROM Epl_Ndf_Outgoing_Differences odiff, Epl_Products p " +
                "WHERE odiff.ndc_Update_File_Fk IS NULL " +
                    "AND odiff.vista_File_Number = :vistaFileNumber " +
                    "AND odiff.vista_Field_Number = :vistaFieldNumber " +
                    "AND odiff.action_Type = 'M'  " +
                    "AND odiff.created_Dtm BETWEEN " + 
                        "(SELECT MAX(updt.created_Dtm) FROM EPL_NDF_UPDATE_FILE updt WHERE updt.status_id_fk = 8) " +
                            "AND :startDate " +
                    "AND odiff.old_Value <> odiff.new_Value " +
                    "AND odiff.vista_Ien = p.ndf_Product_Ien " +
               "ORDER BY productName, cmopId ",
        resultSetMapping = "UnitsChangeReport"),
        
    @NamedNativeQuery(
        name = "inactiveRematchReport",
        query = "SELECT odiff.vista_ien as vistaIen, odiff.new_Value as inactiveDate, odiff.old_Value as oldValue, p.va_Product_Name as productName, p.cmop_Id as cmopId, rematch.new_ien as newIen, " +
                    "(SELECT p.va_product_name FROM epl_products p where p.ndf_Product_Ien = rematch.new_ien) as newProductName, " +
                    "(SELECT p.cmop_id FROM epl_products p where p.ndf_Product_Ien = rematch.new_ien) as newCmopId " +
                "FROM Epl_Ndf_Outgoing_Differences odiff, Epl_Products p, epl_rematch_suggestion rematch " +
                "WHERE odiff.ndc_Update_File_Fk IS NULL " +
                    "AND odiff.vista_File_Number = :vistaFileNumber " +
                    "AND odiff.vista_Field_Number = :vistaFieldNumber " +
                    "AND odiff.action_Type = 'M'  " +
                    "AND odiff.created_Dtm BETWEEN " +
                        "(SELECT MAX(updt.created_Dtm) FROM EPL_NDF_UPDATE_FILE updt WHERE updt.status_id_fk = 8) " +
                            "AND :startDate " +
                    "AND odiff.new_Value <> ' ' " +
                    "AND odiff.old_Value IS NULL " +
                    "AND odiff.vista_Ien = p.ndf_Product_Ien " +
                    "AND rematch.old_ien = odiff.vista_Ien " +
                    "AND rematch.NDC_UPDATE_FILE_FK is NULL " +
                    "AND rematch.NEW_IEN IS NOT NULL " +
                    "AND rematch.MATCH_TYPE_ID_FK = 1 " +
                    "AND rematch.MATCH_SCOPE = 'Y' " +
                    "AND rematch.created_Dtm BETWEEN " +
                        "(SELECT MAX(updt.created_Dtm) FROM EPL_NDF_UPDATE_FILE updt WHERE updt.status_id_fk = 8) " +
                            "AND :startDate " ,               
        resultSetMapping = "inactiveRematchReport"),
        
   @NamedNativeQuery(
       name = "inactiveRematchReportSugg",
       query = "SELECT odiff.vista_ien as vistaIen, odiff.new_Value as inactiveDate, odiff.old_Value as oldValue, p.va_Product_Name as productName, p.cmop_Id as cmopId, rematch.new_ien as newIen, " +
                   "(SELECT p.va_product_name FROM epl_products p where p.ndf_Product_Ien = rematch.new_ien) as newProductName, " +
                   "(SELECT p.cmop_id FROM epl_products p where p.ndf_Product_Ien = rematch.new_ien) as newCmopId " +
               "FROM Epl_Ndf_Outgoing_Differences odiff, Epl_Products p, epl_rematch_suggestion rematch " +
               "WHERE odiff.ndc_Update_File_Fk IS NULL " +
                   "AND odiff.vista_File_Number = :vistaFileNumber " +
                   "AND odiff.vista_Field_Number = :vistaFieldNumber " +
                   "AND odiff.action_Type = 'M'  " +
                   "AND odiff.created_Dtm BETWEEN " +
                       "(SELECT MAX(updt.created_Dtm) FROM EPL_NDF_UPDATE_FILE updt WHERE updt.status_id_fk = 8) " +
                           "AND :startDate " +
                   "AND odiff.new_Value <> ' ' " +
                   "AND odiff.old_Value IS NULL " +
                   "AND odiff.vista_Ien = p.ndf_Product_Ien " +
                   "AND rematch.old_ien = odiff.vista_Ien " +
                   "AND rematch.NDC_UPDATE_FILE_FK is NULL " +
                   "AND rematch.NEW_IEN IS NOT NULL " +
                   "AND rematch.MATCH_TYPE_ID_FK = 1 " +
                   "AND rematch.MATCH_SCOPE = 'N' " +
                   "AND rematch.created_Dtm BETWEEN " +
                       "(SELECT MAX(updt.created_Dtm) FROM EPL_NDF_UPDATE_FILE updt WHERE updt.status_id_fk = 8) " +
                           "AND :startDate " ,               
       resultSetMapping = "inactiveRematchReport")
        
    } )
@Table(name = "EPL_NDF_OUTGOING_DIFFERENCES"
    , schema = "PPSNEPL")
public class EplNdfOutgoingDifferences implements java.io.Serializable {

    private static final long serialVersionUID = -8735230445609556555L;
    private Long id;
    private String newValue;
    private String oldValue;
    private String vistaFileNumber;
    private String vistaFieldNumber;
    private String vistaIen;    
    private EplNdfUpdateFileDo  ndcUpdateFileFk;
    private String actionType;
    private String createdBy;
    private Date createdDtm;

    public EplNdfOutgoingDifferences() {
    }

    public EplNdfOutgoingDifferences(Long id, String newValue, String oldValue, String vistaFileNumber, String vistaFieldNumber,
        String vistaIen, String actionType, String createdBy, Date createdDtm) {
        this.id = id;
        this.newValue = newValue;
        this.oldValue = oldValue;
        this.vistaFileNumber = vistaFileNumber;
        this.vistaFieldNumber = vistaFieldNumber;
        this.vistaIen = vistaIen;
        this.actionType = actionType;
        this.createdBy = createdBy;
        this.createdDtm = createdDtm;        
    }

    public EplNdfOutgoingDifferences(Long id, String newValue, String oldValue, String vistaFileNumber, String vistaFieldNumber,
        String vistaIen, EplNdfUpdateFileDo  ndcUpdateFileFk, String actionType, String createdBy, Date createdDtm) {
        this.id = id;
        this.newValue = newValue;
        this.oldValue = oldValue;
        this.vistaFileNumber = vistaFileNumber;
        this.vistaFieldNumber = vistaFieldNumber;
        this.vistaIen = vistaIen;
        this.ndcUpdateFileFk = ndcUpdateFileFk;
        this.actionType = actionType;
        this.createdBy = createdBy;
        this.createdDtm = createdDtm;        
    }

    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "ndfOutgoingDifferencesSeqGen")
    @SequenceGenerator(name = "ndfOutgoingDifferencesSeqGen", sequenceName="EPL_NDF_OUTGOING_DIFFERENS_SEQ")
    @Column(name = "NDF_OUTGOING_DIFFERENCES_ID", unique = true, nullable = false, precision = 38, scale = 0)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "NEW_VALUE", nullable = false, length = 4000)
    public String getNewValue() {
        return this.newValue;
    }

    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }
    
    @Column(name = "OLD_VALUE", nullable = false, length = 4000)
    public String getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(String oldValue) {
        this.oldValue = oldValue;
    }

    @Column(name = "VISTA_FILE_NUMBER", nullable = false, length = 20)
    public String getVistaFileNumber() {
        return this.vistaFileNumber;
    }

    public void setVistaFileNumber(String vistaFileNumber) {
        this.vistaFileNumber = vistaFileNumber;
    }

    @Column(name = "VISTA_FIELD_NUMBER", nullable = false, length = 10)
    public String getVistaFieldNumber() {
        return this.vistaFieldNumber;
    }

    public void setVistaFieldNumber(String vistaFieldNumber) {
        this.vistaFieldNumber = vistaFieldNumber;
    }

    @Column(name = "VISTA_IEN", nullable = false, length = 50)
    public String getVistaIen() {
        return this.vistaIen;
    }

    public void setVistaIen(String vistaIen) {
        this.vistaIen = vistaIen;
    }

    @OneToOne
    @JoinColumn(name = "NDC_UPDATE_FILE_FK")
    public EplNdfUpdateFileDo getNdcUpdateFileFk() {
        return this.ndcUpdateFileFk;
    }

    public void setNdcUpdateFileFk(EplNdfUpdateFileDo  ndcUpdateFileFk) {
        this.ndcUpdateFileFk = ndcUpdateFileFk;
    }

    @Column(name = "ACTION_TYPE", nullable = true, length = 10)
    public String getActionType() {
        return this.actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    @Column(name = "CREATED_BY", nullable = false, length = 50)
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @Column(name = "CREATED_DTM", nullable = false)
    public Date getCreatedDtm() {
        return this.createdDtm;
    }

    public void setCreatedDtm(Date createdDtm) {
        this.createdDtm = createdDtm;
    }
}
