/**
 * Source file created in 2008 by Southwest Research Institute
 */


package gov.va.med.pharmacy.peps.domain.common.model;


import java.util.Date;


/**
 * EplLocalPossibleDosageDo generated by hbm2java
 * 
 * @hibernate.class
 */
public class EplNationalPossibleDosageDo extends gov.va.med.pharmacy.peps.domain.common.model.DataObject implements
    java.io.Serializable {
    
    
    public static final String DISPENSE_UNITS_PER_DOSE = "dispenseUnitsPerDose";
    public static final String DOSE = "dose";
    public static final String BCMA_UNITS_PER_DOSE = "bcmaUnitsPerDose";
    public static final String PACKAGE_NAME = "packageName";
    private static final long serialVersionUID = 1L;

    // Fields

    private Long id;
    private Double bcmaUnitsPerDose;
    private Double dispenseUnitsPerDose;
    private Double dose;
    private String packageName;
    private EplProductDo eplProduct;

    // Constructors

    /** default constructor */
    
    public EplNationalPossibleDosageDo() {
    }

    /** minimal constructor */
    
    public EplNationalPossibleDosageDo(Long id, Double dispenseUnitsPerDose, Double dose, String packageName,
                                       String createdBy, Date createdDtm) {
        this.id = id;
        this.dispenseUnitsPerDose = dispenseUnitsPerDose;
        this.dose = dose;
        this.packageName = packageName;
        this.setCreatedBy(createdBy);
        this.setCreatedDtm(createdDtm);
    }

    /** full constructor */
    
    public EplNationalPossibleDosageDo(Long id, Double bcmaUnitsPerDose, Double dispenseUnitsPerDose, Double dose,
                                       String packageName, String createdBy, Date createdDtm, String lastModifiedBy,
                                       Date lastModifiedDtm, EplProductDo eplProduct) {
        this.id = id;
        this.bcmaUnitsPerDose = bcmaUnitsPerDose;
        this.dispenseUnitsPerDose = dispenseUnitsPerDose;
        this.dose = dose;
        this.packageName = packageName;
        this.setCreatedBy(createdBy);
        this.setCreatedDtm(createdDtm);
        this.setLastModifiedBy(lastModifiedBy);
        this.setLastModifiedDtm(lastModifiedDtm);
        this.eplProduct = eplProduct;
    }

    // Property accessors
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Double getBcmaUnitsPerDose() {
        return this.bcmaUnitsPerDose;
    }

    public void setBcmaUnitsPerDose(Double bcmaUnitsPerDose) {
        this.bcmaUnitsPerDose = bcmaUnitsPerDose;
    }

    public Double getDispenseUnitsPerDose() {
        return this.dispenseUnitsPerDose;
    }

    public void setDispenseUnitsPerDose(Double dispenseUnitsPerDose) {
        this.dispenseUnitsPerDose = dispenseUnitsPerDose;
    }

    public Double getDose() {
        return this.dose;
    }

    public void setDose(Double dose) {
        this.dose = dose;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public EplProductDo getEplProduct() {
        return this.eplProduct;
    }

    public void setEplProduct(EplProductDo eplProduct) {
        this.eplProduct = eplProduct;
    }

    /**
     * toString
     * 
     * @return String
     */
    public String toString() {
        StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");
        buffer.append("bcmaUnitsPerDose").append("='").append(getBcmaUnitsPerDose()).append("' ");
        buffer.append("dispenseUnitsPerDose").append("='").append(getDispenseUnitsPerDose()).append("' ");
        buffer.append("dose").append("='").append(getDose()).append("' ");
        buffer.append("packageName").append("='").append(getPackageName()).append("' ");
        buffer.append("createdBy").append("='").append(getCreatedBy()).append("' ");
        buffer.append("createdDtm").append("='").append(getCreatedDtm()).append("' ");
        buffer.append("lastModifiedBy").append("='").append(getLastModifiedBy()).append("' ");
        buffer.append("lastModifiedDtm").append("='").append(getLastModifiedDtm()).append("' ");
        buffer.append("]");

        return buffer.toString();
    }

    public boolean equals(Object other) {
        if ((this == other)) {
            return true;
        }
        
        if ((other == null)) {
            return false;
        }
        
        if (!(other instanceof EplNationalPossibleDosageDo)) {
            return false;
        }
        
        EplNationalPossibleDosageDo castOther = (EplNationalPossibleDosageDo) other;

        return ((this.getId() == castOther.getId()) || (this.getId() != null && castOther.getId() != null && this.getId()
            .equals(castOther.getId())))
            && ((this.getBcmaUnitsPerDose() == castOther.getBcmaUnitsPerDose()) || (this.getBcmaUnitsPerDose() != null
                && castOther.getBcmaUnitsPerDose() != null && this.getBcmaUnitsPerDose().equals(
                    castOther.getBcmaUnitsPerDose())))
            && ((this.getDispenseUnitsPerDose() == castOther.getDispenseUnitsPerDose()) || (this.getDispenseUnitsPerDose() != null
                && castOther.getDispenseUnitsPerDose() != null && this.getDispenseUnitsPerDose().equals(
                    castOther.getDispenseUnitsPerDose())))
            && ((this.getDose() == castOther.getDose()) || (this.getDose() != null && castOther.getDose() != null && this
                .getDose().equals(castOther.getDose())))
            && ((this.getPackageName() == castOther.getPackageName()) || (this.getPackageName() != null
                && castOther.getPackageName() != null && this.getPackageName().equals(castOther.getPackageName())))
            && ((this.getCreatedBy() == castOther.getCreatedBy()) || (this.getCreatedBy() != null
                && castOther.getCreatedBy() != null && this.getCreatedBy().equals(castOther.getCreatedBy())))
            && ((this.getCreatedDtm() == castOther.getCreatedDtm()) || (this.getCreatedDtm() != null
                && castOther.getCreatedDtm() != null && this.getCreatedDtm().equals(castOther.getCreatedDtm())))
            && ((this.getLastModifiedBy() == castOther.getLastModifiedBy()) || (this.getLastModifiedBy() != null
                && castOther.getLastModifiedBy() != null && this.getLastModifiedBy().equals(castOther.getLastModifiedBy())))
            && ((this.getLastModifiedDtm() == castOther.getLastModifiedDtm()) || (this.getLastModifiedDtm() != null
                && castOther.getLastModifiedDtm() != null && this.getLastModifiedDtm()
                .equals(castOther.getLastModifiedDtm())))
            && ((this.getEplProduct() == castOther.getEplProduct()) || (this.getEplProduct() != null
                && castOther.getEplProduct() != null && this.getEplProduct().equals(castOther.getEplProduct())));
    }

    public int hashCode() {
        int result = 17;

        result = 37 * result + (getId() == null ? 0 : this.getId().hashCode());
        result = 37 * result + (getBcmaUnitsPerDose() == null ? 0 : this.getBcmaUnitsPerDose().hashCode());
        result = 37 * result + (getDispenseUnitsPerDose() == null ? 0 : this.getDispenseUnitsPerDose().hashCode());
        result = 37 * result + (getDose() == null ? 0 : this.getDose().hashCode());
        result = 37 * result + (getPackageName() == null ? 0 : this.getPackageName().hashCode());
        result = 37 * result + (getCreatedBy() == null ? 0 : this.getCreatedBy().hashCode());
        result = 37 * result + (getCreatedDtm() == null ? 0 : this.getCreatedDtm().hashCode());
        result = 37 * result + (getLastModifiedBy() == null ? 0 : this.getLastModifiedBy().hashCode());
        result = 37 * result + (getLastModifiedDtm() == null ? 0 : this.getLastModifiedDtm().hashCode());
        result = 37 * result + (getEplProduct() == null ? 0 : this.getEplProduct().hashCode());
        
        return result;
    }

}
