package gov.va.med.pharmacy.peps.domain.common.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;



@Table(name = "EPL_MATCH_TYPE"
, schema = "PPSNEPL")

@Entity
public class EplMatchTypeDo extends AnnotatedDataObject implements Serializable {

   
    private static final long serialVersionUID = 2888544183470449811L;  
    
    private Long matchTypeId;
    private String matchName;
    private String matchDesc;
   
   
   
    public EplMatchTypeDo() {
    }

    public EplMatchTypeDo (Long matchTypeId, String matchName, String matchDesc) {
        this.matchTypeId = matchTypeId;
        this.setMatchName(matchName);
        this.setMatchDesc(matchDesc);       
    }   
    
    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "matchTypeSeqGen")
    @SequenceGenerator(name = "matchTypeSeqGen", sequenceName="EPL_MATCH_TYPE_SEQ")
    @Column(name="MATCH_TYPE_ID", unique = true, nullable = false, precision = 38, scale = 0)
    public Long getMatchTypeId() {
        return matchTypeId;
    }
    
  
    public void setMatchTypeId(Long matchTypeId) {
        this.matchTypeId = matchTypeId;
    }
    
    
    @Column(name="MATCH_NAME", nullable=false)
    public String getMatchName() {
        return matchName;
    }
    
    
    public void setMatchName(String matchName) {
        this.matchName = matchName;
    }
    
    @Column(name="MATCH_DESC", nullable=true)
    public String getMatchDesc() {
        return matchDesc;
    }
    
    
    public void setMatchDesc(String matchDesc) {
        this.matchDesc = matchDesc;
    }

  
}
