/**
 * Source file created in 2008 by Southwest Research Institute
 */


package gov.va.med.pharmacy.peps.domain.common.model;


import java.util.Date;
import java.util.HashSet;
import java.util.Set;


/**
 * EplManufacturerDo generated by hbm2java
 * @hibernate.class
 */
public class EplManufacturerDo extends gov.va.med.pharmacy.peps.domain.common.model.DataObject implements
    java.io.Serializable {
    
    public static final String NAME = "name";
    public static final String NDF_MANUFACTURER_IEN = "ndfManufacturerIen";
    public static final String ITEM_STATUS = "itemStatus";
    public static final String REQUEST_STATUS = "requestStatus";
    public static final String INACTIVATION_DATE = "inactivationDate";
    public static final String EPL_ID = "eplId";
    
    private static final long serialVersionUID = 1L;

    // Fields

    private Long eplId;
    private Long ndfManufacturerIen;
    private String name;
    private String phone;
    private String address;
    private String requestStatus;
    private String itemStatus;
    private String rejectReasonText;
    private String requestRejectReason;
    private Long revisionNumber;
    private Date inactivationDate;
    private Set<EplNdcDo> eplNdcs = new HashSet<EplNdcDo>(0);

    // Constructors

    /** default constructor */
    
    public EplManufacturerDo() {
    }

    /** minimal constructor */
    
    public EplManufacturerDo(Long eplId, Long ndfManufacturerIen, String name, String createdBy, Date createdDtm) {
        this.eplId = eplId;
        this.ndfManufacturerIen = ndfManufacturerIen;
        this.name = name;
        this.setCreatedBy(createdBy);
        this.setCreatedDtm(createdDtm);
    }

    /** full constructor */
    
    public EplManufacturerDo(Long eplId, Long ndfManufacturerIen, String name, String phone, String address,
                             Date inactivationDate, String createdBy, Date createdDtm, String lastModifiedBy,
                             Date lastModifiedDtm, Set<EplNdcDo> eplNdcs) {
        this.eplId = eplId;
        this.ndfManufacturerIen = ndfManufacturerIen;
        this.name = name;
        this.phone = phone;
        this.address = address;
        this.inactivationDate = inactivationDate;
        this.setCreatedBy(createdBy);
        this.setCreatedDtm(createdDtm);
        this.setLastModifiedBy(lastModifiedBy);
        this.setLastModifiedDtm(lastModifiedDtm);
        this.eplNdcs = eplNdcs;
    }

    // Property accessors
    public Long getEplId() {
        return this.eplId;
    }

    public void setEplId(Long eplId) {
        this.eplId = eplId;
    }

    public Long getNdfManufacturerIen() {
        return this.ndfManufacturerIen;
    }

    public void setNdfManufacturerIen(Long ndfManufacturerIen) {
        this.ndfManufacturerIen = ndfManufacturerIen;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Date getInactivationDate() {
        return this.inactivationDate;
    }

    public void setInactivationDate(Date inactivationDate) {
        this.inactivationDate = inactivationDate;
    }

    public Set<EplNdcDo> getEplNdcs() {
        return this.eplNdcs;
    }

    public void setEplNdcs(Set<EplNdcDo> eplNdcs) {
        this.eplNdcs = eplNdcs;
    }

    /**
     * toString
     * 
     * @return String
     */
    public String toString() {
        StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");
        buffer.append("ndfManufacturerIen").append("='").append(getNdfManufacturerIen()).append("' ");
        buffer.append("name").append("='").append(getName()).append("' ");
        buffer.append("phone").append("='").append(getPhone()).append("' ");
        buffer.append("address").append("='").append(getAddress()).append("' ");
        buffer.append("inactivationDate").append("='").append(getInactivationDate()).append("' ");
        buffer.append("createdBy").append("='").append(getCreatedBy()).append("' ");
        buffer.append("createdDtm").append("='").append(getCreatedDtm()).append("' ");
        buffer.append("lastModifiedBy").append("='").append(getLastModifiedBy()).append("' ");
        buffer.append("lastModifiedDtm").append("='").append(getLastModifiedDtm()).append("' ");
        buffer.append("]");

        return buffer.toString();
    }

    public boolean equals(Object other) {
        if ((this == other)) {
            return true;
        }
        
        if ((other == null)) {
            return false;
        }
        
        if (!(other instanceof EplManufacturerDo)) {
            return false;
        }
        
        EplManufacturerDo castOther = (EplManufacturerDo) other;

        return ((this.getEplId() == castOther.getEplId()) || (this.getEplId() != null && castOther.getEplId() != null && this.getEplId()
            .equals(castOther.getEplId())));
    }

    public int hashCode() {
        int result = 17;

        result = 37 * result + (getEplId() == null ? 0 : this.getEplId().hashCode());

        return result;
    }

    public String getRequestStatus() {
        return requestStatus;
    }

    public void setRequestStatus(String requestStatus) {
        this.requestStatus = requestStatus;
    }

    public String getItemStatus() {
        return itemStatus;
    }

    public void setItemStatus(String itemStatus) {
        this.itemStatus = itemStatus;
    }

    public String getRejectReasonText() {
        return rejectReasonText;
    }

    public void setRejectReasonText(String rejectReasonText) {
        this.rejectReasonText = rejectReasonText;
    }

    public String getRequestRejectReason() {
        return requestRejectReason;
    }

    public void setRequestRejectReason(String requestRejectReason) {
        this.requestRejectReason = requestRejectReason;
    }

    public Long getRevisionNumber() {
        return revisionNumber;
    }

    public void setRevisionNumber(Long revisionNumber) {
        this.revisionNumber = revisionNumber;
    }

}
