/**
 * Source file created in 2008 by Southwest Research Institute
 */


package gov.va.med.pharmacy.peps.domain.common.model;


import java.util.Date;


/**
 * EplLocalPossibleDosageDo generated by hbm2java
 * 
 * @hibernate.class
 */
public class EplLocalPossibleDosageDo extends gov.va.med.pharmacy.peps.domain.common.model.DataObject implements
    java.io.Serializable {
    
    public static final String LOCAL_POSSIBLE_DOSAGE = "localPossibleDosage";
    public static final String NUMERIC_DOSE = "numericDose";
    public static final String OTHER_LANGUAGE_DOSAGE_NAME = "otherLanguageDosageName";
    public static final String BCMA_UNITS_PER_DOSE = "bcmaUnitsPerDose";
    public static final String PACKAGE_NAME = "packageName";
    public static final String DOSE_UNIT = "eplDoseUnit";
    private static final long serialVersionUID = 1L;

    // Fields

    private Long id;
    private Double bcmaUnitsPerDose;
    private String localPossibleDosage;
    private String otherLanguageDosageName;
    private String packageName;
    private EplProductDo eplProduct;
    private Double numericDose;
    private EplDoseUnitDo eplDoseUnit;

    // Constructors

    /** default constructor */
    
    public EplLocalPossibleDosageDo() {
    }

    /** minimal constructor */
    
    public EplLocalPossibleDosageDo(Long id, String localPossibleDosage, String packageName, String createdBy,
                                    Date createdDtm) {
        this.id = id;
        this.localPossibleDosage = localPossibleDosage;
        this.packageName = packageName;
        this.setCreatedBy(createdBy);
        this.setCreatedDtm(createdDtm);
    }

    /** full constructor */
    
    public EplLocalPossibleDosageDo(Long id, Double bcmaUnitsPerDose, String localPossibleDosage,
                                    String otherLanguageDosageName, String package_name, String createdBy, Date createdDtm,
                                    String lastModifiedBy, Date lastModifiedDtm, EplProductDo eplProduct, EplDoseUnitDo eplDoseUnit) {
        this.id = id;
        this.bcmaUnitsPerDose = bcmaUnitsPerDose;
        this.localPossibleDosage = localPossibleDosage;
        this.otherLanguageDosageName = otherLanguageDosageName;
        this.eplProduct = eplProduct;
        this.eplDoseUnit = eplDoseUnit;
    }

    // Property accessors
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Double getBcmaUnitsPerDose() {
        return this.bcmaUnitsPerDose;
    }

    public void setBcmaUnitsPerDose(Double bcmaUnitsPerDose) {
        this.bcmaUnitsPerDose = bcmaUnitsPerDose;
    }

    public String getLocalPossibleDosage() {
        return this.localPossibleDosage;
    }

    public void setLocalPossibleDosage(String localPossibleDosage) {
        this.localPossibleDosage = localPossibleDosage;
    }

    public String getOtherLanguageDosageName() {
        return this.otherLanguageDosageName;
    }

    public void setOtherLanguageDosageName(String otherLanguageDosageName) {
        this.otherLanguageDosageName = otherLanguageDosageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public EplProductDo getEplProduct() {
        return this.eplProduct;
    }

    public void setEplProduct(EplProductDo eplProduct) {
        this.eplProduct = eplProduct;
    }

    /**
     * toString
     * 
     * @return String
     */
    public String toString() {
        StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");
        buffer.append("bcmaUnitsPerDose").append("='").append(getBcmaUnitsPerDose()).append("' ");
        buffer.append("localPossibleDosage").append("='").append(getLocalPossibleDosage()).append("' ");
        buffer.append("otherLanguageDosageName").append("='").append(getOtherLanguageDosageName()).append("' ");
        buffer.append("package_name").append("='").append(getPackageName()).append("' ");
        buffer.append("createdBy").append("='").append(getCreatedBy()).append("' ");
        buffer.append("createdDtm").append("='").append(getCreatedDtm()).append("' ");
        buffer.append("lastModifiedBy").append("='").append(getLastModifiedBy()).append("' ");
        buffer.append("lastModifiedDtm").append("='").append(getLastModifiedDtm()).append("' ");
        buffer.append("]");

        return buffer.toString();
    }

    public boolean equals(Object other) {
        if ((this == other)) {
            return true;
        }
        
        if ((other == null)) {
            return false;
        }
        
        if (!(other instanceof EplLocalPossibleDosageDo)) {
            return false;
        }

        EplLocalPossibleDosageDo castOther = (EplLocalPossibleDosageDo) other;

        return ((this.getId() == castOther.getId()) || (this.getId() != null && castOther.getId() != null && this.getId()
            .equals(castOther.getId())))
            && ((this.getBcmaUnitsPerDose() == castOther.getBcmaUnitsPerDose()) || (this.getBcmaUnitsPerDose() != null
                && castOther.getBcmaUnitsPerDose() != null && this.getBcmaUnitsPerDose().equals(
                    castOther.getBcmaUnitsPerDose())))
            && ((this.getLocalPossibleDosage() == castOther.getLocalPossibleDosage()) || (this.getLocalPossibleDosage() != null
                && castOther.getLocalPossibleDosage() != null && this.getLocalPossibleDosage().equals(
                    castOther.getLocalPossibleDosage())))
            && ((this.getOtherLanguageDosageName() == castOther.getOtherLanguageDosageName()) || (this
                .getOtherLanguageDosageName() != null
                && castOther.getOtherLanguageDosageName() != null && this.getOtherLanguageDosageName().equals(
                    castOther.getOtherLanguageDosageName())))
            && ((this.getPackageName() == castOther.getPackageName()) || (this.getPackageName() != null
                && castOther.getPackageName() != null && this.getPackageName().equals(castOther.getPackageName())))
            && ((this.getEplDoseUnit() == castOther.getEplDoseUnit()) || (this.getEplDoseUnit() != null
                && castOther.getEplDoseUnit() != null && this.getEplDoseUnit().equals(castOther.getEplDoseUnit())))
            && ((this.getCreatedBy() == castOther.getCreatedBy()) || (this.getCreatedBy() != null
                && castOther.getCreatedBy() != null && this.getCreatedBy().equals(castOther.getCreatedBy())))
            && ((this.getCreatedDtm() == castOther.getCreatedDtm()) || (this.getCreatedDtm() != null
                && castOther.getCreatedDtm() != null && this.getCreatedDtm().equals(castOther.getCreatedDtm())))
            && ((this.getLastModifiedBy() == castOther.getLastModifiedBy()) || (this.getLastModifiedBy() != null
                && castOther.getLastModifiedBy() != null && this.getLastModifiedBy().equals(castOther.getLastModifiedBy())))
            && ((this.getLastModifiedDtm() == castOther.getLastModifiedDtm()) || (this.getLastModifiedDtm() != null
                && castOther.getLastModifiedDtm() != null && this.getLastModifiedDtm()
                .equals(castOther.getLastModifiedDtm())))
            && ((this.getEplProduct() == castOther.getEplProduct()) || (this.getEplProduct() != null
                && castOther.getEplProduct() != null && this.getEplProduct().equals(castOther.getEplProduct())));
    }

    /**
     * 
     * @return hashCode
     * 
     * @see gov.va.med.pharmacy.peps.domain.common.model.DataObject#hashCode()
     */
    public int hashCode() {
        int result = 17;

        result = 37 * result + (getId() == null ? 0 : this.getId().hashCode());
        result = 37 * result + (getBcmaUnitsPerDose() == null ? 0 : this.getBcmaUnitsPerDose().hashCode());
        result = 37 * result + (getLocalPossibleDosage() == null ? 0 : this.getLocalPossibleDosage().hashCode());
        result = 37 * result + (getOtherLanguageDosageName() == null ? 0 : this.getOtherLanguageDosageName().hashCode());
        result = 37 * result + (getPackageName() == null ? 0 : this.getPackageName().hashCode());
        result = 37 * result + (getCreatedBy() == null ? 0 : this.getCreatedBy().hashCode());
        result = 37 * result + (getCreatedDtm() == null ? 0 : this.getCreatedDtm().hashCode());
        result = 37 * result + (getEplDoseUnit() == null ? 0 : this.getEplDoseUnit().hashCode());
        result = 37 * result + (getLastModifiedBy() == null ? 0 : this.getLastModifiedBy().hashCode());
        result = 37 * result + (getLastModifiedDtm() == null ? 0 : this.getLastModifiedDtm().hashCode());
        result = 37 * result + (getEplProduct() == null ? 0 : this.getEplProduct().hashCode());
        
        return result;
    }

    /**
     * 
     * @return numericDose
     */
    public Double getNumericDose() {
        return numericDose;
    }

    /**
     * 
     * @param numericDose numericDose
     */
    public void setNumericDose(Double numericDose) {
        this.numericDose = numericDose;
    }
    
    /**
     * 
     * @return eplDoseUnit
     */
    public EplDoseUnitDo getEplDoseUnit() {
        return this.eplDoseUnit;
    }

    /**
     * 
     * @param eplDoseUnit eplDoseUnit
     */
    public void setEplDoseUnit(EplDoseUnitDo eplDoseUnit) {
        this.eplDoseUnit = eplDoseUnit;
    }

}
