/**
 * Source file created in 2008 by Southwest Research Institute
 */


package gov.va.med.pharmacy.peps.domain.common.model;


import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import gov.va.med.pharmacy.peps.common.vo.EntityType;


/**
 * EplItemAuditHistoryDo generated by hbm2java
 * 
 * @hibernate.class
 */
public class EplItemAuditHistoryDo extends gov.va.med.pharmacy.peps.domain.common.model.DataObject implements
    java.io.Serializable {

    // Fields
    public static final String AUDIT_ITEM_ID = "auditItemId";
    public static final String AUDIT_ITEM_TYPE = "auditItemType";
    public static final String NOTIFICATION = "eplNotification";
    public static final String EVENT_CATEGORY = "eventCategory";
    public static final String CREATED_DTM = "createdDtm";
    private static final long serialVersionUID = 1L;

    private Long eplId;
    private String auditItemType;
    private Long auditItemId;
    private String siteName;
    private String eventCategory;
    private String reason;
    private Set<EplItemAuditHistoryDetailDo> eplItemAuditHistoryDetails = new HashSet<EplItemAuditHistoryDetailDo>(0);
    private EplNotificationDo eplNotification;

    // Constructors

    /** default constructor */

    public EplItemAuditHistoryDo() {
    }

    /** minimal constructor */

    public EplItemAuditHistoryDo(Long eplId, String auditItemType, Long auditItemId, String siteName, String colNm,
                                 String eventCategory, String reason, String createdBy, Date createdDtm) {
        this.eplId = eplId;
        this.auditItemType = auditItemType;
        this.auditItemId = auditItemId;
        this.siteName = siteName;
        this.eventCategory = eventCategory;
        this.reason = reason;
        this.setCreatedBy(createdBy);
        this.setCreatedDtm(createdDtm);
    }

    /** full constructor */

    public EplItemAuditHistoryDo(Long eplId, String auditItemType, Long auditItemId, String siteName, String colName,
                                 String eventCategory, String reason, String oldValue, String newValue, String createdBy,
                                 Date createdDtm, String lastModifiedBy, Date lastModifiedDtm, EplVadfOwnerDo eplVadfOwner,
                                 Set<EplItemAuditHistoryDetailDo> eplItemAuditHistoryDetails,
                                 EplNotificationDo eplNotification) {
        this.eplId = eplId;
        this.auditItemType = auditItemType;
        this.auditItemId = auditItemId;
        this.siteName = siteName;
        this.eventCategory = eventCategory;
        this.reason = reason;
        this.eplItemAuditHistoryDetails = eplItemAuditHistoryDetails;
        this.eplNotification = eplNotification;
    }

    public String getAuditItemType() {
        return this.auditItemType;
    }

    public void setAuditItemType(String itemType) {
        this.auditItemType = itemType;
    }

    public Long getAuditItemId() {
        return this.auditItemId;
    }

    public void setAuditItemId(Long auditItemId) {
        this.auditItemId = auditItemId;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    public String getEventCategory() {
        return this.eventCategory;
    }

    public void setEventCategory(String eventCategory) {
        this.eventCategory = eventCategory;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    /**
     * 
     * @return eplItemAuditHistoryDetails property
     */
    public Set<EplItemAuditHistoryDetailDo> getEplItemAuditHistoryDetails() {
        return eplItemAuditHistoryDetails;
    }

    /**
     * 
     * @param eplItemAuditHistoryDetails eplItemAuditHistoryDetails property
     */
    public void setEplItemAuditHistoryDetails(Set<EplItemAuditHistoryDetailDo> eplItemAuditHistoryDetails) {
        this.eplItemAuditHistoryDetails = eplItemAuditHistoryDetails;
    }

    public EplNotificationDo getEplNotification() {
        return this.eplNotification;
    }

    public void setEplNotification(EplNotificationDo eplNotification) {
        this.eplNotification = eplNotification;
    }

    /**
     * indicates if the instance is the indicated entity type
     * 
     * @param entityType EntityType
     * @return true if is the same type
     */
    public boolean is(EntityType entityType) {
        if ((getAuditItemType() == null) || (entityType == null)) {
            return false;
        }

        return getAuditItemType() == entityType.name();
    }

    /**
     * toString
     * 
     * @return String
     */
    public String toString() {
        StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");
        buffer.append("itemType").append("='").append(getAuditItemType()).append("' ");
        buffer.append("siteName").append("='").append(getSiteName()).append("' ");
        buffer.append("eventCategory").append("='").append(getEventCategory()).append("' ");
        buffer.append("reason").append("='").append(getReason()).append("' ");
        buffer.append("createdBy").append("='").append(getCreatedBy()).append("' ");
        buffer.append("createdDtm").append("='").append(getCreatedDtm()).append("' ");
        buffer.append("lastModifiedBy").append("='").append(getLastModifiedBy()).append("' ");
        buffer.append("lastModifiedDtm").append("='").append(getLastModifiedDtm()).append("' ");
        buffer.append("]");

        return buffer.toString();
    }

    public boolean equals(Object other) {
        if ((this == other)) {
            return true;
        }

        if ((other == null)) {
            return false;
        }

        if (!(other instanceof EplItemAuditHistoryDo)) {
            return false;
        }

        EplItemAuditHistoryDo castOther = (EplItemAuditHistoryDo) other;

        return ((this.getEplId() == castOther.getEplId()) || (this.getEplId() != null && castOther.getEplId() != null && this
            .getEplId().equals(castOther.getEplId())))
            && ((this.getAuditItemType() == castOther.getAuditItemType()) || (this.getAuditItemType() != null
                && castOther.getAuditItemType() != null && this.getAuditItemType().equals(castOther.getAuditItemType())))
            && ((this.getAuditItemId() == castOther.getAuditItemId()) || (this.getAuditItemId() != null
                && castOther.getAuditItemId() != null && this.getAuditItemId().equals(castOther.getAuditItemId())))
            && ((this.getSiteName() == castOther.getSiteName()) || (this.getSiteName() != null
                && castOther.getSiteName() != null && this.getSiteName().equals(castOther.getSiteName())))
            && ((this.getEventCategory() == castOther.getEventCategory()) || (this.getEventCategory() != null
                && castOther.getEventCategory() != null && this.getEventCategory().equals(castOther.getEventCategory())))
            && ((this.getReason() == castOther.getReason()) || (this.getReason() != null && castOther.getReason() != null && this
                .getReason().equals(castOther.getReason())))
            && ((this.getCreatedBy() == castOther.getCreatedBy()) || (this.getCreatedBy() != null
                && castOther.getCreatedBy() != null && this.getCreatedBy().equals(castOther.getCreatedBy())))
            && ((this.getCreatedDtm() == castOther.getCreatedDtm()) || (this.getCreatedDtm() != null
                && castOther.getCreatedDtm() != null && this.getCreatedDtm().equals(castOther.getCreatedDtm())))
            && ((this.getLastModifiedBy() == castOther.getLastModifiedBy()) || (this.getLastModifiedBy() != null
                && castOther.getLastModifiedBy() != null && this.getLastModifiedBy().equals(castOther.getLastModifiedBy())))
            && ((this.getLastModifiedDtm() == castOther.getLastModifiedDtm()) || (this.getLastModifiedDtm() != null
                && castOther.getLastModifiedDtm() != null && this.getLastModifiedDtm()
                .equals(castOther.getLastModifiedDtm())))
            && ((this.getEplNotification() == castOther.getEplNotification()) || (this.getEplNotification() != null
                && castOther.getEplNotification() != null && this.getEplNotification()
                .equals(castOther.getEplNotification())));
    }

    public int hashCode() {
        int result = 17;

        result = 37 * result + (getEplId() == null ? 0 : this.getEplId().hashCode());
        result = 37 * result + (getAuditItemType() == null ? 0 : this.getAuditItemType().hashCode());
        result = 37 * result + (getAuditItemId() == null ? 0 : this.getAuditItemId().hashCode());
        result = 37 * result + (getSiteName() == null ? 0 : this.getSiteName().hashCode());
        result = 37 * result + (getEventCategory() == null ? 0 : this.getEventCategory().hashCode());
        result = 37 * result + (getReason() == null ? 0 : this.getReason().hashCode());
        result = 37 * result + (getCreatedBy() == null ? 0 : this.getCreatedBy().hashCode());
        result = 37 * result + (getCreatedDtm() == null ? 0 : this.getCreatedDtm().hashCode());
        result = 37 * result + (getLastModifiedBy() == null ? 0 : this.getLastModifiedBy().hashCode());
        result = 37 * result + (getLastModifiedDtm() == null ? 0 : this.getLastModifiedDtm().hashCode());
        result = 37 * result + (getEplNotification() == null ? 0 : this.getEplNotification().hashCode());

        return result;
    }

    /**
     * 
     * @return eplId property
     */
    public Long getEplId() {
        return eplId;
    }

    /**
     * 
     * @param eplId eplId property
     */
    public void setEplId(Long eplId) {
        this.eplId = eplId;
    }

}
