package gov.va.med.pharmacy.peps.domain.common.model;


import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.NamedQueries;
import org.hibernate.annotations.NamedQuery;
import org.hibernate.annotations.Type;

/**
 * EplDrugDrugInteraction generated by hbm2java
 */
@Entity
@Table(name = "EPL_DRUG_DRUG_INTERACTION", schema = "PPSNEPL", uniqueConstraints = @UniqueConstraint(columnNames = {
        "DRUG_INGREDIENT_1", "DRUG_INGREDIENT_2", "SEVERITY" }))

@NamedQueries({
    @NamedQuery(
    name = "findDrugDrugInteractionByName",
    query = "from EplDrugDrugInteractionDo  as eplDDI where eplDDI.interactionName = :interactionName"
    )
})
public class EplDrugDrugInteractionDo  extends AnnotatedDataObject implements java.io.Serializable  {

    
    public static final String DRUG_INTERACTION_NAME = "interactionName";
    public static final String SEVERITY = "severity";
    public static final String INACTIVATION_DATE = "inactivationDate";
    public static final String EPL_ID = "eplDrugDrugInteractionId";
    
    private static final long serialVersionUID = 1L;
    
    private Long eplDrugDrugInteractionId;
    private String interactionName;
    private EplIngredientDo drugIngredient1;
    private EplIngredientDo drugIngredient2;
    private EplDdiSeverityDo severity;
    private boolean nationallyEntered;
    private Long totalIndexes;
    private boolean locallyEdited;
    private Long vistaIen;
  
    private Date inactivationDate;


    public EplDrugDrugInteractionDo() {
    }

    public EplDrugDrugInteractionDo(Long eplDrugDrugInteractionId,
            String interactionName, EplIngredientDo drugIngredient1,
            EplIngredientDo drugIngredient2, EplDdiSeverityDo severity,
            String vistaFieldNumber, Long vistaIen, String createdBy,
            Date createdDtm) {
        this.eplDrugDrugInteractionId = eplDrugDrugInteractionId;
        this.interactionName = interactionName;
        this.drugIngredient1 = drugIngredient1;
        this.drugIngredient2 = drugIngredient2;
        this.severity = severity;
    
        this.vistaIen = vistaIen;
        this.createdBy = createdBy;
        this.createdDtm = createdDtm;
    }

    public EplDrugDrugInteractionDo(Long eplDrugDrugInteractionId,
            String interactionName, EplIngredientDo drugIngredient1,
            EplIngredientDo drugIngredient2, EplDdiSeverityDo severity,
            boolean nationallyEntered, Long totalIndexes,
            boolean locallyEdited, String vistaFieldNumber, Long vistaIen,
            String createdBy, Date createdDtm, Date inactivationDate, String lastModifiedBy,
            Date lastModifiedDtm) {
        this.eplDrugDrugInteractionId = eplDrugDrugInteractionId;
        this.interactionName = interactionName;
        this.drugIngredient1 = drugIngredient1;
        this.drugIngredient2 = drugIngredient2;
        this.severity = severity;
        this.nationallyEntered = nationallyEntered;
        this.totalIndexes = totalIndexes;
        this.locallyEdited = locallyEdited;
        this.vistaIen = vistaIen;
        this.createdBy = createdBy;
        this.createdDtm = createdDtm;
        this.inactivationDate = inactivationDate;
        this.lastModifiedBy = lastModifiedBy;
        this.lastModifiedDtm = lastModifiedDtm;
    }

    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "drugDrugInteractionSeqGen")
    @SequenceGenerator(name = "drugDrugInteractionSeqGen", sequenceName="EPL_DRUG_DRUG_INTERACTION_SEQ")
    @Column(name = "EPL_DRUG_DRUG_INTERACTION_ID", unique = true, nullable = false, precision = 38, scale = 0)
    public Long getEplDrugDrugInteractionId() {
        return this.eplDrugDrugInteractionId;
    }

    public void setEplDrugDrugInteractionId(Long eplDrugDrugInteractionId) {
        this.eplDrugDrugInteractionId = eplDrugDrugInteractionId;
    }

    @Column(name = "INTERACTION_NAME", nullable = false, length = 200)
    public String getInteractionName() {
        return this.interactionName;
    }

    public void setInteractionName(String interactionName) {
        this.interactionName = interactionName;
    }


    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "DRUG_INGREDIENT_1", nullable = false)
    public EplIngredientDo getDrugIngredient1() {
        return this.drugIngredient1;
    }

    public void setDrugIngredient1(EplIngredientDo drugIngredient1) {
        this.drugIngredient1 = drugIngredient1;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "DRUG_INGREDIENT_2", nullable = false)    
    public EplIngredientDo getDrugIngredient2() {
        return this.drugIngredient2;
    }

    public void setDrugIngredient2(EplIngredientDo drugIngredient2) {
        this.drugIngredient2 = drugIngredient2;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "SEVERITY", nullable = false)
    
    public EplDdiSeverityDo getSeverity() {
        return this.severity;
    }

    public void setSeverity(EplDdiSeverityDo severity) {
        this.severity = severity;
    }

    @Column(name = "NATIONALLY_ENTERED", precision = 1, scale = 0)
    @Type(type="numeric_boolean")
    public boolean getNationallyEntered() {
        return this.nationallyEntered;
    }

    public void setNationallyEntered(boolean nationallyEntered) {
        this.nationallyEntered = nationallyEntered;
    }

    @Column(name = "TOTAL_INDEXES", precision = 38, scale = 0)
    public Long getTotalIndexes() {
        return this.totalIndexes;
    }

    public void setTotalIndexes(Long totalIndexes) {
        this.totalIndexes = totalIndexes;
    }

    @Column(name = "LOCALLY_EDITED", precision = 1, scale = 0)
    @Type(type="numeric_boolean")
    public boolean getLocallyEdited() {
        return this.locallyEdited;
    }

    public void setLocallyEdited(boolean locallyEdited) {
        this.locallyEdited = locallyEdited;
    }

    @Column(name = "VISTA_IEN", nullable = false, precision = 30, scale = 0)
    public Long getVistaIen() {
        return this.vistaIen;
    }

    public void setVistaIen(Long vistaIen) {
        this.vistaIen = vistaIen;
    }
    
    @Column(name = "INACTIVATION_DATE")
    public Date getInactivationDate() {
        return this.inactivationDate;
    }

    public void setInactivationDate(Date inactivationDate) {
        this.inactivationDate = inactivationDate;
    }
   

}
