/**
 * Source file created in 2008 by Southwest Research Institute
 */


package gov.va.med.pharmacy.peps.domain.common.model;


import java.util.Date;
import java.util.HashSet;
import java.util.Set;


/**
 * EplDoseUnitDo generated by hbm2java
 * 
 * @hibernate.class
 */
public class EplDoseUnitDo extends gov.va.med.pharmacy.peps.domain.common.model.DataObject implements java.io.Serializable {

    public static final String NAME = "doseUnitName";
    public static final String IND = "doseUnitInd";
    public static final String ITEM_STATUS = "itemStatus";
    public static final String REQUEST_STATUS = "requestStatus";
    public static final String INACTIVATION_DATE = "inactivationDate";
    public static final String EPL_ID = "eplId";

    private static final long serialVersionUID = 1L;

    // Fields

    private Long eplId;
    private String doseUnitName;
    private String doseUnitInd;
    private String firstDatabankDoseUnit;
    private String requestStatus;
    private String itemStatus;
    private String rejectReasonText;
    private String requestRejectReason;
    private Date inactivationDate;
    private Long revisionNumber;
    private Set<EplDoseUnitSynonymDo> eplDoseUnitSynonyms = new HashSet<EplDoseUnitSynonymDo>(0);
    private EplDoseUnitDo eplDoseUnit;

    // Constructors

    /** default constructor */

    public EplDoseUnitDo() {
    }

    /** minimal constructor */

    public EplDoseUnitDo(Long eplId, String doseUnitName, String doseUnitInd, String firstDatabankDoseUnit,
            String requestStatus,
            String itemStatus, Long revisionNumber, String createdBy, Date createdDtm) {
        this.eplId = eplId;
        this.doseUnitName = doseUnitName;
        this.doseUnitInd = doseUnitInd;
        this.firstDatabankDoseUnit = firstDatabankDoseUnit;
        this.requestStatus = requestStatus;
        this.itemStatus = itemStatus;
        this.revisionNumber = revisionNumber;
        this.setCreatedBy(createdBy);
        this.setCreatedDtm(createdDtm);
    }

    /** full constructor */

    public EplDoseUnitDo(Long eplId, String doseUnitName, String doseUnitInd, String firstDatabankDoseUnit,
            String requestStatus,
            String itemStatus, String rejectReasonText, String requestRejectReason, Date inactivationDate,
            Long revisionNumber, String createdBy, Date createdDtm, String lastModifiedBy,
            Date lastModifiedDtm, Set<EplDoseUnitSynonymDo> eplDoseUnitSynonyms, EplDoseUnitDo eplDoseUnit) {
        this.eplId = eplId;
        this.doseUnitName = doseUnitName;
        this.doseUnitInd = doseUnitInd;
        this.firstDatabankDoseUnit = firstDatabankDoseUnit;
        this.requestStatus = requestStatus;
        this.itemStatus = itemStatus;
        this.rejectReasonText = rejectReasonText;
        this.requestRejectReason = requestRejectReason;
        this.inactivationDate = inactivationDate;
        this.revisionNumber = revisionNumber;
        this.setCreatedBy(createdBy);
        this.setCreatedDtm(createdDtm);
        this.setLastModifiedBy(lastModifiedBy);
        this.setLastModifiedDtm(lastModifiedDtm);
        this.eplDoseUnitSynonyms = eplDoseUnitSynonyms;
        this.eplDoseUnit = eplDoseUnit;
    }

    // Property accessors
    public Long getEplId() {
        return this.eplId;
    }

    public void setEplId(Long eplId) {
        this.eplId = eplId;
    }

    public String getDoseUnitName() {
        return this.doseUnitName;
    }

    public void setDoseUnitName(String doseUnitName) {
        this.doseUnitName = doseUnitName;
    }

    public String getDoseUnitInd() {
        return this.doseUnitInd;
    }

    public void setDoseUnitInd(String doseUnitInd) {
        this.doseUnitInd = doseUnitInd;
    }

    public String getFirstDatabankDoseUnit() {
        return this.firstDatabankDoseUnit;
    }

    public void setFirstDatabankDoseUnit(String firstDatabankDoseUnit) {
        this.firstDatabankDoseUnit = firstDatabankDoseUnit;
    }

    public String getRequestStatus() {
        return this.requestStatus;
    }

    public void setRequestStatus(String requestStatus) {
        this.requestStatus = requestStatus;
    }

    public String getItemStatus() {
        return this.itemStatus;
    }

    public void setItemStatus(String itemStatus) {
        this.itemStatus = itemStatus;
    }

    public String getRejectReasonText() {
        return this.rejectReasonText;
    }

    public void setRejectReasonText(String rejectReasonText) {
        this.rejectReasonText = rejectReasonText;
    }

    public String getRequestRejectReason() {
        return this.requestRejectReason;
    }

    public void setRequestRejectReason(String requestRejectReason) {
        this.requestRejectReason = requestRejectReason;
    }

    public Date getInactivationDate() {
        return this.inactivationDate;
    }

    public void setInactivationDate(Date inactivationDate) {
        this.inactivationDate = inactivationDate;
    }

    public Long getRevisionNumber() {
        return this.revisionNumber;
    }

    public void setRevisionNumber(Long revisionNumber) {
        this.revisionNumber = revisionNumber;
    }

    public Set<EplDoseUnitSynonymDo> getEplDoseUnitSynonyms() {
        return this.eplDoseUnitSynonyms;
    }

    public void setEplDoseUnitSynonyms(Set<EplDoseUnitSynonymDo> eplDoseUnitSynonyms) {
        this.eplDoseUnitSynonyms = eplDoseUnitSynonyms;
    }

    public EplDoseUnitDo getEplDoseUnit() {
        return this.eplDoseUnit;
    }

    public void setEplDoseUnit(EplDoseUnitDo eplDoseUnit) {
        this.eplDoseUnit = eplDoseUnit;
    }

    /**
     * toString
     * 
     * @return String
     */
    public String toString() {
        StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");
        buffer.append("doseUnitName").append("='").append(getDoseUnitName()).append("' ");
        buffer.append("firstDatabankDoseUnit").append("='").append(getFirstDatabankDoseUnit()).append("' ");
        buffer.append("requestStatus").append("='").append(getRequestStatus()).append("' ");
        buffer.append("itemStatus").append("='").append(getItemStatus()).append("' ");
        buffer.append("rejectReasonText").append("='").append(getRejectReasonText()).append("' ");
        buffer.append("requestRejectReason").append("='").append(getRequestRejectReason()).append("' ");
        buffer.append("inactivationDate").append("='").append(getInactivationDate()).append("' ");
        buffer.append("revisionNumber").append("='").append(getRevisionNumber()).append("' ");
        buffer.append("createdBy").append("='").append(getCreatedBy()).append("' ");
        buffer.append("createdDtm").append("='").append(getCreatedDtm()).append("' ");
        buffer.append("lastModifiedBy").append("='").append(getLastModifiedBy()).append("' ");
        buffer.append("lastModifiedDtm").append("='").append(getLastModifiedDtm()).append("' ");
        buffer.append("]");

        return buffer.toString();
    }

    public boolean equals(Object other) {
        if ((this == other)) {
            return true;
        }

        if ((other == null)) {
            return false;
        }

        if (!(other instanceof EplDoseUnitDo)) {
            return false;
        }

        EplDoseUnitDo castOther = (EplDoseUnitDo) other;

        return ((this.getEplId() == castOther.getEplId()) || (this.getEplId() != null && castOther.getEplId() != null && this
            .getEplId().equals(castOther.getEplId())))
            && ((this.getDoseUnitName() == castOther.getDoseUnitName()) || (this.getDoseUnitName() != null
                && castOther.getDoseUnitName() != null && this.getDoseUnitName().equals(castOther.getDoseUnitName())))
            && ((this.getFirstDatabankDoseUnit() == castOther.getFirstDatabankDoseUnit()) || (this
                .getFirstDatabankDoseUnit() != null
                && castOther.getFirstDatabankDoseUnit() != null && this.getFirstDatabankDoseUnit().equals(
                    castOther.getFirstDatabankDoseUnit())))
            && ((this.getRequestStatus() == castOther.getRequestStatus()) || (this.getRequestStatus() != null
                && castOther.getRequestStatus() != null && this.getRequestStatus().equals(castOther.getRequestStatus())))
            && ((this.getItemStatus() == castOther.getItemStatus()) || (this.getItemStatus() != null
                && castOther.getItemStatus() != null && this.getItemStatus().equals(castOther.getItemStatus())))
            && ((this.getRejectReasonText() == castOther.getRejectReasonText()) || (this.getRejectReasonText() != null
                && castOther.getRejectReasonText() != null && this.getRejectReasonText().equals(
                    castOther.getRejectReasonText())))
            && ((this.getRequestRejectReason() == castOther.getRequestRejectReason()) || (this.getRequestRejectReason() != null
                && castOther.getRequestRejectReason() != null && this.getRequestRejectReason().equals(
                    castOther.getRequestRejectReason())))
            && ((this.getInactivationDate() == castOther.getInactivationDate()) || (this.getInactivationDate() != null
                && castOther.getInactivationDate() != null && this.getInactivationDate().equals(
                    castOther.getInactivationDate())))
            && ((this.getRevisionNumber() == castOther.getRevisionNumber()) || (this.getRevisionNumber() != null
                && castOther.getRevisionNumber() != null && this.getRevisionNumber().equals(castOther.getRevisionNumber())))
            && ((this.getCreatedBy() == castOther.getCreatedBy()) || (this.getCreatedBy() != null
                && castOther.getCreatedBy() != null && this.getCreatedBy().equals(castOther.getCreatedBy())))
            && ((this.getCreatedDtm() == castOther.getCreatedDtm()) || (this.getCreatedDtm() != null
                && castOther.getCreatedDtm() != null && this.getCreatedDtm().equals(castOther.getCreatedDtm())))
            && ((this.getLastModifiedBy() == castOther.getLastModifiedBy()) || (this.getLastModifiedBy() != null
                && castOther.getLastModifiedBy() != null && this.getLastModifiedBy().equals(castOther.getLastModifiedBy())))
            && ((this.getLastModifiedDtm() == castOther.getLastModifiedDtm()) || (this.getLastModifiedDtm() != null
                && castOther.getLastModifiedDtm() != null && this.getLastModifiedDtm()
                .equals(castOther.getLastModifiedDtm())))
            && ((this.getEplDoseUnit() == castOther.getEplDoseUnit()) || (this.getEplDoseUnit() != null
                && castOther.getEplDoseUnit() != null && this.getEplDoseUnit().equals(castOther.getEplDoseUnit())));
    }

    /**
     * calculates hash code.
     * 
     * For the associated EplDoseUnit, the eplId's hashCode must be used instead of the class's hashCode to avoid issues with
     * mutual recursion.
     * 
     * @return hashCode
     * 
     * @see gov.va.med.pharmacy.peps.domain.common.model.DataObject#hashCode()
     */
    public int hashCode() {
        int result = 17;

        result = 37 * result + (getEplId() == null ? 0 : this.getEplId().hashCode());
        result = 37 * result + (getDoseUnitName() == null ? 0 : this.getDoseUnitName().hashCode());
        result = 37 * result + (getFirstDatabankDoseUnit() == null ? 0 : this.getFirstDatabankDoseUnit().hashCode());
        result = 37 * result + (getRequestStatus() == null ? 0 : this.getRequestStatus().hashCode());
        result = 37 * result + (getItemStatus() == null ? 0 : this.getItemStatus().hashCode());
        result = 37 * result + (getRejectReasonText() == null ? 0 : this.getRejectReasonText().hashCode());
        result = 37 * result + (getRequestRejectReason() == null ? 0 : this.getRequestRejectReason().hashCode());
        result = 37 * result + (getInactivationDate() == null ? 0 : this.getInactivationDate().hashCode());
        result = 37 * result + (getRevisionNumber() == null ? 0 : this.getRevisionNumber().hashCode());
        result = 37 * result + (getCreatedBy() == null ? 0 : this.getCreatedBy().hashCode());
        result = 37 * result + (getCreatedDtm() == null ? 0 : this.getCreatedDtm().hashCode());
        result = 37 * result + (getLastModifiedBy() == null ? 0 : this.getLastModifiedBy().hashCode());
        result = 37 * result + (getLastModifiedDtm() == null ? 0 : this.getLastModifiedDtm().hashCode());
        result = 37 * result + (getEplDoseUnit() == null ? 0 : this.getEplDoseUnit().getEplId().hashCode());

        return result;
    }

}
