/**
 * Source file created in 2008 by Southwest Research Institute
 */


package gov.va.med.pharmacy.peps.domain.common.model;


import java.util.Date;
import java.util.HashSet;
import java.util.Set;


/**
 * EplDosageFormDo generated by hbm2java
 * 
 * @hibernate.class
 */
public class EplDosageFormDo extends gov.va.med.pharmacy.peps.domain.common.model.DataObject implements java.io.Serializable {

    // Fields
    public static final String EPL_ID = "eplId";
    public static final String ITEM_STATUS = "itemStatus";
    public static final String REQUEST_STATUS = "requestStatus";
    public static final String DF_NAME = "dfName";
    public static final String INACTIVATION_DATE = "inactivationDate";

    private static final long serialVersionUID = 1L;

    private Long eplId;
    private Long dosageformIen;
    private String dfName;
    private String excludeFromDosageChks;
    private Date inactivationDate;
    private String requestStatus;
    private String itemStatus;
    private String rejectReasonText;
    private String requestRejectReason;
    private Long revisionNumber;
    private Set<EplDfNounDo> eplDfNouns = new HashSet<EplDfNounDo>(0);
    private Set<EplDfUnitDo> eplDfUnits = new HashSet<EplDfUnitDo>(0);
    private Set<EplDispenseUnitsPerDoseDo> eplDispenseUnitsPerDoses = new HashSet<EplDispenseUnitsPerDoseDo>(0);
    private Set<EplProductDo> eplProducts = new HashSet<EplProductDo>(0);
    private Set<EplDfMedRtDfAssocDo> eplDfMedRtDfAssocs = new HashSet<EplDfMedRtDfAssocDo>(0);
    private Set<EplOrderableItemDo> eplOrderableItems = new HashSet<EplOrderableItemDo>(0);

    // Constructors

    /** default constructor */

    public EplDosageFormDo() {
    }

    /** minimal constructor */

    public EplDosageFormDo(Long eplId, String createdBy, Date createdDtm) {
        this.eplId = eplId;
        this.setCreatedBy(createdBy);
        this.setCreatedDtm(createdDtm);
    }

    /** full constructor */

    public EplDosageFormDo(Long eplId, Long dosageformIen, String dfName, String excludeFromDosageChks, Date inactivationDate,
                           String createdBy, Date createdDtm, String lastModifiedBy, Date lastModifiedDtm,
                           Set<EplProductDo> eplProducts, Set<EplDfMedRtDfAssocDo> eplDfMedRtDfAssocs,
                           Set<EplOrderableItemDo> eplOrderableItems) {
        this.eplId = eplId;
        this.dosageformIen = dosageformIen;
        this.dfName = dfName;
        this.excludeFromDosageChks = excludeFromDosageChks;
        this.inactivationDate = inactivationDate;
        this.setCreatedBy(createdBy);
        this.setCreatedDtm(createdDtm);
        this.setLastModifiedBy(lastModifiedBy);
        this.setLastModifiedDtm(lastModifiedDtm);
        this.eplProducts = eplProducts;
        this.eplDfMedRtDfAssocs = eplDfMedRtDfAssocs;
        this.eplOrderableItems = eplOrderableItems;
    }

    // Property accessors
    public Long getEplId() {
        return this.eplId;
    }

    public void setId(Long id) {
        this.eplId = id;
    }
    
    // Property accessors
    public Long getDosageformIen() {
        return this.dosageformIen;
    }

    public void setDosageformIen(Long dosageformIen) {
        this.dosageformIen = dosageformIen;
    }

    public String getDfName() {
        return this.dfName;
    }

    public void setDfName(String dfName) {
        this.dfName = dfName;
    }

    public Date getInactivationDate() {
        return this.inactivationDate;
    }

    public void setInactivationDate(Date inactivationDate) {
        this.inactivationDate = inactivationDate;
    }

    public Set<EplProductDo> getEplProducts() {
        return this.eplProducts;
    }

    public void setEplProducts(Set<EplProductDo> eplProducts) {
        this.eplProducts = eplProducts;
    }

    public Set<EplDfMedRtDfAssocDo> getEplDfMedRtDfAssocs() {
        return this.eplDfMedRtDfAssocs;
    }

    public void setEplDfMedRtDfAssocs(Set<EplDfMedRtDfAssocDo> eplDfMedRtDfAssocs) {
        this.eplDfMedRtDfAssocs = eplDfMedRtDfAssocs;
    }

    public Set<EplOrderableItemDo> getEplOrderableItems() {
        return this.eplOrderableItems;
    }

    public void setEplOrderableItems(Set<EplOrderableItemDo> eplOrderableItems) {
        this.eplOrderableItems = eplOrderableItems;
    }

    /**
     * toString
     * 
     * @return String
     */
    public String toString() {
        StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");
        buffer.append("dfName").append("='").append(getDfName()).append("' ");
        buffer.append("dosageformIen").append("='").append(getDfName()).append("' ");
        buffer.append("excludeFromDosageChks").append("='").append(getExcludeFromDosageChks()).append("' ");
        buffer.append("inactivationDate").append("='").append(getInactivationDate()).append("' ");
        buffer.append("createdBy").append("='").append(getCreatedBy()).append("' ");
        buffer.append("createdDtm").append("='").append(getCreatedDtm()).append("' ");
        buffer.append("lastModifiedBy").append("='").append(getLastModifiedBy()).append("' ");
        buffer.append("lastModifiedDtm").append("='").append(getLastModifiedDtm()).append("' ");
        buffer.append("]");

        return buffer.toString();
    }

    public boolean equals(Object other) {
        if ((this == other)) {
            return true;
        }

        if ((other == null)) {
            return false;
        }

        if (!(other instanceof EplDosageFormDo)) {
            return false;
        }

        EplDosageFormDo castOther = (EplDosageFormDo) other;

        return ((this.getEplId() == castOther.getEplId()) || (this.getEplId() != null && castOther.getEplId() != null && this
            .getEplId().equals(castOther.getEplId())))
            && ((this.getDfName() == castOther.getDfName()) || (this.getDfName() != null && castOther.getDfName() != null && this
                .getDfName().equals(castOther.getDfName())))
            && ((this.getExcludeFromDosageChks() == castOther.getExcludeFromDosageChks()) || (this
                .getExcludeFromDosageChks() != null
                && castOther.getExcludeFromDosageChks() != null && this.getExcludeFromDosageChks().equals(
                    castOther.getExcludeFromDosageChks())))
            && ((this.getDosageformIen() == castOther.getDosageformIen()) || (this
                .getDosageformIen() != null
                && castOther.getDosageformIen() != null && this.getDosageformIen().equals(
                    castOther.getDosageformIen())))

            && ((this.getInactivationDate() == castOther.getInactivationDate()) || (this.getInactivationDate() != null
                && castOther.getInactivationDate() != null && this.getInactivationDate().equals(
                    castOther.getInactivationDate())))
            && ((this.getCreatedBy() == castOther.getCreatedBy()) || (this.getCreatedBy() != null
                && castOther.getCreatedBy() != null && this.getCreatedBy().equals(castOther.getCreatedBy())))
            && ((this.getCreatedDtm() == castOther.getCreatedDtm()) || (this.getCreatedDtm() != null
                && castOther.getCreatedDtm() != null && this.getCreatedDtm().equals(castOther.getCreatedDtm())))
            && ((this.getLastModifiedBy() == castOther.getLastModifiedBy()) || (this.getLastModifiedBy() != null
                && castOther.getLastModifiedBy() != null && this.getLastModifiedBy().equals(castOther.getLastModifiedBy())))
            && ((this.getLastModifiedDtm() == castOther.getLastModifiedDtm()) || (this.getLastModifiedDtm() != null
                && castOther.getLastModifiedDtm() != null && this.getLastModifiedDtm()
                .equals(castOther.getLastModifiedDtm())));
    }

    public int hashCode() {
        int result = 17;

        result = 37 * result + (getEplId() == null ? 0 : this.getEplId().hashCode());
        result = 37 * result + (getDfName() == null ? 0 : this.getDfName().hashCode());
        result = 37 * result + (getDosageformIen() == null ? 0 : this.getDosageformIen().hashCode());
        result = 37 * result + (getExcludeFromDosageChks() == null ? 0 : this.getExcludeFromDosageChks().hashCode());
        result = 37 * result + (getInactivationDate() == null ? 0 : this.getInactivationDate().hashCode());
        result = 37 * result + (getCreatedBy() == null ? 0 : this.getCreatedBy().hashCode());
        result = 37 * result + (getCreatedDtm() == null ? 0 : this.getCreatedDtm().hashCode());
        result = 37 * result + (getLastModifiedBy() == null ? 0 : this.getLastModifiedBy().hashCode());
        result = 37 * result + (getLastModifiedDtm() == null ? 0 : this.getLastModifiedDtm().hashCode());

        return result;
    }

    public Set<EplDfNounDo> getEplDfNouns() {
        return eplDfNouns;
    }

    public void setEplDfNouns(Set<EplDfNounDo> eplDfNouns) {
        this.eplDfNouns = eplDfNouns;
    }

    public Set<EplDfUnitDo> getEplDfUnits() {
        return eplDfUnits;
    }

    public void setEplDfUnits(Set<EplDfUnitDo> eplDfUnits) {
        this.eplDfUnits = eplDfUnits;
    }

    public Set<EplDispenseUnitsPerDoseDo> getEplDispenseUnitsPerDoses() {
        return eplDispenseUnitsPerDoses;
    }

    public void setEplDispenseUnitsPerDoses(Set<EplDispenseUnitsPerDoseDo> eplDispenseUnitsPerDoses) {
        this.eplDispenseUnitsPerDoses = eplDispenseUnitsPerDoses;
    }

    public String getRequestStatus() {
        return requestStatus;
    }

    public void setRequestStatus(String requestStatus) {
        this.requestStatus = requestStatus;
    }

    public String getItemStatus() {
        return itemStatus;
    }

    public void setItemStatus(String itemStatus) {
        this.itemStatus = itemStatus;
    }

    public String getRejectReasonText() {
        return rejectReasonText;
    }

    public void setRejectReasonText(String rejectReasonText) {
        this.rejectReasonText = rejectReasonText;
    }

    public String getRequestRejectReason() {
        return requestRejectReason;
    }

    public void setRequestRejectReason(String requestRejectReason) {
        this.requestRejectReason = requestRejectReason;
    }

    public Long getRevisionNumber() {
        return revisionNumber;
    }

    public void setRevisionNumber(Long revisionNumber) {
        this.revisionNumber = revisionNumber;
    }

    public void setEplId(Long eplId) {
        this.eplId = eplId;
    }

    /**
     * 
     * @return excludeFromDosageChks property
     */
    public String getExcludeFromDosageChks() {
        return excludeFromDosageChks;
    }

    /**
     * 
     * @param excludeFromDosageChks excludeFromDosageChks property
     */
    public void setExcludeFromDosageChks(String excludeFromDosageChks) {
        this.excludeFromDosageChks = excludeFromDosageChks;
    }

}
