package gov.va.med.pharmacy.peps.domain.common.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.NamedQueries;
import org.hibernate.annotations.NamedQuery;

@Entity
@Table(name = "EPL_DDI_SEVERITY"
, schema = "PPSNEPL")
@NamedQueries({
    @NamedQuery(
    name = "findSeverityByName",
    query = "from gov.va.med.pharmacy.peps.domain.common.model.EplDdiSeverityDo as severity where severity.name = :severity"
    )
})
public class EplDdiSeverityDo extends AnnotatedDataObject implements Serializable {

   
    public static final String EPL_ID = "severityId";
    
    private static final long serialVersionUID = 1L;
    
    public static final String SEVERITY_NAME = "name";
    
    private int severityId;
    private String name;
   
   
   
    public EplDdiSeverityDo() {
    }

    public EplDdiSeverityDo (int severityId, String name) {
        this.severityId = severityId;
        this.name = name;
       
    }

   
    
    @Id
    @Column(name="EPL_ID", unique = true, nullable = false, precision = 30, scale = 0)
    public int getSeverityId() {
        return severityId;
    }
    
  
    public void setSeverityId(int severityId) {
        this.severityId = severityId;
    }
    
    
    @Column(name="NAME", nullable=false)
    public String getName() {
        return name;
    }
    
    
    public void setName(String name) {
        this.name = name;
    }

  
}
