/**
 * Source file created in 2008 by Southwest Research Institute
 */


package gov.va.med.pharmacy.peps.domain.common.model;


import java.util.Date;
import java.util.HashSet;
import java.util.Set;


/**
 * EplClassTypeDo generated by hbm2java
 *
 * @hibernate.class
 */
public class EplClassTypeDo extends gov.va.med.pharmacy.peps.domain.common.model.DataObject implements java.io.Serializable {


    // Fields
    public static final String CLASS_TYPE_DESCRIPTION = "classTypeDescription";
    private static final long serialVersionUID = 1L;

    private Long id;
    private String classTypeCode;
    private String classTypeDescription;
    private Set<EplVaDrugClassDo> eplVaDrugClasses = new HashSet<EplVaDrugClassDo>(0);

    // Constructors

    /** default constructor. */

    public EplClassTypeDo() {
    }

    /**
     * Minimal constructor.
     *
     * @param id
     * @param classTypeCode
     * @param classTypeDescription
     * @param createdBy
     * @param createdDtm
     */
    public EplClassTypeDo(Long id, String classTypeCode, String classTypeDescription, String createdBy, Date createdDtm) {
        this.id = id;
        this.classTypeCode = classTypeCode;
        this.classTypeDescription = classTypeDescription;
        this.setCreatedBy(createdBy);
        this.setCreatedDtm(createdDtm);
    }

    /**
     * Full constructor.
     *
     * @param id
     * @param classTypeCode
     * @param classTypeDescription
     * @param createdBy
     * @param createdDtm
     * @param lastModifiedBy
     * @param lastModifiedDtm
     * @param eplVaDrugClasses
     */
    public EplClassTypeDo(
            Long id, String classTypeCode, String classTypeDescription, String createdBy, Date createdDtm,
            String lastModifiedBy,
                          Date lastModifiedDtm, Set<EplVaDrugClassDo> eplVaDrugClasses) {
        this.id = id;
        this.classTypeCode = classTypeCode;
        this.classTypeDescription = classTypeDescription;
        this.setCreatedBy(createdBy);
        this.setCreatedDtm(createdDtm);
        this.setLastModifiedBy(lastModifiedBy);
        this.setLastModifiedDtm(lastModifiedDtm);
        this.eplVaDrugClasses = eplVaDrugClasses;
    }

    /**
     * Get the unique identifier.
     *
     * @return the unique identifier
     */
    public Long getId() {
        return this.id;
    }

    /**
     * Set the unique identifier.
     *
     * @param id
     *            the new unique identifier value
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * @return class type description
     */
    public String getClassTypeDescription() {
        return this.classTypeDescription;
    }

    /**
     * @param classTypeDescription
     *            new class type description value
     */
    public void setClassTypeDescription(String classTypeDescription) {
        this.classTypeDescription = classTypeDescription;
    }

    /**
     * Get Class Type Code.
     *
     * @return String containing class type code
     */
    public String getClassTypeCode() {
        return classTypeCode;
    }

    /**
     * Set Class Type Code.
     *
     * @param classTypeCode
     */
    public void setClassTypeCode(String classTypeCode) {
        this.classTypeCode = classTypeCode;
    }

    /**
     * Get EPL VA Drug Classes.
     *
     * @return Set of EPL VA Drug Classes
     */
    public Set<EplVaDrugClassDo> getEplVaDrugClasses() {
        return this.eplVaDrugClasses;
    }

    /**
     * Set EPL VA Drug Classes.
     *
     * @param eplVaDrugClasses
     */
    public void setEplVaDrugClasses(Set<EplVaDrugClassDo> eplVaDrugClasses) {
        this.eplVaDrugClasses = eplVaDrugClasses;
    }

    /**
     * toString
     *
     * @return String
     */
    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");
        buffer.append("id").append("='").append(getId()).append("' ");
        buffer.append("classTypeCode").append("='").append(getClassTypeCode()).append("' ");
        buffer.append("classTypeDescription").append("='").append(getClassTypeDescription()).append("' ");
        buffer.append("createdBy").append("='").append(getCreatedBy()).append("' ");
        buffer.append("createdDtm").append("='").append(getCreatedDtm()).append("' ");
        buffer.append("lastModifiedBy").append("='").append(getLastModifiedBy()).append("' ");
        buffer.append("lastModifiedDtm").append("='").append(getLastModifiedDtm()).append("' ");
        buffer.append("]");

        return buffer.toString();
    }

    @Override
    public boolean equals(Object other) {
        if ((this == other)) {
            return true;
        }

        if ((other == null)) {
            return false;
        }

        if (!(other instanceof EplClassTypeDo)) {
            return false;
        }

        EplClassTypeDo castOther = (EplClassTypeDo) other;

        return ((this.getId() == castOther.getId()) || ((this.getId() != null) && (castOther.getId() != null) && this.getId()
            .equals(castOther.getId())))
                && ((this.getClassTypeCode() == castOther.getClassTypeCode()) || ((this.getClassTypeCode() != null)
                        && (castOther.getClassTypeCode() != null) && this.getClassTypeCode().equals(
                        castOther.getClassTypeCode())))
                && ((this.getClassTypeDescription() == castOther.getClassTypeDescription()) || ((this.getClassTypeDescription() != null)
                        && (castOther.getClassTypeDescription() != null) && this.getClassTypeDescription().equals(
                        castOther.getClassTypeDescription())))
            && ((this.getCreatedBy() == castOther.getCreatedBy()) || ((this.getCreatedBy() != null)
                && (castOther.getCreatedBy() != null) && this.getCreatedBy().equals(castOther.getCreatedBy())))
            && ((this.getCreatedDtm() == castOther.getCreatedDtm()) || ((this.getCreatedDtm() != null)
                && (castOther.getCreatedDtm() != null) && this.getCreatedDtm().equals(castOther.getCreatedDtm())))
            && ((this.getLastModifiedBy() == castOther.getLastModifiedBy()) || ((this.getLastModifiedBy() != null)
                && (castOther.getLastModifiedBy() != null) && this.getLastModifiedBy().equals(castOther.getLastModifiedBy())))
            && ((this.getLastModifiedDtm() == castOther.getLastModifiedDtm()) || ((this.getLastModifiedDtm() != null)
                && (castOther.getLastModifiedDtm() != null) && this.getLastModifiedDtm()
                .equals(castOther.getLastModifiedDtm())));
    }

    @Override
    public int hashCode() {
        int result = 17;

        result = (37 * result) + (getId() == null ? 0 : this.getId().hashCode());
        result = (37 * result) + (getClassTypeCode() == null ? 0 : this.getClassTypeCode().hashCode());
        result = (37 * result) + (getClassTypeDescription() == null ? 0 : this.getClassTypeDescription().hashCode());
        result = (37 * result) + (getCreatedBy() == null ? 0 : this.getCreatedBy().hashCode());
        result = (37 * result) + (getCreatedDtm() == null ? 0 : this.getCreatedDtm().hashCode());
        result = (37 * result) + (getLastModifiedBy() == null ? 0 : this.getLastModifiedBy().hashCode());
        result = (37 * result) + (getLastModifiedDtm() == null ? 0 : this.getLastModifiedDtm().hashCode());

        return result;
    }

}
