/**
 * Source file created in 2006 by Southwest Research Institute
 */


package gov.va.med.pharmacy.peps.domain.common.model;


import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;


/**
 * DataObjects common implementation
 */
@MappedSuperclass
public abstract class AnnotatedDataObject extends DataObject implements Serializable, Cloneable {
    
  

    private static final long serialVersionUID = 1L;

    /** createdBy */
    protected String createdBy;
    
    /** createdDtm */
    protected Date createdDtm;
    
    /** lastModifiedBy */
    protected String lastModifiedBy;
    
    /** lastModifiedDtm */
    protected Date lastModifiedDtm;
    

    /**
     * getCreatedBy
     * @return createdBy property
     */
    @Column(name = "CREATED_BY", nullable = false, length = 50)
    public String getCreatedBy() {
        return createdBy;
    }

    /**
     * setCreatedBy
     * @param createdBy createdBy property
     */
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    /**
     * getCreatedDtm
     * @return createdDtm property
     */
    @Column(name = "CREATED_DTM", nullable = false)
    public Date getCreatedDtm() {
        return createdDtm;
    }

    /**
     * setCreatedDtm
     * @param createdDtm createdDtm property
     */
    public void setCreatedDtm(Date createdDtm) {
        this.createdDtm = createdDtm;
    }

    /**
     * getLastModifiedBy
     * @return lastModifiedBy property
     */
    @Column(name = "LAST_MODIFIED_BY", length = 50)
    public String getLastModifiedBy() {
        return lastModifiedBy;
    }

    /**
     * setLastModifiedBy
     * @param lastModifiedBy lastModifiedBy property
     */
    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    /**
     * getLastModifiedDtm
     * @return lastModifiedDtm property
     */
    @Column(name = "LAST_MODIFIED_DTM")
    public Date getLastModifiedDtm() {
        return lastModifiedDtm;
    }

    /**
     * setLastModifiedDtm
     * @param lastModifiedDtm lastModifiedDtm property
     */
    public void setLastModifiedDtm(Date lastModifiedDtm) {
        this.lastModifiedDtm = lastModifiedDtm;
    }


 
}
