/**
 * 
 */
package gov.va.med.pharmacy.peps.domain.common.dao.impl;

import gov.va.med.pharmacy.peps.common.object.VistaStatus;
import gov.va.med.pharmacy.peps.domain.common.dao.EplVistaUpdateStatusDao;
import gov.va.med.pharmacy.peps.domain.common.model.EplVistaStatusDo;

import javax.annotation.Resource;

import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;


/**
 * @author VHAISACARUSR
 *
 */
@Repository
public class EplVistaUpdateStatusDaoImpl extends DataAccessObjectImpl<EplVistaStatusDo, Long> implements EplVistaUpdateStatusDao {

    @Resource
    private SessionFactory sessionFactory;

    @Override
    public EplVistaStatusDo getStatusByName(VistaStatus status){
        Criteria criteria = getSessionFactory().getCurrentSession().createCriteria(EplVistaStatusDo.class);
        criteria.add(Restrictions.eq("statusName", status.toString()));
        return (EplVistaStatusDo) criteria.uniqueResult();
    }

    /**
     * @return the sessionFactory
     */
    @Override
    public SessionFactory getSessionFactory() {
        return sessionFactory;
    }

    /**
     * @param sessionFactory the sessionFactory to set
     */
    @Override
    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
    
}
