/**
 * 
 */


package gov.va.med.pharmacy.peps.domain.common.dao.impl;


import gov.va.med.pharmacy.peps.common.object.VistaStatus;
import gov.va.med.pharmacy.peps.common.vo.NationalSetting;
import gov.va.med.pharmacy.peps.common.vo.StatusVo;
import gov.va.med.pharmacy.peps.common.vo.UserVo;
import gov.va.med.pharmacy.peps.domain.common.dao.EplNationalSettingDao;
import gov.va.med.pharmacy.peps.domain.common.dao.EplNdfUpdateFileDao;
import gov.va.med.pharmacy.peps.domain.common.dao.EplStatusDao;
import gov.va.med.pharmacy.peps.domain.common.dao.EplVistaUpdateDao;
import gov.va.med.pharmacy.peps.domain.common.dao.EplVistaUpdateStatusDao;
import gov.va.med.pharmacy.peps.domain.common.model.EplNationalSettingDo;
import gov.va.med.pharmacy.peps.domain.common.model.EplNdfUpdateFileDo;
import gov.va.med.pharmacy.peps.domain.common.model.EplVistaStatusDo;
import gov.va.med.pharmacy.peps.domain.common.model.EplVistaUpdateDo;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;


/**
 * @author VHAISACARUSR
 *
 */
//@Repository
public class EplVistaUpdateDaoImpl extends DataAccessObjectImpl<EplVistaUpdateDo, Long> implements EplVistaUpdateDao {

    public static final int NATIONAL_SITE = 521;
    public static final int NATIONAL_SITE_ALT = 200;
    @Autowired
    private SessionFactory sessionFactory;

    @Autowired
    private EplVistaUpdateStatusDao eplVistaUpdateStatusDao;
    @Autowired
    private EplNdfUpdateFileDao eplNdfUpdateFileDao;
    @Autowired
    private EplStatusDao eplStatusDao;
    @Autowired
    private EplNationalSettingDao eplNationalSettingDao;

    /**
     * Saves the EplVistaUpdateDo.  If it is from the National Site, it updates the file status and does not save a EplVistaUpdate row.
     * @see gov.va.med.pharmacy.peps.domain.common.dao.EplVistaUpdateDao#save(gov.va.med.pharmacy.peps.domain.common.model.EplVistaUpdateDo)
     */
    @Override
    public EplVistaUpdateDo save(EplVistaUpdateDo eplVistaUpdate) {
              
        populateStatus(eplVistaUpdate);                
        int nationalSite = populateNationalSite();
                    
        if (eplVistaUpdate.getSite() == nationalSite) {
            return saveNationalSiteUpdate(eplVistaUpdate);   
        }
        
        populateFileForEplVistaUpdate(eplVistaUpdate);
        
        Session session = sessionFactory.getCurrentSession();        
        //Long id = (Long) session.save(eplVistaUpdate);
        session.save(eplVistaUpdate);
        return null;
//        EplVistaUpdateDo savedEplVistaUpdate =
//            (EplVistaUpdateDo) session.get(EplVistaUpdateDo.class, id);
//        return savedEplVistaUpdate;
    }

    /**
     * Saves a status update from the National Site.
     * @param eplVistaUpdate
     * @return
     */
    private EplVistaUpdateDo saveNationalSiteUpdate(
            EplVistaUpdateDo eplVistaUpdate) {
        populateFile(eplVistaUpdate); 
        if (eplVistaUpdate.getEplNdfUpdateFileDo() == null){ //if no file was found we don't do anything
            return null;
        }
        EplNdfUpdateFileDo ndfUpdateFileDo = eplVistaUpdate.getEplNdfUpdateFileDo();
        ndfUpdateFileDo.setComments(eplVistaUpdate.getComments());
        if (VistaStatus.STARTED.toString().equals(eplVistaUpdate.getEplVistaStatus().getStatusName())) {
            ndfUpdateFileDo.setEplStatus(eplStatusDao.retrieve(StatusVo.START_OF_NATIONAL_PROCESSING));
        } 
		else if (VistaStatus.COMPLETED.toString().equals(eplVistaUpdate.getEplVistaStatus().getStatusName())) {
            eplVistaUpdate.getEplNdfUpdateFileDo().setEplStatus(eplStatusDao.retrieve(StatusVo.NATIONAL_INSTALL_SUCCESS));
        }
        else if (VistaStatus.ERROR.toString().equals(eplVistaUpdate.getEplVistaStatus().getStatusName())) {
            // if we receive a VistA error we automatically reject the file
            eplVistaUpdate.getEplNdfUpdateFileDo().setEplStatus(eplStatusDao.retrieve(StatusVo.VISTA_ERROR));
            eplVistaUpdate.getEplNdfUpdateFileDo()
                          .setComments("Automatically Rejected: Unable to Install Update File in the Test Account.");
        }
        else {
            eplVistaUpdate.getEplNdfUpdateFileDo().setEplStatus(eplStatusDao.retrieve(StatusVo.VISTA_ERROR));
            eplVistaUpdate.getEplNdfUpdateFileDo().setComments("Invalid Status Sent from VistA.");
        }
        eplNdfUpdateFileDao.update(eplVistaUpdate.getEplNdfUpdateFileDo(), new UserVo());
        return eplVistaUpdate;
    }

    /**
     * @return
     */
    private int populateNationalSite() {
        EplNationalSettingDo ns = eplNationalSettingDao.findByKeyName(NationalSetting.NATIONAL_SITE_NUMBER.toString());
        
        Long nationalSite = ns.getIntegerValue();
        return nationalSite.intValue();
    }

    /**
     * @param eplVistaUpdate
     */
    private void populateFile(EplVistaUpdateDo eplVistaUpdate) {
        EplNdfUpdateFileDo file = eplNdfUpdateFileDao.retrieveVistaWaitingByName(eplVistaUpdate.getEplNdfUpdateFileDo().getFileName());
        eplVistaUpdate.setEplNdfUpdateFileDo(file);
    }

    /**
     * @param eplVistaUpdate
     */
    private void populateFileForEplVistaUpdate(EplVistaUpdateDo eplVistaUpdate) {
        EplNdfUpdateFileDo file = eplNdfUpdateFileDao.retrieveByName(eplVistaUpdate.getEplNdfUpdateFileDo().getFileName());
        eplVistaUpdate.setEplNdfUpdateFileDo(file);
    }    
    
    /**
     * 
     * @param eplVistaUpdate
     */
    private void populateStatus(EplVistaUpdateDo eplVistaUpdate) {
        VistaStatus vistaStatus = VistaStatus.valueOf(eplVistaUpdate.getEplVistaStatus().getStatusName());
        EplVistaStatusDo status =
            eplVistaUpdateStatusDao.getStatusByName(vistaStatus);
        eplVistaUpdate.setEplVistaStatus(status);
    }

    @Override
    @Autowired
    public SessionFactory getSessionFactory() {
        return sessionFactory;
    }

    @Override
    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    /**
     * @return the eplVistaUpdateStatusDao
     */
    @Override
    public EplVistaUpdateStatusDao getEplVistaUpdateStatusDao() {
        return eplVistaUpdateStatusDao;
    }

    /**
     * @param eplVistaUpdateStatusDao the eplVistaUpdateStatusDao to set
     */
    @Override
    public void setEplVistaUpdateStatusDao(EplVistaUpdateStatusDao eplVistaUpdateStatusDao) {
        this.eplVistaUpdateStatusDao = eplVistaUpdateStatusDao;
    }

    /**
     * @return the eplNdfUpdateFileDao
     */
    @Override
    public EplNdfUpdateFileDao getEplNdfUpdateFileDao() {
        return eplNdfUpdateFileDao;
    }

    /**
     * @param eplNdfUpdateFileDao the eplNdfUpdateFileDao to set
     */
    @Override
    public void setEplNdfUpdateFileDao(EplNdfUpdateFileDao eplNdfUpdateFileDao) {
        this.eplNdfUpdateFileDao = eplNdfUpdateFileDao;
    }

    /**
     * @return the eplStatusDao
     */
    public EplStatusDao getEplStatusDao() {
        return eplStatusDao;
    }

    /**
     * @param eplStatusDao the eplStatusDao to set
     */
    public void setEplStatusDao(EplStatusDao eplStatusDao) {
        this.eplStatusDao = eplStatusDao;
    }

    /**
     * @return the eplNationalSettingDao
     */
    public EplNationalSettingDao getEplNationalSettingDao() {
        return eplNationalSettingDao;
    }

    /**
     * @param eplNationalSettingDao the eplNationalSettingDao to set
     */
    public void setEplNationalSettingDao(EplNationalSettingDao eplNationalSettingDao) {
        this.eplNationalSettingDao = eplNationalSettingDao;
    }

}
