package gov.va.med.pharmacy.peps.domain.common.dao.impl;

import static gov.va.med.pharmacy.peps.common.utility.ESAPIValidator.validateLongInput;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;

import gov.va.med.pharmacy.peps.common.vo.NdfUpdateFileVo;
import gov.va.med.pharmacy.peps.domain.common.dao.EplRematchSuggestionDao;
import gov.va.med.pharmacy.peps.domain.common.model.EplRematchSuggestionDo;
import gov.va.med.pharmacy.peps.domain.common.utility.converter.NdfUpdateFileConverter;

import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;



//@Repository
public class EplRematchSuggestionDaoImpl extends DataAccessObjectImpl<EplRematchSuggestionDo, Long> implements EplRematchSuggestionDao   {
      
    @Autowired
    private SessionFactory sessionFactory;
    
    NdfUpdateFileConverter ndfUpdateFileConverter;
    
    @Override
    @Autowired
    public SessionFactory getSessionFactory() {
        return sessionFactory;
    }

    /**
     * @param sessionFactory the sessionFactory to set
     */
    @Override
    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
    
    /**
     * Find All
     */

    
    @Override
    public List<EplRematchSuggestionDo> findAll(){         
        
        Session session = sessionFactory.getCurrentSession();
        Query query = session.getNamedQuery("retrieveAll");          
            
        List<EplRematchSuggestionDo> returnedValues = query.list();
        
        return returnedValues;
    }
    
    
    /**
     * Find By Id
     */

    @Override
    public EplRematchSuggestionDo findById(Long id) {
        Long validatedId = null;
        if (id == null) {
            throw new IllegalArgumentException("RematchSuggestion id cannot be null");
        } else {
        	validatedId = validateLongInput(id.toString());
        }
        
        Session session = getSessionFactory().getCurrentSession();        
        EplRematchSuggestionDo eplRematchSuggestionDo = (EplRematchSuggestionDo) session.get(EplRematchSuggestionDo.class, validatedId);
        
        return eplRematchSuggestionDo;
    }
    
    @Override
    public List<EplRematchSuggestionDo> retrieveByMatchType(Long matchId){         
        Long validatedMatchId = null;
        if (matchId != null) {
        	validatedMatchId = validateLongInput(matchId.toString());
        }
        Session session = sessionFactory.getCurrentSession();
        Query query = session.getNamedQuery("retrieveByMatch").setLong("matchTypeId", validatedMatchId);
            
        List<EplRematchSuggestionDo> returnedValues = query.list();
        
        return returnedValues;
    }
    
    @Override
    public Long retrieveProductId(String productIen){         
        
        Session session = sessionFactory.getCurrentSession();
        Query query = session.getNamedQuery("retrieveProductId")  
        .setString("productIen",productIen);
            
        List<Long> returnedValue = query.list();
        
        return returnedValue.get(0);
    }
    
    @Override   
    public List<Object[]> findRematchProducts(Long productId) {
        Session session = sessionFactory.getCurrentSession();
        Query query = session.getNamedQuery("findRematch")
            .setLong("unmatchedProductId",productId);
        List<Object[]> returnedValues = query.list();
        
        return returnedValues;
    } 

    /**
     * Save
     */
    @Override
    public EplRematchSuggestionDo save(EplRematchSuggestionDo eplRematchSuggestionDo) {
        
        EplRematchSuggestionDo rematchSuggestion = new EplRematchSuggestionDo();
        
        Session session = getSessionFactory().getCurrentSession();        
        Long id = (Long) session.save(eplRematchSuggestionDo);        
        rematchSuggestion = findById(id);
        
        return rematchSuggestion;
    }

   /**
    * Update
    */
    @Override
    public EplRematchSuggestionDo update(EplRematchSuggestionDo eplRematchSuggestion) {
        
        Session session = getSessionFactory().getCurrentSession();
        session.update(eplRematchSuggestion);
        
        return eplRematchSuggestion;
    }
    
    @Override
    public List<Object[]> removeObsoleteInactiveProduct() {
        Session session = sessionFactory.getCurrentSession();
        Query query = session.getNamedQuery("obsoleteInactiveUnmatch")
            .setString("vistaFileNumber","50.68")
            .setString("vistaFieldNumber", "21");
            
        List<Object[]> returnedValues = query.list();
        
        return returnedValues;
    }
    
    @Override
    public List<Object[]> loadInactiveProduct() {
        Session session = sessionFactory.getCurrentSession();
        Query query = session.getNamedQuery("loadInactiveUnmatch")            
            .setString("vistaFileNumber","50.68")
            .setString("vistaFieldNumber", "21");
            
        List<Object[]> returnedValues = query.list();
        
        return returnedValues;
    }
    
    @Override
    public List<Object[]> removeObsoletePrintName() {
        Session session = sessionFactory.getCurrentSession();
        Query query = session.getNamedQuery("obsoleteUnmatch")
            .setInteger("matchTypeId", 3)
            .setString("vistaFileNumber","50.68")
            .setString("vistaFieldNumber", "5");
            
        List<Object[]> returnedValues = query.list(); 
        
        return returnedValues;
    }
    
    @Override
    public List<Object[]> removeObsoleteOthers() {
        Session session = sessionFactory.getCurrentSession();
        Query query = session.getNamedQuery("obsoleteUnmatch")
            .setInteger("matchTypeId", 3)
            .setString("vistaFileNumber","50.68");            
            
        List<Object[]> returnedValues = query.list(); 
        
        return returnedValues;
    }
    
    @Override
    public List<Object[]> loadUnmatchPrintName() {
        Session session = sessionFactory.getCurrentSession();
        Query query = session.getNamedQuery("loadUnmatch")
            .setInteger("matchTypeId", 3)
            .setString("vistaFileNumber","50.68")
            .setString("vistaFieldNumber", "5");
            
        List<Object[]> returnedValues = query.list(); 
        
        return returnedValues;
    }
    
    @Override
    public List<Object[]> removeObsoleteGenericName() {
        Session session = sessionFactory.getCurrentSession();
        Query query = session.getNamedQuery("obsoleteUnmatch")
            .setInteger("matchTypeId", 3)
            .setString("vistaFileNumber","50.68")
            .setString("vistaFieldNumber", ".05");
            
        List<Object[]> returnedValues = query.list(); 
        
        return returnedValues;
    }
    
    @Override
    public List<Object[]> loadUnmatchGenericName() {
        Session session = sessionFactory.getCurrentSession();
        Query query = session.getNamedQuery("loadUnmatch")
            .setInteger("matchTypeId", 3)
            .setString("vistaFileNumber","50.68")
            .setString("vistaFieldNumber", ".05");
            
        List<Object[]> returnedValues = query.list(); 
        
        return returnedValues;
    }
    
    @Override
    public List<Object[]> removeObsoleteCMOP() {
        Session session = sessionFactory.getCurrentSession();
        Query query = session.getNamedQuery("obsoleteUnmatch")
            .setInteger("matchTypeId", 3)
            .setString("vistaFileNumber","50.68")
            .setString("vistaFieldNumber", "6");
            
        List<Object[]> returnedValues = query.list(); 
        
        return returnedValues;
    }
    
    @Override
    public List<Object[]> loadUnmatchCMOP() {
        Session session = sessionFactory.getCurrentSession();
        Query query = session.getNamedQuery("loadUnmatchCmop")
            .setInteger("matchTypeId", 3)
            .setString("vistaFileNumber","50.68")
            .setString("vistaFieldNumber", "6");
            
        List<Object[]> returnedValues = query.list(); 
        
        return returnedValues;
    }
    
    @Override
    public List<Object[]> removeObsoleteDispense() {
        Session session = sessionFactory.getCurrentSession();
        Query query = session.getNamedQuery("obsoleteUnmatch")
            .setInteger("matchTypeId", 3)
            .setString("vistaFileNumber","50.68")
            .setString("vistaFieldNumber", "8");
            
        List<Object[]> returnedValues = query.list(); 
        
        return returnedValues;
    }
    
    @Override
    public List<Object[]> loadUnmatchDispense() {
        Session session = sessionFactory.getCurrentSession();
        Query query = session.getNamedQuery("loadUnmatch")
            .setInteger("matchTypeId", 3)
            .setString("vistaFileNumber","50.68")
            .setString("vistaFieldNumber", "8");
            
        List<Object[]> returnedValues = query.list(); 
        
        return returnedValues;
    }
    
    @Override
    public List<Object[]> removeObsoleteDosageForm() {
        Session session = sessionFactory.getCurrentSession();
        Query query = session.getNamedQuery("obsoleteUnmatch")
            .setInteger("matchTypeId", 3)
            .setString("vistaFileNumber","50.68")
            .setString("vistaFieldNumber", "1");
            
        List<Object[]> returnedValues = query.list(); 
        
        return returnedValues;
    }
    
    @Override
    public List<Object[]> loadUnmatchDosageForm() {
        Session session = sessionFactory.getCurrentSession();
        Query query = session.getNamedQuery("loadUnmatch")
            .setInteger("matchTypeId", 3)
            .setString("vistaFileNumber","50.68")
            .setString("vistaFieldNumber", "1");
            
        List<Object[]> returnedValues = query.list(); 
        
        return returnedValues;
    }
    
    @Override
    public List<Object[]> removeObsoleteStrength() {
        Session session = sessionFactory.getCurrentSession();
        Query query = session.getNamedQuery("obsoleteUnmatch")
            .setInteger("matchTypeId", 3)
            .setString("vistaFileNumber","50.68")
            .setString("vistaFieldNumber", "2");
            
        List<Object[]> returnedValues = query.list(); 
        
        return returnedValues;
    }
    
    @Override
    public List<Object[]> loadUnmatchStrength() {
        Session session = sessionFactory.getCurrentSession();
        Query query = session.getNamedQuery("loadUnmatch")
            .setInteger("matchTypeId", 3)
            .setString("vistaFileNumber","50.68")
            .setString("vistaFieldNumber", "2");
            
        List<Object[]> returnedValues = query.list(); 
        
        return returnedValues;
    }
    
    @Override
    public List<Object[]> removeObsoleteDrugUnit() {
        Session session = sessionFactory.getCurrentSession();
        Query query = session.getNamedQuery("obsoleteUnmatch")
            .setInteger("matchTypeId", 3)
            .setString("vistaFileNumber","50.68")
            .setString("vistaFieldNumber", "3");
            
        List<Object[]> returnedValues = query.list(); 
        
        return returnedValues;
    }
    
    @Override
    public List<Object[]> loadUnmatchDrugUnit() {
        Session session = sessionFactory.getCurrentSession();
        Query query = session.getNamedQuery("loadUnmatch")
            .setInteger("matchTypeId", 3)
            .setString("vistaFileNumber","50.68")
            .setString("vistaFieldNumber", "3");
            
        List<Object[]> returnedValues = query.list(); 
        
        return returnedValues;
    }
    
    @Override
    public List<Object[]> removeObsoleteFedSch() {
        Session session = sessionFactory.getCurrentSession();
        Query query = session.getNamedQuery("obsoleteUnmatch")
            .setInteger("matchTypeId", 3)
            .setString("vistaFileNumber","50.68")
            .setString("vistaFieldNumber", "19");
            
        List<Object[]> returnedValues = query.list(); 
        
        return returnedValues;
    }
    
    @Override
    public List<Object[]> loadUnmatchFedSch() {
        Session session = sessionFactory.getCurrentSession();
        Query query = session.getNamedQuery("loadUnmatch")
            .setInteger("matchTypeId", 3)
            .setString("vistaFileNumber","50.68")
            .setString("vistaFieldNumber", "19");
            
        List<Object[]> returnedValues = query.list(); 
        
        return returnedValues;
    }
    
    @Override
    public List<Object[]> removeObsoleteFutureInactivated() {
        Session session = sessionFactory.getCurrentSession();
        Query query = session.getNamedQuery("obsoleteFutureInactiveUnmatch");            
            
        List<Object[]> returnedValues = query.list(); 
        
        return returnedValues;
    }
    
    @Override
    public List<Object[]> loadFutureInactivated() {
        Session session = sessionFactory.getCurrentSession();
        Query query = session.getNamedQuery("loadFutureInactiveUnmatch");            
            
        List<Object[]> returnedValues = query.list(); 
        
        return returnedValues;
    }
    
    /**
     * Find rematch suggestion
     *
     * 
     * @return report data list
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> findRematchAuto(Date startDTM){        
        Timestamp startDate = new Timestamp(startDTM.getTime());   
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("rematchAuto")  
          .setTimestamp("startDate", startDate)
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
   } 
    
    /**
     * Find rematch suggestion
     *
     * 
     * @return report data list
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> findRematchSugg(Date startDTM){        
        Timestamp startDate = new Timestamp(startDTM.getTime());   
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("rematchSuggestion")  
          .setTimestamp("startDate", startDate)
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
   }   
    
    /**
     * Find rematch suggestion
     *
     * 
     * @return report data list
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> findRematchNoSugg(Date startDTM){        
        Timestamp startDate = new Timestamp(startDTM.getTime());   
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("rematchNoSuggestion")  
          .setTimestamp("startDate", startDate)
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
   }  
    
    /**
     * Find rematch suggestion
     *
     * 
     * @return report data list
     */
    @SuppressWarnings("unchecked")
    @Override
    public void updateRematchNdfUpdateFileFk(Date startDTM, NdfUpdateFileVo ndfUpdateFileVo){        
        Timestamp startDate = new Timestamp(startDTM.getTime());   
        
        Session session = sessionFactory.getCurrentSession();
        Query query = session.getNamedQuery("retrieveAllByDate") 
            .setTimestamp("startDate", startDate);
            
        List<EplRematchSuggestionDo> returnedValues = query.list();
        
                
        for (EplRematchSuggestionDo eplRematchSuggestionDo : returnedValues) {
            
            eplRematchSuggestionDo.setNdcUpdateFile(ndfUpdateFileConverter.convert(ndfUpdateFileVo));
            update(eplRematchSuggestionDo);
        }
        
        
   }
    
    public void removeNdfUpdateFileFk(Long fileSeqNo) {
        
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.createQuery("update EplRematchSuggestionDo set ndcUpdateFile = null "
            + " where ndcUpdateFile = " + fileSeqNo);
        query.executeUpdate();
    }

    
    public NdfUpdateFileConverter getNdfUpdateFileConverter() {
        return ndfUpdateFileConverter;
    }

    
    public void setNdfUpdateFileConverter(NdfUpdateFileConverter ndfUpdateFileConverter) {
        this.ndfUpdateFileConverter = ndfUpdateFileConverter;
    }   

}
    
    
