/**
 * Source file created in 2006 by Southwest Research Institute
 */


package gov.va.med.pharmacy.peps.domain.common.dao.impl;


import java.util.List;

import org.hibernate.Query;

import gov.va.med.pharmacy.peps.domain.common.dao.EplProductDao;
import gov.va.med.pharmacy.peps.domain.common.model.EplProductDo;


/**
 * This class makes available the methods that may be used to access and 
 * modify the data referenced by the EplProductDao.
 */
public class EplProductDaoImpl extends DataAccessObjectImpl<EplProductDo, Long> implements EplProductDao {

    private static final String RXNORM_QUERY = "retrieveAllButExcludedProducts";

    private static final String retrieveGncNdcMapSql = "SELECT prods.ndf_product_ien, prods.gcn_Seqno, ndc.ndc_No_Dashes " +
        "FROM Epl_Products prods JOIN (SELECT ndcs.epl_id_product_fk, ndcs.ndc_no_dashes, RANK() " +
        "OVER (PARTITION BY ndcs.epl_id_product_fk ORDER BY ndcs.ndc_no_dashes)rnk  " +
        "FROM epl_ndcs ndcs WHERE ndcs.item_status = 'ACTIVE') ndc ON prods.epl_id = ndc.epl_id_product_fk " +
        "AND ndc.rnk = 1 and prods.gcn_Seqno IS NOT NULL AND prods.item_Status = 'ACTIVE' " +
        "ORDER BY prods.ndf_product_ien";
    private static final String retrieveNdcProductNameSql = "SELECT prods.epl_id FROM Epl_Products prods, Epl_Ndcs ndcs where ndcs.ndc_no_dashes = ?" +
        " and epl_id_product_fk = prods.epl_id";

    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> retrieveInactive() {
        Query query = getCurrentSession().getNamedQuery("retrieveInactive");
        return (List<Object[]>) query.list();
    }

    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> retrieveGcnNdcMap() {
        Query query = getCurrentSession().createSQLQuery(retrieveGncNdcMapSql);
        return query.list();
    }

    @SuppressWarnings("unchecked")
    @Override
    public List<EplProductDo> retrieveProductsNotExcludedFromRxNormUpdate() {
        Query query = getCurrentSession().getNamedQuery(RXNORM_QUERY);
        return query.list();
    }
    
  @SuppressWarnings("unchecked")
  @Override
  public List<EplProductDo> retrieveVaProduct(String ndc) {        
      Query query = getCurrentSession().createSQLQuery(retrieveNdcProductNameSql);
      query.setString(0, ndc);        
      return query.list();
  }
}
