package gov.va.med.pharmacy.peps.domain.common.dao.impl;


import java.util.List;

import org.hibernate.Query;
import org.springframework.stereotype.Repository;

import gov.va.med.pharmacy.peps.common.utility.ESAPIValidator;
import gov.va.med.pharmacy.peps.domain.common.dao.EplPackageSizeDao;
import gov.va.med.pharmacy.peps.domain.common.model.EplPackageSizeDo;


/**
 * This class makes available the methods that may be used to access and 
 * modify the data referenced by the EplPackageTypeDao.
 */
//@Repository
public class EplPackageSizeDaoImpl extends DataAccessObjectImpl<EplPackageSizeDo, Long> implements EplPackageSizeDao {
 
    /**
     * Finds an EplPackageSizeDo object by the package size value
     * 
     * @return EplPackageSizeDo object
     */
    public EplPackageSizeDo retrieveByPackageSize(Double packageSize){
        
        Query query = getCurrentSession().getNamedQuery("retrieveByPackageSize")
            .setDouble("packageSize", ESAPIValidator.validateDoubleInput(packageSize.toString()));
        List<EplPackageSizeDo> returnedValues = query.list();       
        if(returnedValues.size() == 0 || returnedValues == null)
            return null;
        
        return returnedValues.get(0);
    }
    
    /**
     * Finds an EplPackageSizeDo object by epl id.
     * 
     * @return EplPackageSizeDo object
     */
    public EplPackageSizeDo retrieveById(Long eplId){
        
        Query query = getCurrentSession().getNamedQuery("retrieveById")
            .setDouble("eplId", eplId);           
        EplPackageSizeDo returnedValues = (EplPackageSizeDo) query.uniqueResult();
        
        return returnedValues;
    }
}
