

package gov.va.med.pharmacy.peps.domain.common.dao.impl;


import gov.va.med.pharmacy.peps.domain.common.dao.EplNdfUpdateFileDao;
import gov.va.med.pharmacy.peps.domain.common.model.EplNdfUpdateFileDo;

import org.hibernate.Query;
import org.springframework.stereotype.Repository;

//@Repository
public class EplNdfUpdateFileDaoImpl extends DataAccessObjectImpl<EplNdfUpdateFileDo, Long> implements
    EplNdfUpdateFileDao {

    private static final String FIND_BY_NAME = "retrieveByName";
    private static final String FIND_VISTA_WAITING_NAME = "retrieveVistaWaitingByName";
   
    public Long retrieveNextSeq() {

        Query query = getCurrentSession().getNamedQuery("retrieveNextSeq");
      /*  List nextVal = query.list();
        Long seq = new Long(((Integer) nextVal.get(0)));*/
        return (Long) query.uniqueResult();
    }

    @Override
    public EplNdfUpdateFileDo retrieveByName(String name) {
        Query query = getCurrentSession().getNamedQuery(FIND_BY_NAME);
        query.setString("fileName", name);
        return (EplNdfUpdateFileDo) query.uniqueResult();
    }

    /*
     * Retrieves file using name only is status is "Transmitted to testing" (3) or "Start of Vista Processing"(4)
     */
    @Override
    public EplNdfUpdateFileDo retrieveVistaWaitingByName(String name) {
        Query query = getCurrentSession().getNamedQuery(FIND_VISTA_WAITING_NAME);
        query.setString("fileName", name);
        return (EplNdfUpdateFileDo) query.uniqueResult();
    }
}
