package gov.va.med.pharmacy.peps.domain.common.dao.impl;


import java.sql.Timestamp;
import java.util.Date;
import java.util.List;

import gov.va.med.pharmacy.peps.common.vo.NdfUpdateFileVo;
import gov.va.med.pharmacy.peps.domain.common.dao.EplNdfOutgoingDifferencesDao;
import gov.va.med.pharmacy.peps.domain.common.model.EplNdfOutgoingDifferences;
import gov.va.med.pharmacy.peps.domain.common.utility.converter.NdfUpdateFileConverter;

import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;


/**
 * @author VHAISACARUSR
 *
 */
//@Repository
public class EplNdfOutgoingDifferencesDaoImpl implements EplNdfOutgoingDifferencesDao {
      
    @Autowired
    private SessionFactory sessionFactory;

    NdfUpdateFileConverter ndfUpdateFileConverter;
    
    /**
     * Find by id.
     *
     * @param id the id
     * @return the epl ndf outgoing differences
     */
    @Override
    public EplNdfOutgoingDifferences findById(Long id){
        if(id == null){
            throw new IllegalArgumentException("id cannot be null");
        }
        Session session = getSessionFactory().getCurrentSession();
        EplNdfOutgoingDifferences eplNdfOutgoingDifferences =
            (EplNdfOutgoingDifferences) session.get(EplNdfOutgoingDifferences.class, id);
        return eplNdfOutgoingDifferences;
    }
    
    /**
     * Find by id.
     *
     * @param id the id
     * @return the epl ndf outgoing differences
     */
    @Override
    public List<EplNdfOutgoingDifferences> retrieveDifferencesForOutputFile(Date date){ 
        
        Timestamp startDate = new Timestamp(date.getTime());
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("retrieveDifferencesForOutputFile")
          .setTimestamp("startDate", startDate);
            
        List<EplNdfOutgoingDifferences> returnedValues = query.list();
        
        return returnedValues;
    }
    
    /**
     * Find by file and field number for data that is not yet associated to an output file.
     *
     * @param id the id
     * @return the epl ndf outgoing differences
     */
    @Override
    public List<Object[]> findByFileAndField(String vistaFileNumber, String vistaFieldNumber, Date startDTM){
        
        Timestamp startDate = new Timestamp(startDTM.getTime());    
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("findByFileAndField")
            .setString("vistaFileNumber", vistaFileNumber)
            .setString("vistaFieldNumber", vistaFieldNumber)
            .setTimestamp("startDate", startDate);
            
        List<Object[]> returnedValues = query.list();
                
        return returnedValues;
    }
    
    
    public List<Object[]> findDrugClassChanges(String vistaFileNumber, String vistaFieldNumber, Date startDTM) {
        
        Timestamp startDate = new Timestamp(startDTM.getTime());
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("findDrugClassChanges")
            .setString("vistaFileNumber", vistaFileNumber)
            .setString("vistaFieldNumber", vistaFieldNumber)
            .setTimestamp("startDate", startDate);

        List<Object[]> returnedValues = query.list();
        
        return returnedValues;
    }
    
    /**
     * Find by file,field, and ien were ndf update file is null.
     *
     * @param id the id
     * @return the epl ndf outgoing differences
     */
    @Override
    public EplNdfOutgoingDifferences findByFileFieldIen(String vistaFileNumber, String vistaFieldNumber, String vistaIen){
    
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("findByFileFieldIen")
          .setString("vistaFileNumber",vistaFileNumber)
          .setString("vistaFieldNumber", vistaFieldNumber)
          .setString("vistaIen", vistaIen);
            
        EplNdfOutgoingDifferences returnedValue = (EplNdfOutgoingDifferences) query.uniqueResult();

        
        return returnedValue;    
   }
    
    /**
     * Find by file,field, and ien were ndf update file is null.
     *
     * @param vistaFileNumber the file number
     * @param vistaFieldNumber the field number
     * @param actionType the action
     * @return the epl ndf outgoing differences
     */
    @Override
    public EplNdfOutgoingDifferences findModifiedRecords(String vistaFileNumber, String vistaFieldNumber, String vistaIen, String actionType){
    
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("findModifiedRecords")
          .setString("vistaFileNumber",vistaFileNumber)
          .setString("vistaFieldNumber", vistaFieldNumber)
          .setString("vistaIen", vistaIen)
          .setString("actionType", actionType);
            
        EplNdfOutgoingDifferences returnedValue = (EplNdfOutgoingDifferences) query.uniqueResult();
        
        return returnedValue;    
   }

    /**
     * Find inactive generic name by file and field number
     *
     * @param vistaFileNumber the file number
     * @param vistaFieldNumber the field number
     * @return report data list
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<String> findInactiveGenericName(String vistaFileNumber, String vistaFieldNumber, Date startDTM){
        
        Timestamp startDate = new Timestamp(startDTM.getTime());     
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("genericNameInactivateReport")
          .setString("vistaFileNumber",vistaFileNumber)
          .setString("vistaFieldNumber", vistaFieldNumber)     
          .setTimestamp("startDate", startDate)
          .setReadOnly(true);
        
        return (List<String>) query.list();
   } 
    
    /**
     * Find override exclusion by file and field number
     *
     * @param vistaFileNumber the file number
     * @param vistaFieldNumber the field number
     * @return report data list
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> findOverrideDFChkExcl(String vistaFileNumber, String vistaFieldNumber, Date startDTM){
        
        Timestamp startDate = new Timestamp(startDTM.getTime());     
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("overrideDFChkExclReport")
          .setString("vistaFileNumber",vistaFileNumber)
          .setString("vistaFieldNumber", vistaFieldNumber)  
          .setTimestamp("startDate", startDate)
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
   }
    
    /**
     * Find message report data by by file and field number
     *
     * @param vistaFileNumber the file number
     * @param vistaFieldNumber the field number
     * @return report data list
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> messageGenericChange(String vistaFileNumber, String vistaFieldNumber, Date startDTM){
        
        Timestamp startDate = new Timestamp(startDTM.getTime());     
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("messageGenericChangeReport")
          .setString("vistaFileNumber",vistaFileNumber)
          .setString("vistaFieldNumber", vistaFieldNumber)     
          .setTimestamp("startDate", startDate)
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
   }
    
    /**
     * Find message report data by by file and field number
     *
     * @param vistaFileNumber the file number
     * @param vistaFieldNumber the field number
     * @return report data list
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> messageCMOPChange(String vistaFileNumber, String vistaFieldNumber, Date startDTM){
        
        Timestamp startDate = new Timestamp(startDTM.getTime());    
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("messageCMOPChangeReport")
          .setString("vistaFileNumber",vistaFileNumber)
          .setString("vistaFieldNumber", vistaFieldNumber)  
          .setTimestamp("startDate", startDate)
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
   }
    
    /**
     * Find drug unit change by file and field number
     *
     * @param vistaFileNumber the file number
     * @param vistaFieldNumber the field number
     * @return report data list
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> drugUnitsChange(String vistaFileNumber, String vistaFieldNumber, Date startDTM){
        
        Timestamp startDate = new Timestamp(startDTM.getTime());    
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("drugUnitsChangeReport")
          .setString("vistaFileNumber",vistaFileNumber)
          .setString("vistaFieldNumber", vistaFieldNumber)    
          .setTimestamp("startDate", startDate)
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
   }
    
    /**
     * Find all generic name change by file and field number
     *
     * @param vistaFileNumber the file number
     * @param vistaFieldNumber the field number
     * @return report data list
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> genNameAllChange(String vistaFileNumber, String vistaFieldNumber, Date startDTM){
        
        Timestamp startDate = new Timestamp(startDTM.getTime());    
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("genericNameAllChangeReport")
          .setString("vistaFileNumber",vistaFileNumber)
          .setString("vistaFieldNumber", vistaFieldNumber) 
          .setTimestamp("startDate", startDate)
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
   }
    
    /**
     * Find dosage form by file and field number
     *
     * @param vistaFileNumber the file number
     * @param vistaFieldNumber the field number
     * @return report data list
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> dosageFormChange(String vistaFileNumber, String vistaFieldNumber, Date startDTM){
        
        Timestamp startDate = new Timestamp(startDTM.getTime());    
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("dosageFormChangeReport")
          .setString("vistaFileNumber",vistaFileNumber)
          .setString("vistaFieldNumber", vistaFieldNumber) 
          .setTimestamp("startDate", startDate)
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
   }
    
    /**
     * Find dispense unit change by file and field number
     *
     * @param vistaFileNumber the file number
     * @param vistaFieldNumber the field number
     * @return report data list
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> dispenseUnitsChange(String vistaFileNumber, String vistaFieldNumber, Date startDTM){
        
        Timestamp startDate = new Timestamp(startDTM.getTime());     
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("dispenseUnitsChangeReport")
          .setString("vistaFileNumber",vistaFileNumber)
          .setString("vistaFieldNumber", vistaFieldNumber)   
          .setTimestamp("startDate", startDate)
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
   }
    
    /**
     * Find class change by file and field number
     *
     * @param vistaFileNumber the file number
     * @param vistaFieldNumber the field number
     * @return report data list
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> classChange(String vistaFileNumber, String vistaFieldNumber, Date startDTM){
        
        Timestamp startDate = new Timestamp(startDTM.getTime());     
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("classChangeReport")
          .setString("vistaFileNumber",vistaFileNumber)
          .setString("vistaFieldNumber", vistaFieldNumber)   
          .setTimestamp("startDate", startDate)
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
   }
    
    /**
     * Find schedule change by file and field number
     *
     * @param vistaFileNumber the file number
     * @param vistaFieldNumber the field number
     * @return report data list
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> scheduleAllChange(String vistaFileNumber, String vistaFieldNumber, Date startDTM){
        
        Timestamp startDate = new Timestamp(startDTM.getTime());     
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("scheduleAllChangeReport")
          .setString("vistaFileNumber",vistaFileNumber)
          .setString("vistaFieldNumber", vistaFieldNumber) 
          .setTimestamp("startDate", startDate)
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
   }
    
    /**
     * Find products to be in-activated in the future 
     *     
     * @return report data list
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> futureInactiveChange(){
    
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("futureInactivationReport")                  
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
   }
    
    /**
     * Find products to be in-activated in the future 
     *     
     * @return report data list
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> futureInactiveRematched(){
    
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("futureInactiveRematchReport")                  
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
   }
    
    
    /**
     * Find active national formulary product by file and field number
     *
     * @param vistaFileNumber the file number
     * @param vistaFieldNumber the field number
     * @return report data list
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> findActiveNatFormularyProducts(String vistaFileNumber, String vistaFieldNumber, Date startDTM){
        
        Timestamp startDate = new Timestamp(startDTM.getTime());    
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("activeNatFormularyChangeReport")
          .setString("vistaFileNumber",vistaFileNumber)
          .setString("vistaFieldNumber", vistaFieldNumber)     
          .setTimestamp("startDate", startDate)
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
   }
    
    /**
     * Find find added med guide product by file and field number
     *
     * @param vistaFileNumber the file number
     * @param vistaFieldNumber the field number
     * @return report data list
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> findAddedMedGuideProducts(String vistaFileNumber, String vistaFieldNumber, Date startDTM){
        
        Timestamp startDate = new Timestamp(startDTM.getTime());     
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("addedMedGuideReport")
          .setString("vistaFileNumber",vistaFileNumber)
          .setString("vistaFieldNumber", vistaFieldNumber)   
          .setTimestamp("startDate", startDate)
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
   }
    
    /**
     * Find find added med guide product by file and field number
     *
     * @param vistaFileNumber the file number
     * @param vistaFieldNumber the field number
     * @return report data list
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> findAddedDDIs(String vistaFileNumber, String vistaFieldNumber, Date startDTM){
        
        Timestamp startDate = new Timestamp(startDTM.getTime());     
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("addedDDIReport")
          .setString("vistaFileNumber",vistaFileNumber)
          .setString("vistaFieldNumber", vistaFieldNumber)  
          .setTimestamp("startDate", startDate)
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
   }
    
    /**
     * Find find added med guide product by file and field number
     *
     * @param vistaFileNumber the file number
     * @param vistaFieldNumber the field number
     * @return report data list
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> findReactivatedDDIs(String vistaFileNumber, String vistaFieldNumber, Date startDTM){
        
        Timestamp startDate = new Timestamp(startDTM.getTime());    
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("reactivatedDDIReport")
          .setString("vistaFileNumber",vistaFileNumber)
          .setString("vistaFieldNumber", vistaFieldNumber)    
          .setTimestamp("startDate", startDate)
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
   }
    
    /**
     * Find edited med guide product by file and field number
     *
     * @param vistaFileNumber the file number
     * @param vistaFieldNumber the field number
     * @return report data list
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> findEditedMedGuideProducts(String vistaFileNumber, String vistaFieldNumber, Date startDTM){
        
        Timestamp startDate = new Timestamp(startDTM.getTime());     
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("editedMedGuideReport")
          .setString("vistaFileNumber",vistaFileNumber)
          .setString("vistaFieldNumber", vistaFieldNumber) 
          .setTimestamp("startDate", startDate)
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
   }
    
    /**
     * Find edited med guide product by file and field number
     *
     * @param vistaFileNumber the file number
     * @param vistaFieldNumber the field number
     * @return report data list
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> findEditedDDIs(String vistaFileNumber, String vistaFieldNumber, Date startDTM){
        
        Timestamp startDate = new Timestamp(startDTM.getTime());    
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("editedDDIReport")
          .setString("vistaFileNumber",vistaFileNumber)
          .setString("vistaFieldNumber", vistaFieldNumber)     
          .setTimestamp("startDate", startDate)
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
   }
    
    /**
     * Find deleted med guide product by file and field number
     *
     * @param vistaFileNumber the file number
     * @param vistaFieldNumber the field number
     * @return report data list
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> findDeletedMedGuideProducts(String vistaFileNumber, String vistaFieldNumber, Date startDTM){
        
        Timestamp startDate = new Timestamp(startDTM.getTime());    
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("deletedMedGuideReport")
          .setString("vistaFileNumber",vistaFileNumber)
          .setString("vistaFieldNumber", vistaFieldNumber)   
          .setTimestamp("startDate", startDate)
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
   }
    
    /**
     * Find deleted med guide product by file and field number
     *
     * @param vistaFileNumber the file number
     * @param vistaFieldNumber the field number
     * @return report data list
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> findInactivatedDDIs(String vistaFileNumber, String vistaFieldNumber, Date startDTM){
        
        Timestamp startDate = new Timestamp(startDTM.getTime());
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("inactivatedDDIReport")
          .setString("vistaFileNumber",vistaFileNumber)
          .setString("vistaFieldNumber", vistaFieldNumber)    
          .setTimestamp("startDate", startDate)
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
   } 
    
    /**
     * Find excluded DDI product by file and field number
     *
     * @param vistaFileNumber the file number
     * @param vistaFieldNumber the field number
     * @return report data list
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> findExcludedDDIProducts(String vistaFileNumber, String vistaFieldNumber, Date startDTM){
        
        Timestamp startDate = new Timestamp(startDTM.getTime());    
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("excludedDDIReport")
          .setString("vistaFileNumber",vistaFileNumber)
          .setString("vistaFieldNumber", vistaFieldNumber)      
          .setTimestamp("startDate", startDate)
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
   }  
    
    /**
     * Find excluded DDI product by file and field number
     *
     * @param vistaFileNumber the file number
     * @param vistaFieldNumber the field number
     * @return report data list
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> findPrevExcludedDDIProducts(String vistaFileNumber, String vistaFieldNumber, Date startDTM){
        
        Timestamp startDate = new Timestamp(startDTM.getTime());    
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("prevExcludedDDIReport")
          .setString("vistaFileNumber",vistaFileNumber)
          .setString("vistaFieldNumber", vistaFieldNumber)      
          .setTimestamp("startDate", startDate)
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
   }  
    
    /**
     * Find active national formulary product by file and field number
     *
     * @param vistaFileNumber the file number
     * @param vistaFieldNumber the field number
     * @return report data list
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> findInactiveNatFormularyProducts(String vistaFileNumber, String vistaFieldNumber, Date startDTM){
        
        Timestamp startDate = new Timestamp(startDTM.getTime());     
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("inactiveNatFormularyChangeReport")
          .setString("vistaFileNumber",vistaFileNumber)
          .setString("vistaFieldNumber", vistaFieldNumber)   
          .setTimestamp("startDate", startDate)
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
   }
    
    /**
     * Find in-activated CMOP by file and field number
     *
     * @param vistaFileNumber the file number
     * @param vistaFieldNumber the field number
     * @return report data list
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> findInactivatedCMOPProducts(String vistaFileNumber, String vistaFieldNumber, Date startDTM){
        
        Timestamp startDate = new Timestamp(startDTM.getTime());      
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("inactivatedCMOPReport")
          .setString("vistaFileNumber",vistaFileNumber)
          .setString("vistaFieldNumber", vistaFieldNumber) 
          .setTimestamp("startDate", startDate)
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
   }
    
    /**
     * Find in-activated CMOP by file and field number
     *
     * @param vistaFileNumber the file number
     * @param vistaFieldNumber the field number
     * @return report data list
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> findReactivatedProducts(String vistaFileNumber, String vistaFieldNumber, Date startDTM){
        
        Timestamp startDate = new Timestamp(startDTM.getTime());     
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("reactivatedProductReport")
          .setString("vistaFileNumber",vistaFileNumber)
          .setString("vistaFieldNumber", vistaFieldNumber)
          .setTimestamp("startDate", startDate)
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
   }
    
    /**
     * Find schedule change by file and field number
     *
     * @param vistaFileNumber the file number
     * @param vistaFieldNumber the field number
     * @return report data list
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> findScheduleChangeProducts(String vistaFileNumber, String vistaFieldNumber){
    
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("scheduleChangeReport")
          .setString("vistaFileNumber",vistaFileNumber)
          .setString("vistaFieldNumber", vistaFieldNumber)          
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
   }
    
    /**
     * Find possible dosage change to NO by file and field number
     *
     * @param vistaFileNumber the file number
     * @param vistaFieldNumber the field number
     * @return report data list
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> findNoPossibleDosageProducts(String vistaFileNumber, Date startDTM){
        
        Timestamp startDate = new Timestamp(startDTM.getTime());      
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("noPossibleDosageReport")
          .setString("vistaFileNumber",vistaFileNumber)    
          .setTimestamp("startDate", startDate)
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
   }
    
    /**
     * Find possible dosage change to YES by file and field number
     *
     * @param vistaFileNumber the file number
     * @param vistaFieldNumber the field number
     * @return report data list
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> findYesPossibleDosageProducts(String vistaFileNumber, String vistaFieldNumber, Date startDTM){
        
        Timestamp startDate = new Timestamp(startDTM.getTime());    
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("yesPossibleDosageReport")
          .setString("vistaFileNumber",vistaFileNumber)
          .setString("vistaFieldNumber", vistaFieldNumber)     
          .setTimestamp("startDate", startDate)
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
   }
    
    /**
     * Find unmatched products by file number
     *
     * @param vistaFileNumber the file number    
     * @return fileIEN
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> findUnmatchedProducts(String vistaFileNumber){
    
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("unmatchedProducts")
          .setString("vistaFileNumber",vistaFileNumber)                  
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
   }
    
    /**
     * Find products made inactive at local site to add to PRODUCT^ list
     *
     * @param vistaFileNumber the file number    
     * @return fileIEN
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> findInactivatedProductsForLocal(String vistaFileNumber, Date startDTM){
        
        Timestamp startDate = new Timestamp(startDTM.getTime());     
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("inactivatedProductsForLocal")
          .setString("vistaFileNumber",vistaFileNumber)      
          .setTimestamp("startDate", startDate)
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
   }
    
    /**
     * Find inactivated products
     *
     * @param vistaFileNumber the file number    
     * @return fileIEN
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> findInactivatedProducts(String vistaFileNumber, String vistaFieldNumber, Date startDTM){
        
        Timestamp startDate = new Timestamp(startDTM.getTime());    
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("inactivatedProductReport")
          .setString("vistaFileNumber",vistaFileNumber)   
          .setString("vistaFieldNumber", vistaFieldNumber)
          .setTimestamp("startDate", startDate)
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
   }
    
    /**
     * Find inactivated products
     *
     * @param vistaFileNumber the file number    
     * @return fileIEN
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> findInactiveRematchReport(String vistaFileNumber, String vistaFieldNumber, Date startDTM){
        
        Timestamp startDate = new Timestamp(startDTM.getTime());    
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("inactiveRematchReport")
          .setString("vistaFileNumber",vistaFileNumber)   
          .setString("vistaFieldNumber", vistaFieldNumber)
          .setTimestamp("startDate", startDate)
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
   }
    
    /**
     * Find inactivated products
     *
     * @param vistaFileNumber the file number    
     * @return fileIEN
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> findInactiveRematchReportSugg(String vistaFileNumber, String vistaFieldNumber, Date startDTM){
        
        Timestamp startDate = new Timestamp(startDTM.getTime());    
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("inactiveRematchReportSugg")
          .setString("vistaFileNumber",vistaFileNumber)   
          .setString("vistaFieldNumber", vistaFieldNumber)
          .setTimestamp("startDate", startDate)
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
   }
    
    /**
     * Find added products by file and field number
     *
     * @param vistaFileNumber the file number
     * @param vistaFieldNumber the field number
     * @return report data list
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<Object[]> findAddedProducts(String vistaFileNumber, String vistaFieldNumber, Date startDTM){
        
        Timestamp startDate = new Timestamp(startDTM.getTime());    
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("addedProductsReport")
          .setString("vistaFileNumber",vistaFileNumber)
          .setString("vistaFieldNumber", vistaFieldNumber)
          .setTimestamp("startDate", startDate)
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
   }
    
    
    /**
     * Save.
     *
     * @param eplNdfOutgoingDifferences the epl ndf outgoing differences
     * @return the epl ndf outgoing differences
     */
    @Override
    public EplNdfOutgoingDifferences save(EplNdfOutgoingDifferences eplNdfOutgoingDifferences) {        
        EplNdfOutgoingDifferences differences = new EplNdfOutgoingDifferences();
        Session session = getSessionFactory().getCurrentSession();
        Long id = (Long) session.save(eplNdfOutgoingDifferences);
        differences = findById(id);
        return differences;
    }
    
    /**
     * update.
     *
     * @param eplNdfOutgoingDifferences the epl ndf outgoing differences
     * @return the epl ndf outgoing differences
     */
    @Override
    public EplNdfOutgoingDifferences update(EplNdfOutgoingDifferences eplNdfOutgoingDifferences) {
        Session session = getSessionFactory().getCurrentSession();
        session.update(eplNdfOutgoingDifferences);
        return eplNdfOutgoingDifferences;
    }
    
    /**
     * update outgoing diff table with fk .
     *
     * @param eplNdfOutgoingDifferences the epl ndf outgoing differences
     * @return the epl ndf outgoing differences
     */

    public void updateNdfUpdateFileFk(List<EplNdfOutgoingDifferences> returnedDifferences, NdfUpdateFileVo ndfUpdateFileVo) {
       
       for (EplNdfOutgoingDifferences eplNdfOutgoingDifferences : returnedDifferences) {
           
           eplNdfOutgoingDifferences.setNdcUpdateFileFk(ndfUpdateFileConverter.convert(ndfUpdateFileVo));
           update(eplNdfOutgoingDifferences);
       }
    }
    
    /**
     * remove the fk association between outgoing differences table and ndf update table.
     *
     * @param Long the file id to process
     * 
     */

    public void removeNdfUpdateFileFk(Long fileSeqNo) {
              
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.createQuery("update EplNdfOutgoingDifferences set ndcUpdateFileFk = null "
            + " where ndcUpdateFileFk = " + fileSeqNo);
        query.executeUpdate();
    }
       
      /*  
     * @return the sessionFactory
     */
    public SessionFactory getSessionFactory() {
        return sessionFactory;
    }

    /**
     * @param sessionFactory the sessionFactory to set
     */
    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    
    /**
     * @return the eplNdfUpdateFileDaoImpl
     */
    public NdfUpdateFileConverter getNdfUpdateFileConverter() {
        return ndfUpdateFileConverter;
    }

    
    /**
     * @param eplNdfUpdateFileDaoImpl the eplNdfUpdateFileDaoImpl to set
     */
    public void setNdfUpdateFileConverter(NdfUpdateFileConverter ndfUpdateFileConverter) {
        this.ndfUpdateFileConverter = ndfUpdateFileConverter;
    }

    /**
     * Find added products by file and field number
     *
     * @param vistaFileNumber the file number
     * @param vistaFieldNumber the field number
     * @return report data list, including classification
     */
    @Override
    public List<Object[]> findNewClassProducts(
            String vistaFileNumber, String vistaFieldNumber, Date startDTM) {
        Timestamp startDate = new Timestamp(startDTM.getTime());    
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("newClassReport")
          .setString("vistaFileNumber",vistaFileNumber)
          .setString("vistaFieldNumber", vistaFieldNumber)
          .setTimestamp("startDate", startDate)
          .setReadOnly(true);
        
        return (List<Object[]>) query.list();
    }
}
